/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.network.serializers;

import buildcraft.core.network.serializers.ClassSerializer;
import buildcraft.core.network.serializers.SerializationContext;
import buildcraft.core.utils.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class SerializerFluidStack
extends ClassSerializer {
    @Override
    public void write(ByteBuf data, Object o, SerializationContext context) {
        FluidStack stack = (FluidStack)o;
        if (stack == null) {
            data.writeBoolean(false);
        } else {
            data.writeShort(stack.getFluid().getID());
            data.writeInt(stack.amount);
            if (stack.tag == null) {
                data.writeBoolean(false);
            } else {
                data.writeBoolean(true);
                Utils.writeNBT(data, stack.tag);
            }
        }
    }

    @Override
    public Object read(ByteBuf data, Object o, SerializationContext context) {
        if (!data.readBoolean()) {
            return null;
        }
        short id = data.readShort();
        int amount = data.readerIndex();
        NBTTagCompound nbt = null;
        if (data.readBoolean()) {
            nbt = Utils.readNBT(data);
            return new FluidStack((int)id, amount, nbt);
        }
        return new FluidStack((int)id, amount);
    }
}

