/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.robots;

import buildcraft.api.core.SafeTimeTracker;
import buildcraft.core.DefaultProps;
import buildcraft.core.LaserData;
import buildcraft.core.robots.AIBase;
import buildcraft.core.robots.IRobotTask;
import buildcraft.core.robots.RobotTaskProviderRegistry;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityRobot
extends EntityLivingBase
implements IEntityAdditionalSpawnData {
    private static ResourceLocation defaultTexture = new ResourceLocation("buildcraft", DefaultProps.TEXTURE_PATH_ENTITIES + "/robot_base.png");
    public SafeTimeTracker scanForTasks = new SafeTimeTracker(40L, 10L);
    public LaserData laser = new LaserData();
    public AIBase currentAI;
    public IRobotTask currentTask;
    public DockingStation dockingStation = new DockingStation();
    private boolean needsUpdate = false;

    public EntityRobot(World par1World) {
        super(par1World);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70158_ak = true;
        this.laser.isVisible = false;
        this.field_70130_N = 0.5f;
        this.field_70131_O = 0.5f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70156_m = false;
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.field_70180_af.func_75682_a(10, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(11, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(12, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(13, (Object)0);
        this.field_70180_af.func_75682_a(14, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(15, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(16, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_75682_a(17, (Object)0);
    }

    protected void updateDataClient() {
        this.laser.tail.x = this.field_70180_af.func_111145_d(10);
        this.laser.tail.y = this.field_70180_af.func_111145_d(11);
        this.laser.tail.z = this.field_70180_af.func_111145_d(12);
        this.laser.isVisible = this.field_70180_af.func_75683_a(13) == 1;
    }

    protected void updateDataServer() {
        this.field_70180_af.func_75692_b(10, (Object)Float.valueOf((float)this.laser.tail.x));
        this.field_70180_af.func_75692_b(11, (Object)Float.valueOf((float)this.laser.tail.y));
        this.field_70180_af.func_75692_b(12, (Object)Float.valueOf((float)this.laser.tail.z));
        this.field_70180_af.func_75692_b(13, (Object)((byte)(this.laser.isVisible ? 1 : 0)));
    }

    protected void init() {
    }

    public void setLaserDestination(float x, float y, float z) {
        if ((double)x != this.laser.tail.x || (double)y != this.laser.tail.y || (double)z != this.laser.tail.z) {
            this.laser.tail.x = x;
            this.laser.tail.y = y;
            this.laser.tail.z = z;
            this.needsUpdate = true;
        }
    }

    public void showLaser() {
        if (!this.laser.isVisible) {
            this.laser.isVisible = true;
            this.needsUpdate = true;
        }
    }

    public void hideLaser() {
        if (this.laser.isVisible) {
            this.laser.isVisible = false;
            this.needsUpdate = true;
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.needsUpdate) {
            this.updateDataServer();
            this.needsUpdate = false;
        }
        if (this.field_70170_p.field_72995_K) {
            this.updateDataClient();
        }
        if (this.currentAI != null) {
            this.currentAI.update(this);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.currentTask == null) {
                if (this.scanForTasks.markTimeIfDelay(this.field_70170_p)) {
                    RobotTaskProviderRegistry.scanForTask(this);
                }
            } else if (this.currentTask.done()) {
                this.currentTask = null;
            } else {
                this.currentTask.update(this);
            }
        }
        super.func_70071_h_();
    }

    public void setRegularBoundingBox() {
        this.field_70130_N = 0.5f;
        this.field_70131_O = 0.5f;
        if (this.laser.isVisible) {
            this.field_70121_D.field_72340_a = Math.min(this.field_70165_t, this.laser.tail.x);
            this.field_70121_D.field_72338_b = Math.min(this.field_70163_u, this.laser.tail.y);
            this.field_70121_D.field_72339_c = Math.min(this.field_70161_v, this.laser.tail.z);
            this.field_70121_D.field_72336_d = Math.max(this.field_70165_t, this.laser.tail.x);
            this.field_70121_D.field_72337_e = Math.max(this.field_70163_u, this.laser.tail.y);
            this.field_70121_D.field_72334_f = Math.max(this.field_70161_v, this.laser.tail.z);
            this.field_70121_D.field_72340_a -= 1.0;
            this.field_70121_D.field_72338_b -= 1.0;
            this.field_70121_D.field_72339_c -= 1.0;
            this.field_70121_D.field_72336_d += 1.0;
            this.field_70121_D.field_72337_e += 1.0;
            this.field_70121_D.field_72334_f += 1.0;
        } else {
            this.field_70121_D.field_72340_a = this.field_70165_t - 0.25;
            this.field_70121_D.field_72338_b = this.field_70163_u - 0.25;
            this.field_70121_D.field_72339_c = this.field_70161_v - 0.25;
            this.field_70121_D.field_72336_d = this.field_70165_t + 0.25;
            this.field_70121_D.field_72337_e = this.field_70163_u + 0.25;
            this.field_70121_D.field_72334_f = this.field_70161_v + 0.25;
        }
    }

    public void setNullBoundingBox() {
        this.field_70130_N = 0.0f;
        this.field_70131_O = 0.0f;
        this.field_70121_D.field_72340_a = this.field_70165_t;
        this.field_70121_D.field_72338_b = this.field_70163_u;
        this.field_70121_D.field_72339_c = this.field_70161_v;
        this.field_70121_D.field_72336_d = this.field_70165_t;
        this.field_70121_D.field_72337_e = this.field_70163_u;
        this.field_70121_D.field_72334_f = this.field_70161_v;
    }

    private void iterateBehaviorDocked() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.setNullBoundingBox();
    }

    protected void move() {
    }

    public void writeSpawnData(ByteBuf data) {
    }

    public void readSpawnData(ByteBuf data) {
        this.init();
    }

    public ItemStack func_70694_bm() {
        return null;
    }

    public void func_70062_b(int i, ItemStack itemstack) {
    }

    public ItemStack[] func_70035_c() {
        return new ItemStack[0];
    }

    protected void func_70069_a(float par1) {
    }

    protected void func_70064_a(double par1, boolean par3) {
    }

    public void func_70612_e(float par1, float par2) {
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
    }

    public boolean func_70617_f_() {
        return false;
    }

    public ResourceLocation getTexture() {
        return defaultTexture;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("dockX", this.dockingStation.x);
        nbt.func_74768_a("dockY", this.dockingStation.y);
        nbt.func_74768_a("dockZ", this.dockingStation.z);
        nbt.func_74768_a("dockSide", this.dockingStation.side.ordinal());
        if (this.currentAI != null) {
            nbt.func_74778_a("ai", this.currentAI.getClass().getCanonicalName());
        }
        NBTTagCompound nbtLaser = new NBTTagCompound();
        this.laser.writeToNBT(nbtLaser);
        nbt.func_74782_a("laser", (NBTBase)nbtLaser);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.dockingStation.x = nbt.func_74762_e("dockX");
        this.dockingStation.y = nbt.func_74762_e("dockY");
        this.dockingStation.z = nbt.func_74762_e("dockZ");
        this.dockingStation.side = ForgeDirection.values()[nbt.func_74762_e("dockSide")];
        if (nbt.func_74764_b("ai")) {
            try {
                this.currentAI = (AIBase)Class.forName(nbt.func_74779_i("ai")).newInstance();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.laser.readFromNBT(nbt.func_74775_l("laser"));
    }

    public void setDockingStation(TileGenericPipe tile, ForgeDirection side) {
        this.dockingStation.x = tile.field_145851_c;
        this.dockingStation.y = tile.field_145848_d;
        this.dockingStation.z = tile.field_145849_e;
        this.dockingStation.side = side;
    }

    public ItemStack func_71124_b(int var1) {
        return null;
    }

    public boolean acceptTask(IRobotTask task) {
        return false;
    }

    public class DockingStation {
        public int x;
        public int y;
        public int z;
        public ForgeDirection side;
    }
}

