/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy.triggers;

import buildcraft.api.gates.ITileTrigger;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.triggers.BCTrigger;
import buildcraft.core.utils.StringUtils;
import buildcraft.energy.TileEngine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TriggerEngineHeat
extends BCTrigger
implements ITileTrigger {
    public TileEngine.EnergyStage stage;
    @SideOnly(value=Side.CLIENT)
    private IIcon icon;

    public TriggerEngineHeat(TileEngine.EnergyStage stage) {
        super("buildcraft:engine.stage." + stage.name().toLowerCase(Locale.ENGLISH), "buildcraft.engine.stage." + stage.name().toLowerCase(Locale.ENGLISH));
        this.stage = stage;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.trigger.engine." + this.stage.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (tile instanceof TileEngine) {
            TileEngine engine = (TileEngine)tile;
            return engine.getEnergyStage() == this.stage;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.icon;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.func_94245_a("buildcraft:triggers/trigger_engineheat_" + this.stage.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public ITrigger rotateLeft() {
        return this;
    }
}

