/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.factory;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.IAction;
import buildcraft.api.mj.MjBattery;
import buildcraft.core.IMachine;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.fluids.SingleUseTank;
import buildcraft.core.fluids.Tank;
import buildcraft.core.fluids.TankManager;
import buildcraft.core.network.PacketPayload;
import buildcraft.core.network.PacketUpdate;
import buildcraft.core.recipes.RefineryRecipeManager;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileRefinery
extends TileBuildCraft
implements IFluidHandler,
IInventory,
IMachine {
    public static int LIQUID_PER_SLOT = 4000;
    public SingleUseTank tank1 = new SingleUseTank("tank1", LIQUID_PER_SLOT, this);
    public SingleUseTank tank2 = new SingleUseTank("tank2", LIQUID_PER_SLOT, this);
    public SingleUseTank result = new SingleUseTank("result", LIQUID_PER_SLOT, this);
    public TankManager<SingleUseTank> tankManager = new TankManager((Tank[])new SingleUseTank[]{this.tank1, this.tank2, this.result});
    public float animationSpeed = 1.0f;
    private int animationStage = 0;
    private SafeTimeTracker time = new SafeTimeTracker();
    private SafeTimeTracker updateNetworkTime = new SafeTimeTracker();
    private boolean isActive;
    @MjBattery(maxCapacity=1000.0, maxReceivedPerCycle=150.0, minimumConsumption=1.0)
    private double mjStored = 0.0;

    public int func_70302_i_() {
        return 0;
    }

    public ItemStack func_70301_a(int i) {
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
    }

    public String func_145825_b() {
        return null;
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.simpleAnimationIterate();
            return;
        }
        if (this.updateNetworkTime.markTimeIfDelay(this.field_145850_b, BuildCraftCore.updateFactor)) {
            this.sendNetworkUpdate();
        }
        this.isActive = false;
        RefineryRecipeManager.RefineryRecipe currentRecipe = RefineryRecipeManager.INSTANCE.findRefineryRecipe(this.tank1.getFluid(), this.tank2.getFluid());
        if (currentRecipe == null) {
            this.decreaseAnimation();
            return;
        }
        if (this.result.fill(currentRecipe.result.copy(), false) != currentRecipe.result.amount) {
            this.decreaseAnimation();
            return;
        }
        if (!this.containsInput(currentRecipe.ingredient1) || !this.containsInput(currentRecipe.ingredient2)) {
            this.decreaseAnimation();
            return;
        }
        this.isActive = true;
        if (this.mjStored >= (double)currentRecipe.energyCost) {
            this.increaseAnimation();
        } else {
            this.decreaseAnimation();
        }
        if (!this.time.markTimeIfDelay(this.field_145850_b, currentRecipe.timeRequired)) {
            return;
        }
        if (this.mjStored >= (double)currentRecipe.energyCost) {
            this.mjStored -= (double)currentRecipe.energyCost;
            if (this.consumeInput(currentRecipe.ingredient1) && this.consumeInput(currentRecipe.ingredient2)) {
                this.result.fill(currentRecipe.result, true);
            }
        }
    }

    private boolean containsInput(FluidStack ingredient) {
        if (ingredient == null) {
            return true;
        }
        return this.tank1.getFluid() != null && this.tank1.getFluid().containsFluid(ingredient) || this.tank2.getFluid() != null && this.tank2.getFluid().containsFluid(ingredient);
    }

    private boolean consumeInput(FluidStack liquid) {
        if (liquid == null) {
            return true;
        }
        if (this.tank1.getFluid() != null && this.tank1.getFluid().containsFluid(liquid)) {
            this.tank1.drain(liquid.amount, true);
            return true;
        }
        if (this.tank2.getFluid() != null && this.tank2.getFluid().containsFluid(liquid)) {
            this.tank2.drain(liquid.amount, true);
            return true;
        }
        return false;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public boolean manageFluids() {
        return true;
    }

    @Override
    public boolean manageSolids() {
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tankManager.readFromNBT(data);
        this.animationStage = data.func_74762_e("animationStage");
        this.animationSpeed = data.func_74760_g("animationSpeed");
        this.mjStored = data.func_74769_h("mjStored");
    }

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tankManager.writeToNBT(data);
        data.func_74768_a("animationStage", this.animationStage);
        data.func_74776_a("animationSpeed", this.animationSpeed);
        data.func_74780_a("mjStored", this.mjStored);
    }

    public int getAnimationStage() {
        return this.animationStage;
    }

    public void simpleAnimationIterate() {
        if (this.animationSpeed > 1.0f) {
            this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = 100;
            }
        } else if (this.animationStage > 0) {
            --this.animationStage;
        }
    }

    public void increaseAnimation() {
        if (this.animationSpeed < 2.0f) {
            this.animationSpeed = 2.0f;
        } else if (this.animationSpeed <= 5.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed + 0.1);
        }
        this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
        if (this.animationStage > 300) {
            this.animationStage = 100;
        }
    }

    public void decreaseAnimation() {
        if (this.animationSpeed >= 1.0f) {
            this.animationSpeed = (float)((double)this.animationSpeed - 0.1);
            this.animationStage = (int)((float)this.animationStage + this.animationSpeed);
            if (this.animationStage > 300) {
                this.animationStage = 100;
            }
        } else if (this.animationStage > 0) {
            --this.animationStage;
        }
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void resetFilters() {
        for (SingleUseTank tank : this.tankManager) {
            tank.setAcceptedFluid(null);
        }
    }

    public void setFilter(int number, Fluid fluid) {
        ((SingleUseTank)((Object)this.tankManager.get(number))).setAcceptedFluid(fluid);
    }

    public Fluid getFilter(int number) {
        return ((SingleUseTank)((Object)this.tankManager.get(number))).getAcceptedFluid();
    }

    @Override
    public boolean allowAction(IAction action) {
        return false;
    }

    public void getGUINetworkData(int id, int data) {
        switch (id) {
            case 0: {
                this.setFilter(0, FluidRegistry.getFluid((int)data));
                break;
            }
            case 1: {
                this.setFilter(1, FluidRegistry.getFluid((int)data));
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        if (this.getFilter(0) != null) {
            iCrafting.func_71112_a(container, 0, this.getFilter(0).getID());
        }
        if (this.getFilter(1) != null) {
            iCrafting.func_71112_a(container, 1, this.getFilter(1).getID());
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        FluidStack resourceUsing = resource.copy();
        resourceUsing.amount -= (used += this.tank1.fill(resourceUsing, doFill));
        return used += this.tank2.fill(resourceUsing, doFill);
    }

    public FluidStack drain(ForgeDirection from, int maxEmpty, boolean doDrain) {
        return this.result.drain(maxEmpty, doDrain);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.result.getFluid())) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection direction) {
        return this.tankManager.getTankInfo(direction);
    }

    @Override
    public PacketPayload getPacketPayload() {
        PacketPayload payload = new PacketPayload(new PacketPayload.StreamWriter(){

            @Override
            public void writeData(ByteBuf data) {
                data.writeFloat(TileRefinery.this.animationSpeed);
                TileRefinery.this.tankManager.writeData(data);
            }
        });
        return payload;
    }

    @Override
    public void handleUpdatePacket(PacketUpdate packet) throws IOException {
        ByteBuf stream = packet.payload.stream;
        this.animationSpeed = stream.readFloat();
        this.tankManager.readData(stream);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean func_145818_k_() {
        return false;
    }
}

