/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.NetworkData;
import buildcraft.api.core.Position;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.IActionReceptor;
import buildcraft.api.mj.MjBattery;
import buildcraft.api.power.ILaserTarget;
import buildcraft.core.Box;
import buildcraft.core.EntityLaser;
import buildcraft.core.IMachine;
import buildcraft.core.LaserData;
import buildcraft.core.TileBuildCraft;
import buildcraft.core.triggers.ActionMachineControl;
import java.util.LinkedList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class TileLaser
extends TileBuildCraft
implements IActionReceptor,
IMachine {
    private static final float LASER_OFFSET = 0.125f;
    private static final short POWER_AVERAGING = 100;
    @NetworkData
    public LaserData laser = new LaserData();
    private final SafeTimeTracker laserTickTracker = new SafeTimeTracker(10L);
    private final SafeTimeTracker searchTracker = new SafeTimeTracker(100L, 100L);
    private final SafeTimeTracker networkTracker = new SafeTimeTracker(20L, 3L);
    private ILaserTarget laserTarget;
    private ActionMachineControl.Mode lastMode = ActionMachineControl.Mode.Unknown;
    private int powerIndex = 0;
    @MjBattery(maxCapacity=1000.0, maxReceivedPerCycle=25.0, minimumConsumption=1.0)
    private double mjStored = 0.0;
    @NetworkData
    private double powerAverage = 0.0;
    private final double[] power = new double[100];

    @Override
    public void initialize() {
        super.initialize();
        this.laser.isVisible = false;
        this.laser.head = new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.laser.tail = new Position(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        this.laser.iterateTexture();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.lastMode == ActionMachineControl.Mode.Off) {
            this.removeLaser();
            return;
        }
        if (this.canFindTable()) {
            this.findTable();
        }
        if (!this.isValidTable()) {
            this.removeLaser();
            return;
        }
        if (this.mjStored == 0.0) {
            this.removeLaser();
            return;
        }
        this.laser.isVisible = true;
        if (this.laser != null && this.canUpdateLaser()) {
            this.updateLaser();
        }
        double localPower = this.mjStored > (double)this.getMaxPowerSent() ? (double)this.getMaxPowerSent() : this.mjStored;
        this.mjStored -= localPower;
        this.laserTarget.receiveLaserEnergy(localPower);
        if (this.laser != null) {
            this.pushPower(localPower);
        }
        this.onPowerSent(localPower);
        this.sendNetworkUpdate();
    }

    protected float getMaxPowerSent() {
        return 4.0f;
    }

    protected void onPowerSent(double power) {
    }

    protected boolean canFindTable() {
        return this.searchTracker.markTimeIfDelay(this.field_145850_b);
    }

    protected boolean canUpdateLaser() {
        return this.laserTickTracker.markTimeIfDelay(this.field_145850_b);
    }

    protected boolean isValidTable() {
        return this.laserTarget != null && !this.laserTarget.isInvalidTarget() && this.laserTarget.requiresLaserEnergy();
    }

    protected void findTable() {
        int meta = this.func_145832_p();
        int minX = this.field_145851_c - 5;
        int minY = this.field_145848_d - 5;
        int minZ = this.field_145849_e - 5;
        int maxX = this.field_145851_c + 5;
        int maxY = this.field_145848_d + 5;
        int maxZ = this.field_145849_e + 5;
        switch (ForgeDirection.getOrientation((int)meta)) {
            case WEST: {
                maxX = this.field_145851_c;
                break;
            }
            case EAST: {
                minX = this.field_145851_c;
                break;
            }
            case DOWN: {
                maxY = this.field_145848_d;
                break;
            }
            case UP: {
                minY = this.field_145848_d;
                break;
            }
            case NORTH: {
                maxZ = this.field_145849_e;
                break;
            }
            default: {
                minZ = this.field_145849_e;
            }
        }
        LinkedList<ILaserTarget> targets = new LinkedList<ILaserTarget>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ILaserTarget table;
                    TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
                    if (!(tile instanceof ILaserTarget) || !(table = (ILaserTarget)tile).requiresLaserEnergy()) continue;
                    targets.add(table);
                }
            }
        }
        if (targets.isEmpty()) {
            return;
        }
        this.laserTarget = (ILaserTarget)targets.get(this.field_145850_b.field_73012_v.nextInt(targets.size()));
    }

    protected void updateLaser() {
        int meta = this.func_145832_p();
        double px = 0.0;
        double py = 0.0;
        double pz = 0.0;
        switch (ForgeDirection.getOrientation((int)meta)) {
            case WEST: {
                px = -0.125;
                break;
            }
            case EAST: {
                px = 0.125;
                break;
            }
            case DOWN: {
                py = -0.125;
                break;
            }
            case UP: {
                py = 0.125;
                break;
            }
            case NORTH: {
                pz = -0.125;
                break;
            }
            default: {
                pz = 0.125;
            }
        }
        Position head = new Position((double)this.field_145851_c + 0.5 + px, (double)this.field_145848_d + 0.5 + py, (double)this.field_145849_e + 0.5 + pz);
        Position tail = new Position((double)this.laserTarget.getXCoord() + 0.475 + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) / 5.0, (float)this.laserTarget.getYCoord() + 0.5625f, (double)this.laserTarget.getZCoord() + 0.475 + ((double)this.field_145850_b.field_73012_v.nextFloat() - 0.5) / 5.0);
        this.laser.head = head;
        this.laser.tail = tail;
        if (!this.laser.isVisible) {
            this.laser.isVisible = true;
        }
    }

    protected void removeLaser() {
        this.laser.isVisible = false;
        super.sendNetworkUpdate();
    }

    @Override
    public void sendNetworkUpdate() {
        if (this.networkTracker.markTimeIfDelay(this.field_145850_b)) {
            super.sendNetworkUpdate();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.mjStored = nbttagcompound.func_74769_h("mjStored");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74780_a("mjStored", this.mjStored);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.removeLaser();
    }

    @Override
    public boolean isActive() {
        return this.isValidTable();
    }

    @Override
    public boolean manageFluids() {
        return false;
    }

    @Override
    public boolean manageSolids() {
        return false;
    }

    @Override
    public boolean allowAction(IAction action) {
        return action == BuildCraftCore.actionOn || action == BuildCraftCore.actionOff;
    }

    @Override
    public void actionActivated(IAction action) {
        if (action == BuildCraftCore.actionOn) {
            this.lastMode = ActionMachineControl.Mode.On;
        } else if (action == BuildCraftCore.actionOff) {
            this.lastMode = ActionMachineControl.Mode.Off;
        }
    }

    private void pushPower(double received) {
        this.powerAverage -= this.power[this.powerIndex];
        this.powerAverage += received;
        this.power[this.powerIndex] = received;
        ++this.powerIndex;
        if (this.powerIndex == this.power.length) {
            this.powerIndex = 0;
        }
    }

    public ResourceLocation getTexture() {
        double avg = this.powerAverage / 100.0;
        if (avg <= 1.0) {
            return EntityLaser.LASER_TEXTURES[0];
        }
        if (avg <= 2.0) {
            return EntityLaser.LASER_TEXTURES[1];
        }
        if (avg <= 3.0) {
            return EntityLaser.LASER_TEXTURES[2];
        }
        return EntityLaser.LASER_TEXTURES[3];
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Box(this).extendToEncompass(this.laser.tail).getBoundingBox();
    }
}

