/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.network;

import buildcraft.core.network.BuildCraftPacket;
import buildcraft.core.network.PacketCoordinates;
import buildcraft.core.network.PacketNBT;
import buildcraft.core.network.PacketSlotChange;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.silicon.TileAdvancedCraftingTable;
import buildcraft.silicon.TileAssemblyTable;
import buildcraft.silicon.gui.ContainerAssemblyTable;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.network.INetHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

@ChannelHandler.Sharable
public class PacketHandlerSilicon
extends SimpleChannelInboundHandler<BuildCraftPacket> {
    protected void channelRead0(ChannelHandlerContext ctx, BuildCraftPacket packet) {
        try {
            INetHandler netHandler = (INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
            EntityPlayer player = CoreProxy.proxy.getPlayerFromNetHandler(netHandler);
            int packetID = packet.getID();
            switch (packetID) {
                case 22: {
                    this.onSelectionUpdate(player, (PacketNBT)packet);
                    break;
                }
                case 21: {
                    this.onAssemblySelect(player, (PacketNBT)packet);
                    break;
                }
                case 20: {
                    this.onAssemblyGetSelection(player, (PacketCoordinates)packet);
                    break;
                }
                case 70: {
                    this.onAdvancedWorkbenchSet(player, (PacketSlotChange)packet);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onSelectionUpdate(EntityPlayer player, PacketNBT packet) {
        Container container = player.field_71070_bA;
        if (container instanceof ContainerAssemblyTable) {
            TileAssemblyTable.SelectionMessage message = new TileAssemblyTable.SelectionMessage();
            message.fromNBT(packet.getTagCompound());
            ((ContainerAssemblyTable)container).handleSelectionMessage(message);
        }
    }

    private TileAssemblyTable getAssemblyTable(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileAssemblyTable)) {
            return null;
        }
        return (TileAssemblyTable)tile;
    }

    private TileAdvancedCraftingTable getAdvancedWorkbench(World world, int x, int y, int z) {
        if (!world.func_72899_e(x, y, z)) {
            return null;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileAdvancedCraftingTable)) {
            return null;
        }
        return (TileAdvancedCraftingTable)tile;
    }

    private void onAssemblyGetSelection(EntityPlayer player, PacketCoordinates packet) {
        TileAssemblyTable tile = this.getAssemblyTable(player.field_70170_p, packet.posX, packet.posY, packet.posZ);
        if (tile == null) {
            return;
        }
        tile.sendSelectionTo(player);
    }

    private void onAssemblySelect(EntityPlayer player, PacketNBT packetA) {
        TileAssemblyTable tile = this.getAssemblyTable(player.field_70170_p, packetA.posX, packetA.posY, packetA.posZ);
        if (tile == null) {
            return;
        }
        TileAssemblyTable.SelectionMessage message = new TileAssemblyTable.SelectionMessage();
        message.fromNBT(packetA.getTagCompound());
        tile.handleSelectionMessage(message);
    }

    private void onAdvancedWorkbenchSet(EntityPlayer player, PacketSlotChange packet1) {
        TileAdvancedCraftingTable tile = this.getAdvancedWorkbench(player.field_70170_p, packet1.posX, packet1.posY, packet1.posZ);
        if (tile == null) {
            return;
        }
        tile.updateCraftingMatrix(packet1.slot, packet1.stack);
    }
}

