/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.IIconProvider;
import buildcraft.api.gates.IAction;
import buildcraft.api.gates.ITrigger;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.IDropControlInventory;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.network.TilePacketWrapper;
import buildcraft.core.utils.Utils;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.Gate;
import buildcraft.transport.PipeConnectionBans;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportStructure;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.gates.GateFactory;
import buildcraft.transport.pipes.events.PipeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class Pipe<T extends PipeTransport>
implements IDropControlInventory {
    private static Map<Class, TilePacketWrapper> networkWrappers = new HashMap<Class, TilePacketWrapper>();
    private static Map<Class<? extends Pipe>, Map<Class<? extends PipeEvent>, EventHandler>> eventHandlers = new HashMap<Class<? extends Pipe>, Map<Class<? extends PipeEvent>, EventHandler>>();
    public int[] signalStrength = new int[]{0, 0, 0, 0};
    public TileGenericPipe container;
    public final T transport;
    public final Item item;
    public boolean[] wireSet = new boolean[]{false, false, false, false};
    public Gate gate;
    private boolean internalUpdateScheduled = false;
    private boolean initialized = false;

    public Pipe(T transport, Item item) {
        this.transport = transport;
        this.item = item;
        if (!networkWrappers.containsKey(this.getClass())) {
            networkWrappers.put(this.getClass(), new TilePacketWrapper(new Class[]{TileGenericPipe.class, this.transport.getClass()}));
        }
    }

    public void setTile(TileEntity tile) {
        this.container = (TileGenericPipe)tile;
        ((PipeTransport)this.transport).setTile((TileGenericPipe)tile);
    }

    public final void handlePipeEvent(PipeEvent event) {
        EventHandler handler;
        Map<Class<? extends PipeEvent>, EventHandler> handlerMap = eventHandlers.get(this.getClass());
        if (handlerMap == null) {
            handlerMap = new HashMap<Class<? extends PipeEvent>, EventHandler>();
            eventHandlers.put(this.getClass(), handlerMap);
        }
        if ((handler = handlerMap.get(event.getClass())) == null) {
            handler = this.makeEventHandler(event, handlerMap);
        }
        if (handler.method == null) {
            return;
        }
        try {
            handler.method.invoke((Object)this, event);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private EventHandler makeEventHandler(PipeEvent event, Map<Class<? extends PipeEvent>, EventHandler> handlerMap) {
        EventHandler handler;
        try {
            Method method = this.getClass().getDeclaredMethod("eventHandler", event.getClass());
            handler = new EventHandler(method);
        }
        catch (Exception ex) {
            handler = new EventHandler(null);
        }
        handlerMap.put(event.getClass(), handler);
        return handler;
    }

    public boolean blockActivated(EntityPlayer entityplayer) {
        return false;
    }

    public void onBlockPlaced() {
        ((PipeTransport)this.transport).onBlockPlaced();
    }

    public void onBlockPlacedBy(EntityLivingBase placer) {
    }

    public void onNeighborBlockChange(int blockId) {
        ((PipeTransport)this.transport).onNeighborBlockChange(blockId);
        this.updateSignalState();
    }

    public boolean canPipeConnect(TileEntity tile, ForgeDirection side) {
        if (tile instanceof TileGenericPipe) {
            Pipe otherPipe = ((TileGenericPipe)tile).pipe;
            if (!BlockGenericPipe.isFullyDefined(otherPipe)) {
                return false;
            }
            if (!PipeConnectionBans.canPipesConnect(this.getClass(), otherPipe.getClass())) {
                return false;
            }
        }
        return ((PipeTransport)this.transport).canPipeConnect(tile, side);
    }

    public int getIconIndexForItem() {
        return this.getIconIndex(ForgeDirection.UNKNOWN);
    }

    @SideOnly(value=Side.CLIENT)
    public abstract IIconProvider getIconProvider();

    public abstract int getIconIndex(ForgeDirection var1);

    public void updateEntity() {
        ((PipeTransport)this.transport).updateEntity();
        if (this.internalUpdateScheduled) {
            this.internalUpdate();
            this.internalUpdateScheduled = false;
        }
        if (this.gate != null) {
            if (this.container.func_145831_w().field_72995_K) {
                this.gate.updatePulse();
            } else {
                this.gate.resolveActions();
                this.gate.tick();
            }
        }
    }

    private void internalUpdate() {
        this.updateSignalState();
    }

    public void writeToNBT(NBTTagCompound data) {
        ((PipeTransport)this.transport).writeToNBT(data);
        if (this.gate != null) {
            NBTTagCompound gateNBT = new NBTTagCompound();
            this.gate.writeToNBT(gateNBT);
            data.func_74782_a("Gate", (NBTBase)gateNBT);
        }
        for (int i = 0; i < 4; ++i) {
            data.func_74757_a("wireSet[" + i + "]", this.wireSet[i]);
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        ((PipeTransport)this.transport).readFromNBT(data);
        if (data.func_74764_b("Gate")) {
            NBTTagCompound gateNBT = data.func_74775_l("Gate");
            this.gate = GateFactory.makeGate(this, gateNBT);
        }
        for (int i = 0; i < 4; ++i) {
            this.wireSet[i] = data.func_74767_n("wireSet[" + i + "]");
        }
    }

    public boolean needsInit() {
        return !this.initialized;
    }

    public void initialize() {
        ((PipeTransport)this.transport).initialize();
        this.updateSignalState();
        this.initialized = true;
    }

    private void readNearbyPipesSignal(PipeWire color) {
        TileGenericPipe tilePipe;
        TileEntity tile;
        boolean foundBiggerSignal = false;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            tile = this.container.getTile(o);
            if (!(tile instanceof TileGenericPipe)) continue;
            tilePipe = (TileGenericPipe)tile;
            if (!BlockGenericPipe.isFullyDefined(tilePipe.pipe) || !this.isWireConnectedTo(tile, color)) continue;
            foundBiggerSignal |= this.receiveSignal(tilePipe.pipe.signalStrength[color.ordinal()] - 1, color);
        }
        if (!foundBiggerSignal && this.signalStrength[color.ordinal()] != 0) {
            this.signalStrength[color.ordinal()] = 0;
            this.container.scheduleRenderUpdate();
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                tile = this.container.getTile(o);
                if (!(tile instanceof TileGenericPipe)) continue;
                tilePipe = (TileGenericPipe)tile;
                if (!BlockGenericPipe.isFullyDefined(tilePipe.pipe)) continue;
                tilePipe.pipe.internalUpdateScheduled = true;
            }
        }
    }

    public void updateSignalState() {
        for (PipeWire c : PipeWire.values()) {
            this.updateSignalStateForColor(c);
        }
    }

    private void updateSignalStateForColor(PipeWire wire) {
        if (!this.wireSet[wire.ordinal()]) {
            return;
        }
        if (this.gate != null && this.gate.broadcastSignal.get(wire.ordinal())) {
            this.receiveSignal(255, wire);
        } else {
            this.readNearbyPipesSignal(wire);
        }
        if (this.signalStrength[wire.ordinal()] > 1) {
            for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = this.container.getTile(o);
                if (!(tile instanceof TileGenericPipe)) continue;
                TileGenericPipe tilePipe = (TileGenericPipe)tile;
                if (!BlockGenericPipe.isFullyDefined(tilePipe.pipe) || !tilePipe.pipe.wireSet[wire.ordinal()] || !this.isWireConnectedTo(tile, wire)) continue;
                tilePipe.pipe.receiveSignal(this.signalStrength[wire.ordinal()] - 1, wire);
            }
        }
    }

    private boolean receiveSignal(int signal, PipeWire color) {
        if (this.container.func_145831_w() == null) {
            return false;
        }
        int oldSignal = this.signalStrength[color.ordinal()];
        if (signal >= this.signalStrength[color.ordinal()] && signal != 0) {
            this.signalStrength[color.ordinal()] = signal;
            this.internalUpdateScheduled = true;
            if (oldSignal == 0) {
                this.container.scheduleRenderUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean inputOpen(ForgeDirection from) {
        return ((PipeTransport)this.transport).inputOpen(from);
    }

    public boolean outputOpen(ForgeDirection to) {
        return ((PipeTransport)this.transport).outputOpen(to);
    }

    public void onEntityCollidedWithBlock(Entity entity) {
    }

    public boolean canConnectRedstone() {
        return this.hasGate();
    }

    public int isPoweringTo(int side) {
        if (this.gate != null && this.gate.getRedstoneOutput() > 0) {
            ForgeDirection o = ForgeDirection.getOrientation((int)side).getOpposite();
            TileEntity tile = this.container.getTile(o);
            if (tile instanceof TileGenericPipe && this.container.isPipeConnected(o)) {
                return 0;
            }
            return this.gate.getRedstoneOutput();
        }
        return 0;
    }

    public int isIndirectlyPoweringTo(int l) {
        return this.isPoweringTo(l);
    }

    public void randomDisplayTick(Random random) {
    }

    public boolean isWired() {
        for (PipeWire color : PipeWire.values()) {
            if (!this.isWired(color)) continue;
            return true;
        }
        return false;
    }

    public boolean isWired(PipeWire color) {
        return this.wireSet[color.ordinal()];
    }

    public boolean hasGate() {
        return this.gate != null;
    }

    public boolean hasGate(ForgeDirection side) {
        if (!this.hasGate()) {
            return false;
        }
        if (this.container.hasFacade(side)) {
            return false;
        }
        if (this.container.hasPlug(side)) {
            return false;
        }
        if (this.container.hasRobotStation(side)) {
            return false;
        }
        int connections = 0;
        ForgeDirection targetOrientation = ForgeDirection.UNKNOWN;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(o) || ++connections != 1) continue;
            targetOrientation = o;
        }
        if (connections > 1 || connections == 0) {
            return true;
        }
        return targetOrientation.getOpposite() != side;
    }

    protected void notifyBlocksOfNeighborChange(ForgeDirection side) {
        this.container.func_145831_w().func_147459_d(this.container.field_145851_c + side.offsetX, this.container.field_145848_d + side.offsetY, this.container.field_145849_e + side.offsetZ, (Block)BuildCraftTransport.genericPipeBlock);
    }

    protected void updateNeighbors(boolean needSelf) {
        if (needSelf) {
            this.container.func_145831_w().func_147459_d(this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e, (Block)BuildCraftTransport.genericPipeBlock);
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            this.notifyBlocksOfNeighborChange(side);
        }
    }

    public void dropItem(ItemStack stack) {
        InvUtils.dropItems(this.container.func_145831_w(), stack, this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
    }

    public void onBlockRemoval() {
        if (this.getWorld().func_72912_H().func_76077_q() != WorldSettings.GameType.CREATIVE) {
            for (ItemStack stack : this.computeItemDrop()) {
                this.dropItem(stack);
            }
        }
    }

    public ArrayList<ItemStack> computeItemDrop() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (PipeWire pipeWire : PipeWire.VALUES) {
            if (!this.wireSet[pipeWire.ordinal()]) continue;
            result.add(pipeWire.getStack());
        }
        if (this.hasGate()) {
            result.add(this.gate.getGateItem());
        }
        for (PipeWire pipeWire : ForgeDirection.VALID_DIRECTIONS) {
            if (this.container.hasFacade((ForgeDirection)pipeWire)) {
                result.add(this.container.getFacade((ForgeDirection)pipeWire));
            }
            if (this.container.hasPlug((ForgeDirection)pipeWire)) {
                result.add(new ItemStack(BuildCraftTransport.plugItem));
            }
            if (!this.container.hasRobotStation((ForgeDirection)pipeWire)) continue;
            result.add(new ItemStack(BuildCraftTransport.robotStationItem));
        }
        return result;
    }

    public boolean isTriggerActive(ITrigger trigger) {
        return false;
    }

    public LinkedList<IAction> getActions() {
        LinkedList<IAction> result = new LinkedList<IAction>();
        if (this.hasGate()) {
            this.gate.addActions(result);
        }
        return result;
    }

    public void resetGate() {
        this.gate.resetGate();
        this.gate = null;
        this.container.scheduleRenderUpdate();
    }

    protected void actionsActivated(Map<IAction, Boolean> actions) {
    }

    public TileGenericPipe getContainer() {
        return this.container;
    }

    public boolean isWireConnectedTo(TileEntity tile, PipeWire color) {
        if (!(tile instanceof TileGenericPipe)) {
            return false;
        }
        TileGenericPipe tilePipe = (TileGenericPipe)tile;
        if (!BlockGenericPipe.isFullyDefined(tilePipe.pipe)) {
            return false;
        }
        if (!tilePipe.pipe.wireSet[color.ordinal()]) {
            return false;
        }
        return tilePipe.pipe.transport instanceof PipeTransportStructure || this.transport instanceof PipeTransportStructure || Utils.checkPipesConnections(this.container, tile);
    }

    public void dropContents() {
        ((PipeTransport)this.transport).dropContents();
    }

    public ForgeDirection getOpenOrientation() {
        int connectionsNum = 0;
        ForgeDirection targetOrientation = ForgeDirection.UNKNOWN;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!this.container.isPipeConnected(o) || ++connectionsNum != 1) continue;
            targetOrientation = o;
        }
        if (connectionsNum > 1 || connectionsNum == 0) {
            return ForgeDirection.UNKNOWN;
        }
        return targetOrientation.getOpposite();
    }

    @Override
    public boolean doDrop() {
        return true;
    }

    public void invalidate() {
    }

    public void validate() {
    }

    public void onChunkUnload() {
    }

    public World getWorld() {
        return this.container.func_145831_w();
    }

    private static class EventHandler {
        public final Method method;

        public EventHandler(Method method) {
            this.method = method;
        }
    }
}

