/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.core.utils.StringUtils;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransportPower;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SideOnly(value=Side.CLIENT)
public final class PipeToolTipManager {
    private static final Map<Class<? extends Pipe>, String> toolTips = new HashMap<Class<? extends Pipe>, String>();

    private PipeToolTipManager() {
    }

    public static void addToolTip(Class<? extends Pipe> pipe, String toolTip) {
        toolTips.put(pipe, toolTip);
    }

    public static List<String> getToolTip(Class<? extends Pipe> pipe) {
        String tip;
        String localized;
        ArrayList<String> tips = new ArrayList<String>();
        String tipTag = "tip." + pipe.getSimpleName();
        if (StringUtils.canLocalize(tipTag) && (localized = StringUtils.localize(tipTag)) != null) {
            List lines = StringUtils.newLineSplitter.splitToList((CharSequence)localized);
            tips.addAll(lines);
        }
        if ((tip = toolTips.get(pipe)) != null) {
            tips.add(tip);
        }
        return tips;
    }

    static {
        for (Map.Entry<Class<? extends Pipe>, Integer> pipe : PipeTransportPower.powerCapacities.entrySet()) {
            PipeToolTipManager.addToolTip(pipe.getKey(), String.format("%d MJ/t", pipe.getValue()));
        }
    }
}

