/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.IAction;
import buildcraft.core.inventory.InvUtils;
import buildcraft.core.inventory.SimpleInventory;
import buildcraft.core.network.IGuiReturnHandler;
import buildcraft.core.utils.EnumColor;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.TravelingItem;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.triggers.ActionExtractionPreset;
import io.netty.buffer.ByteBuf;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeItemsEmzuli
extends PipeItemsWood
implements IGuiReturnHandler {
    public final byte[] slotColors = new byte[4];
    private final SimpleInventory filters = new SimpleInventory(4, "Filters", 1);
    private final BitSet activeFlags = new BitSet(4);
    private final int filterCount = this.filters.func_70302_i_();
    private int currentFilter = 0;

    public PipeItemsEmzuli(Item item) {
        super(item);
        this.standardIconIndex = PipeIconProvider.TYPE.PipeItemsEmzuli_Standard.ordinal();
        this.solidIconIndex = PipeIconProvider.TYPE.PipeAllEmzuli_Solid.ordinal();
    }

    @Override
    public boolean blockActivated(EntityPlayer entityplayer) {
        if (entityplayer.func_71045_bC() != null && Block.func_149634_a((Item)entityplayer.func_71045_bC().func_77973_b()) instanceof BlockGenericPipe) {
            return false;
        }
        if (super.blockActivated(entityplayer)) {
            return true;
        }
        if (!this.container.func_145831_w().field_72995_K) {
            entityplayer.openGui((Object)BuildCraftTransport.instance, 53, this.container.func_145831_w(), this.container.field_145851_c, this.container.field_145848_d, this.container.field_145849_e);
        }
        return true;
    }

    @Override
    protected TravelingItem makeItem(double x, double y, double z, ItemStack stack) {
        TravelingItem item = super.makeItem(x, y, z, stack);
        byte color = this.slotColors[this.currentFilter % this.filterCount];
        if (color > 0) {
            item.color = EnumColor.fromId(color - 1);
        }
        return item;
    }

    @Override
    public ItemStack[] checkExtract(IInventory inventory, boolean doRemove, ForgeDirection from) {
        if (this.activeFlags.isEmpty()) {
            return null;
        }
        this.incrementFilter();
        if (this.filters.func_70301_a(this.currentFilter % this.filterCount) == null || !this.activeFlags.get(this.currentFilter % this.filterCount)) {
            return null;
        }
        IInventory inv = InvUtils.getInventory(inventory);
        ItemStack result = this.checkExtractGeneric(inv, doRemove, from);
        if (result != null) {
            return new ItemStack[]{result};
        }
        return null;
    }

    @Override
    public ItemStack checkExtractGeneric(ISidedInventory inventory, boolean doRemove, ForgeDirection from) {
        for (int i : inventory.func_94128_d(from.ordinal())) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a <= 0) continue;
            ItemStack filter = this.getCurrentFilter();
            if (filter == null) {
                return null;
            }
            if (!filter.func_77969_a(stack) || !inventory.func_102008_b(i, stack, from.ordinal())) continue;
            if (doRemove) {
                double energyUsed = this.mjStored > (double)stack.field_77994_a ? (double)stack.field_77994_a : this.mjStored;
                this.mjStored -= energyUsed;
                return inventory.func_70298_a(i, (int)energyUsed);
            }
            return stack;
        }
        return null;
    }

    public IInventory getFilters() {
        return this.filters;
    }

    @Override
    protected void actionsActivated(Map<IAction, Boolean> actions) {
        super.actionsActivated(actions);
        this.activeFlags.clear();
        for (Map.Entry<IAction, Boolean> action : actions.entrySet()) {
            if (!(action.getKey() instanceof ActionExtractionPreset) || action.getValue() == null || !action.getValue().booleanValue()) continue;
            this.setActivePreset(((ActionExtractionPreset)action.getKey()).color);
        }
    }

    private void setActivePreset(EnumColor color) {
        switch (color) {
            case RED: {
                this.activeFlags.set(0);
                break;
            }
            case BLUE: {
                this.activeFlags.set(1);
                break;
            }
            case GREEN: {
                this.activeFlags.set(2);
                break;
            }
            case YELLOW: {
                this.activeFlags.set(3);
                break;
            }
        }
    }

    @Override
    public LinkedList<IAction> getActions() {
        LinkedList<IAction> result = super.getActions();
        result.add(BuildCraftTransport.actionExtractionPresetRed);
        result.add(BuildCraftTransport.actionExtractionPresetBlue);
        result.add(BuildCraftTransport.actionExtractionPresetGreen);
        result.add(BuildCraftTransport.actionExtractionPresetYellow);
        return result;
    }

    @Override
    public void writeGuiData(ByteBuf paramDataOutputStream) {
    }

    @Override
    public void readGuiData(ByteBuf data, EntityPlayer paramEntityPlayer) {
        byte slot = data.readByte();
        this.slotColors[slot] = data.readByte();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.filters.readFromNBT(nbt);
        this.currentFilter = nbt.func_74762_e("currentFilter");
        for (int slot = 0; slot < this.slotColors.length; ++slot) {
            this.slotColors[slot] = nbt.func_74771_c("slotColors[" + slot + "]");
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.filters.writeToNBT(nbt);
        nbt.func_74768_a("currentFilter", this.currentFilter);
        for (int slot = 0; slot < this.slotColors.length; ++slot) {
            nbt.func_74774_a("slotColors[" + slot + "]", this.slotColors[slot]);
        }
    }

    private void incrementFilter() {
        ++this.currentFilter;
        for (int count = 0; !(this.filters.func_70301_a(this.currentFilter % this.filterCount) != null && this.activeFlags.get(this.currentFilter % this.filterCount) || count >= this.filterCount); ++count) {
            ++this.currentFilter;
        }
    }

    private ItemStack getCurrentFilter() {
        return this.filters.func_70301_a(this.currentFilter % this.filters.func_70302_i_());
    }
}

