/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftTransport;
import buildcraft.core.utils.MatrixTranformations;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.render.PipeRendererWorld;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public final class FacadeRenderHelper {
    private static final float zFightOffset = 2.4414062E-4f;
    private static final float[][] zeroStateFacade = new float[3][2];
    private static final float[][] zeroStateSupport = new float[3][2];
    private static final float[] xOffsets = new float[6];
    private static final float[] yOffsets = new float[6];
    private static final float[] zOffsets = new float[6];

    private FacadeRenderHelper() {
    }

    private static void setRenderBounds(RenderBlocks renderblocks, float[][] rotated, ForgeDirection side) {
        renderblocks.func_147782_a((double)(rotated[0][0] + xOffsets[side.ordinal()]), (double)(rotated[1][0] + yOffsets[side.ordinal()]), (double)(rotated[2][0] + zOffsets[side.ordinal()]), (double)(rotated[0][1] - xOffsets[side.ordinal()]), (double)(rotated[1][1] - yOffsets[side.ordinal()]), (double)(rotated[2][1] - zOffsets[side.ordinal()]));
    }

    public static void pipeFacadeRenderer(RenderBlocks renderblocks, BlockGenericPipe block, PipeRenderState state, int x, int y, int z) {
        state.textureArray = new IIcon[6];
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            Block renderBlock = state.facadeMatrix.getFacadeBlock(direction);
            if (renderBlock != null && renderBlock.canRenderInPass(PipeRendererWorld.renderPass)) {
                float[][] rotated;
                int renderMeta = state.facadeMatrix.getFacadeMetaId(direction);
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    state.textureArray[side.ordinal()] = renderBlock.func_149691_a(side.ordinal(), renderMeta);
                    if (side == direction || side == direction.getOpposite()) {
                        block.setRenderSide(side, true);
                        continue;
                    }
                    block.setRenderSide(side, state.facadeMatrix.getFacadeBlock(side) == null);
                }
                try {
                    BlockGenericPipe.facadeRenderColor = Item.func_150898_a((Block)state.facadeMatrix.getFacadeBlock(direction)).func_82790_a(new ItemStack(renderBlock, 1, renderMeta), 0);
                }
                catch (Throwable error) {
                    // empty catch block
                }
                if (renderBlock.func_149645_b() == 31) {
                    if ((renderMeta & 0xC) == 4) {
                        renderblocks.field_147875_q = 1;
                        renderblocks.field_147873_r = 1;
                        renderblocks.field_147867_u = 1;
                        renderblocks.field_147865_v = 1;
                    } else if ((renderMeta & 0xC) == 8) {
                        renderblocks.field_147871_s = 1;
                        renderblocks.field_147869_t = 1;
                    }
                }
                if (state.pipeConnectionMatrix.isConnected(direction)) {
                    rotated = MatrixTranformations.deepClone(zeroStateFacade);
                    rotated[0][0] = 0.24902344f;
                    rotated[0][1] = 0.75097656f;
                    rotated[2][0] = 0.0f;
                    rotated[2][1] = 0.24951172f;
                    MatrixTranformations.transform(rotated, direction);
                    FacadeRenderHelper.setRenderBounds(renderblocks, rotated, direction);
                    renderblocks.func_147784_q((Block)block, x, y, z);
                    rotated = MatrixTranformations.deepClone(zeroStateFacade);
                    rotated[0][0] = 0.24902344f;
                    rotated[0][1] = 0.75097656f;
                    rotated[2][0] = 0.7504883f;
                    MatrixTranformations.transform(rotated, direction);
                    FacadeRenderHelper.setRenderBounds(renderblocks, rotated, direction);
                    renderblocks.func_147784_q((Block)block, x, y, z);
                    rotated = MatrixTranformations.deepClone(zeroStateFacade);
                    rotated[0][0] = 0.0f;
                    rotated[0][1] = 0.24951172f;
                    MatrixTranformations.transform(rotated, direction);
                    FacadeRenderHelper.setRenderBounds(renderblocks, rotated, direction);
                    renderblocks.func_147784_q((Block)block, x, y, z);
                    rotated = MatrixTranformations.deepClone(zeroStateFacade);
                    rotated[0][0] = 0.7504883f;
                    rotated[0][1] = 1.0f;
                    MatrixTranformations.transform(rotated, direction);
                    FacadeRenderHelper.setRenderBounds(renderblocks, rotated, direction);
                    renderblocks.func_147784_q((Block)block, x, y, z);
                } else {
                    rotated = MatrixTranformations.deepClone(zeroStateFacade);
                    MatrixTranformations.transform(rotated, direction);
                    FacadeRenderHelper.setRenderBounds(renderblocks, rotated, direction);
                    renderblocks.func_147784_q((Block)block, x, y, z);
                }
                if (renderBlock.func_149645_b() == 31) {
                    renderblocks.field_147871_s = 0;
                    renderblocks.field_147875_q = 0;
                    renderblocks.field_147873_r = 0;
                    renderblocks.field_147869_t = 0;
                    renderblocks.field_147867_u = 0;
                    renderblocks.field_147865_v = 0;
                }
            }
            BlockGenericPipe.facadeRenderColor = -1;
        }
        state.textureArray = null;
        block.setRenderAllSides();
        state.currentTexture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.PipeStructureCobblestone.ordinal());
        if (PipeRendererWorld.renderPass == 0) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                if (state.facadeMatrix.getFacadeBlock(direction) == null || state.pipeConnectionMatrix.isConnected(direction)) continue;
                float[][] rotated = MatrixTranformations.deepClone(zeroStateSupport);
                MatrixTranformations.transform(rotated, direction);
                renderblocks.func_147782_a((double)rotated[0][0], (double)rotated[1][0], (double)rotated[2][0], (double)rotated[0][1], (double)rotated[1][1], (double)rotated[2][1]);
                renderblocks.func_147784_q((Block)block, x, y, z);
            }
        }
    }

    static {
        FacadeRenderHelper.zeroStateFacade[0][0] = 0.0f;
        FacadeRenderHelper.zeroStateFacade[0][1] = 1.0f;
        FacadeRenderHelper.zeroStateFacade[1][0] = 0.0f;
        FacadeRenderHelper.zeroStateFacade[1][1] = 0.125f;
        FacadeRenderHelper.zeroStateFacade[2][0] = 0.0f;
        FacadeRenderHelper.zeroStateFacade[2][1] = 1.0f;
        FacadeRenderHelper.zeroStateSupport[0][0] = 0.25f;
        FacadeRenderHelper.zeroStateSupport[0][1] = 0.75f;
        FacadeRenderHelper.zeroStateSupport[1][0] = 0.125f;
        FacadeRenderHelper.zeroStateSupport[1][1] = 0.25f;
        FacadeRenderHelper.zeroStateSupport[2][0] = 0.25f;
        FacadeRenderHelper.zeroStateSupport[2][1] = 0.75f;
        FacadeRenderHelper.xOffsets[0] = 2.4414062E-4f;
        FacadeRenderHelper.xOffsets[1] = 2.4414062E-4f;
        FacadeRenderHelper.xOffsets[2] = 0.0f;
        FacadeRenderHelper.xOffsets[3] = 0.0f;
        FacadeRenderHelper.xOffsets[4] = 0.0f;
        FacadeRenderHelper.xOffsets[5] = 0.0f;
        FacadeRenderHelper.yOffsets[0] = 0.0f;
        FacadeRenderHelper.yOffsets[1] = 0.0f;
        FacadeRenderHelper.yOffsets[2] = 2.4414062E-4f;
        FacadeRenderHelper.yOffsets[3] = 2.4414062E-4f;
        FacadeRenderHelper.yOffsets[4] = 0.0f;
        FacadeRenderHelper.yOffsets[5] = 0.0f;
        FacadeRenderHelper.zOffsets[0] = 2.4414062E-4f;
        FacadeRenderHelper.zOffsets[1] = 2.4414062E-4f;
        FacadeRenderHelper.zOffsets[2] = 0.0f;
        FacadeRenderHelper.zOffsets[3] = 0.0f;
        FacadeRenderHelper.zOffsets[4] = 0.0f;
        FacadeRenderHelper.zOffsets[5] = 0.0f;
    }
}

