/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.logging.Logger;
import mcp.mobius.betterbarrels.RecipeHandler;
import mcp.mobius.betterbarrels.ServerTickHandler;
import mcp.mobius.betterbarrels.bspace.BSpaceStorageHandler;
import mcp.mobius.betterbarrels.common.BaseProxy;
import mcp.mobius.betterbarrels.common.blocks.BlockBarrel;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.common.items.ItemBarrelHammer;
import mcp.mobius.betterbarrels.common.items.ItemTuningFork;
import mcp.mobius.betterbarrels.common.items.dolly.ItemBarrelMover;
import mcp.mobius.betterbarrels.common.items.dolly.ItemDiamondMover;
import mcp.mobius.betterbarrels.common.items.upgrades.ItemUpgradeCore;
import mcp.mobius.betterbarrels.common.items.upgrades.ItemUpgradeSide;
import mcp.mobius.betterbarrels.common.items.upgrades.ItemUpgradeStructural;
import mcp.mobius.betterbarrels.common.items.upgrades.StructuralLevel;
import mcp.mobius.betterbarrels.network.BarrelPacketHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

@Mod(modid="JABBA", name="JABBA", version="1.1.4", dependencies="after:Waila;after:NotEnoughItems")
public class BetterBarrels {
    private static boolean DEBUG_TEXTURES = Boolean.parseBoolean(System.getProperty("mcp.mobius.debugJabbaTextures", "false"));
    public static final String modid = "JABBA";
    public static Logger log = Logger.getLogger("JABBA");
    @Mod.Instance(value="JABBA")
    public static BetterBarrels instance;
    @SidedProxy(clientSide="mcp.mobius.betterbarrels.client.ClientProxy", serverSide="mcp.mobius.betterbarrels.common.BaseProxy")
    public static BaseProxy proxy;
    private static Configuration config;
    public static boolean fullBarrelTexture;
    public static boolean highRezTexture;
    public static boolean showUpgradeSymbols;
    public static boolean diamondDollyActive;
    public static int[] colorOverrides;
    public static int stacksSize;
    public static String upgradeItemStr;
    public static Block blockBarrel;
    public static Block blockMiniBarrel;
    public static Block blockBarrelShelf;
    public static Item itemUpgradeStructural;
    public static Item itemUpgradeCore;
    public static Item itemUpgradeSide;
    public static Item itemMover;
    public static Item itemMoverDiamond;
    public static Item itemTuningFork;
    public static Item itemLockingPlanks;
    public static Item itemHammer;
    public static long limiterDelay;
    public static int blockBarrelRendererID;

    public static void debug(String msg) {
        if (DEBUG_TEXTURES) {
            log.log(java.util.logging.Level.WARNING, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        try {
            config.load();
            diamondDollyActive = config.get("general", "diamondDollyActive", true).getBoolean(true);
            limiterDelay = config.get("general", "packetLimiterDelay", 500, "Controls the minimum delay (in ms) between two server/client sync. Lower values mean closer to realtime, and more network usage.").getInt();
            StructuralLevel.upgradeMaterialsList = config.get("general", "materialList", StructuralLevel.upgradeMaterialsList, "A structural tier will be created for each material in this list, even if not craftable").getStringList();
            if (StructuralLevel.upgradeMaterialsList.length > 18) {
                String[] trimedList = new String[18];
                for (int i = 0; i < 18; ++i) {
                    trimedList[i] = StructuralLevel.upgradeMaterialsList[i];
                }
                StructuralLevel.upgradeMaterialsList = trimedList;
                config.get("general", "materialList", trimedList).set(trimedList);
            }
            BetterBarrels.debug("00 - Loaded materials list: " + Arrays.toString(StructuralLevel.upgradeMaterialsList));
            StructuralLevel.maxCraftableTier = Math.min(18, Math.min(StructuralLevel.upgradeMaterialsList.length, config.get("general", "maxCraftableTier", StructuralLevel.upgradeMaterialsList.length, "Maximum tier to generate crafting recipes for").getInt()));
            StructuralLevel.maxCraftableTier = Math.min(18, Math.min(StructuralLevel.upgradeMaterialsList.length, config.get("general", "maxCraftableTier", StructuralLevel.upgradeMaterialsList.length).getInt()));
            BetterBarrels.debug("01 - Max craftable tier: " + StructuralLevel.maxCraftableTier);
            colorOverrides = config.get("general", "colorOverrides", colorOverrides, "This list contains paired numbers: first is the tier level this color applies to, second is the color. The color value is the RGB color as a single int").getIntList();
            if (colorOverrides != null) {
                if (colorOverrides.length % 2 == 0) {
                    int i;
                    StructuralLevel.structuralColorOverrides = new int[StructuralLevel.upgradeMaterialsList.length];
                    for (i = 0; i < StructuralLevel.structuralColorOverrides.length; ++i) {
                        StructuralLevel.structuralColorOverrides[i] = -1;
                    }
                    for (i = 0; i < colorOverrides.length; i += 2) {
                        if (colorOverrides[i] == 0) continue;
                        if (colorOverrides[i] > 0 && colorOverrides[i] < StructuralLevel.structuralColorOverrides.length) {
                            StructuralLevel.structuralColorOverrides[BetterBarrels.colorOverrides[i] - 1] = 0xFF000000 | colorOverrides[i + 1];
                            continue;
                        }
                        log.warning("Attempting to override the structural tier color for non existant tier: " + colorOverrides[i]);
                    }
                } else {
                    log.warning("Color override list is not formatted in pairs, ignoring");
                }
            }
            stacksSize = config.get("general", "stacksSize", stacksSize, "How many stacks the base barrel and each upgrade will provide").getInt();
            upgradeItemStr = config.get("general", "tierUpgradeItem", upgradeItemStr, "The name of the item to use for the strutural tier upgrade recipes. Default is \"minecraft:fence\" for Vanilla Fence. The format is Ore.name for an ore dictionary lookup, or itemDomain:itemname[:meta] for a direct item, not this is case-sensitive.").getString();
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"BlockBarrel has a problem loading it's configuration", (Object[])new Object[0]);
            FMLLog.severe((String)e.getMessage(), (Object[])new Object[0]);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
        RecipeHandler.instance().registerOres();
        proxy.registerEventHandler();
        blockBarrel = new BlockBarrel();
        itemUpgradeStructural = new ItemUpgradeStructural();
        itemUpgradeCore = new ItemUpgradeCore();
        itemUpgradeSide = new ItemUpgradeSide();
        itemMover = new ItemBarrelMover();
        itemMoverDiamond = new ItemDiamondMover();
        itemHammer = new ItemBarrelHammer();
        itemTuningFork = new ItemTuningFork();
        GameRegistry.registerBlock((Block)blockBarrel, (String)"barrel");
        GameRegistry.registerItem((Item)itemUpgradeStructural, (String)"upgradeStructural");
        GameRegistry.registerItem((Item)itemUpgradeCore, (String)"upgradeCore");
        GameRegistry.registerItem((Item)itemUpgradeSide, (String)"upgradeSide");
        GameRegistry.registerItem((Item)itemMover, (String)"mover");
        GameRegistry.registerItem((Item)itemMoverDiamond, (String)"moverDiamond");
        GameRegistry.registerItem((Item)itemHammer, (String)"hammer");
        GameRegistry.registerItem((Item)itemTuningFork, (String)"tuningFork");
        BarrelPacketHandler.INSTANCE.ordinal();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        StructuralLevel.createLevelArray();
        RecipeHandler.instance().registerRecipes();
        GameRegistry.registerTileEntity(TileEntityBarrel.class, (String)"TileEntityBarrel");
        FMLCommonHandler.instance().bus().register((Object)ServerTickHandler.INSTANCE);
        proxy.registerRenderers();
        FMLInterModComms.sendMessage((String)"Waila", (String)"register", (String)"mcp.mobius.betterbarrels.BBWailaProvider.callbackRegister");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        RecipeHandler.instance().registerLateRecipes();
        StructuralLevel.initializeStructuralMaterials();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        BSpaceStorageHandler.instance().writeToFile();
    }

    static {
        config = null;
        fullBarrelTexture = true;
        highRezTexture = true;
        showUpgradeSymbols = true;
        diamondDollyActive = true;
        colorOverrides = new int[]{0, 0};
        stacksSize = 64;
        upgradeItemStr = "minecraft:fence";
        blockBarrel = null;
        blockMiniBarrel = null;
        blockBarrelShelf = null;
        itemUpgradeStructural = null;
        itemUpgradeCore = null;
        itemUpgradeSide = null;
        itemMover = null;
        itemMoverDiamond = null;
        itemTuningFork = null;
        itemLockingPlanks = null;
        itemHammer = null;
        limiterDelay = 500L;
        blockBarrelRendererID = -1;
    }
}

