/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Map;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.bspace.BBEventHandler;
import mcp.mobius.betterbarrels.client.render.BlockBarrelRenderer;
import mcp.mobius.betterbarrels.client.render.TileEntityBarrelRenderer;
import mcp.mobius.betterbarrels.common.BaseProxy;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.common.items.upgrades.StructuralLevel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringTranslate;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends BaseProxy {
    public static Map<Integer, ISimpleBlockRenderingHandler> blockRenderers;

    @Override
    public void registerRenderers() {
        try {
            Field blockRendererField = RenderingRegistry.class.getDeclaredField("blockRenderers");
            blockRendererField.setAccessible(true);
            blockRenderers = (Map)blockRendererField.get(RenderingRegistry.instance());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BetterBarrels.blockBarrelRendererID = RenderingRegistry.getNextAvailableRenderId();
        while (blockRenderers.containsKey(BetterBarrels.blockBarrelRendererID)) {
            BetterBarrels.blockBarrelRendererID = RenderingRegistry.getNextAvailableRenderId();
        }
        RenderingRegistry.registerBlockHandler((int)BetterBarrels.blockBarrelRendererID, (ISimpleBlockRenderingHandler)new BlockBarrelRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityBarrel.class, (TileEntitySpecialRenderer)new TileEntityBarrelRenderer());
    }

    @Override
    public void checkRenderers() {
        ISimpleBlockRenderingHandler renderer = blockRenderers.get(BetterBarrels.blockBarrelRendererID);
        if (!(renderer instanceof BlockBarrelRenderer)) {
            throw new RuntimeException(String.format("Wrong renderer found ! %s found while looking up the Jabba Barrel renderer.", renderer.getClass().getCanonicalName()));
        }
    }

    @Override
    public void registerEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)new BBEventHandler());
    }

    @Override
    public void postInit() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){
            private boolean ranOnce = false;

            public void func_110549_a(IResourceManager resourcemanager) {
                if (!this.ranOnce) {
                    this.ranOnce = true;
                    return;
                }
                StructuralLevel.loadBaseTextureData();
                if (StructuralLevel.LEVELS != null) {
                    for (int level = 1; level < StructuralLevel.LEVELS.length; ++level) {
                        StructuralLevel.LEVELS[level].discoverMaterialName();
                        StringTranslate.inject((InputStream)new ByteArrayInputStream(("item.upgrade.structural." + String.valueOf(level) + ".name=" + StatCollector.func_74838_a((String)"item.upgrade.structural") + " " + StructuralLevel.romanNumeral(level) + " (" + StructuralLevel.LEVELS[level].name + ")").getBytes()));
                        StructuralLevel.LEVELS[level].generateIcons();
                    }
                }
                StructuralLevel.unloadBaseTextureData();
            }
        });
    }
}

