/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.client.render;

import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.client.render.TileEntityBaseRenderer;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.common.blocks.logic.Coordinates;
import mcp.mobius.betterbarrels.common.items.IOverlayItem;
import mcp.mobius.betterbarrels.common.items.upgrades.StructuralLevel;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeCore;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeSide;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class TileEntityBarrelRenderer
extends TileEntityBaseRenderer {
    public static TileEntityBarrelRenderer _instance = null;
    protected static ItemStack coreStorage = new ItemStack(BetterBarrels.itemUpgradeCore, 0, 0);
    protected static ItemStack coreEnder = new ItemStack(BetterBarrels.itemUpgradeCore, 0, 1);
    protected static ItemStack coreRedstone = new ItemStack(BetterBarrels.itemUpgradeCore, 0, 2);
    protected static ItemStack coreHopper = new ItemStack(BetterBarrels.itemUpgradeCore, 0, 3);
    protected static ItemStack coreVoid = new ItemStack(BetterBarrels.itemUpgradeCore, 0, UpgradeCore.VOID.ordinal());
    protected static ItemStack coreCreative = new ItemStack(BetterBarrels.itemUpgradeCore, 0, UpgradeCore.CREATIVE.ordinal());

    public static TileEntityBarrelRenderer instance() {
        if (_instance == null) {
            _instance = new TileEntityBarrelRenderer();
        }
        return _instance;
    }

    public void func_147500_a(TileEntity tileEntity, double xpos, double ypos, double zpos, float var8) {
        if (tileEntity instanceof TileEntityBarrel) {
            this.saveState();
            ForgeDirection orientation = ((TileEntityBarrel)tileEntity).orientation;
            TileEntityBarrel barrelEntity = (TileEntityBarrel)tileEntity;
            Coordinates barrelPos = new Coordinates(0, xpos, ypos, zpos);
            GL11.glDisable((int)3042);
            GL11.glDisable((int)2896);
            boolean isHammer = this.mc.field_71439_g.func_70694_bm() != null ? this.mc.field_71439_g.func_70694_bm().func_77973_b() instanceof IOverlayItem : false;
            boolean hasItem = barrelEntity.getStorage().hasItem();
            int color = StructuralLevel.LEVELS[barrelEntity.coreUpgrades.levelStructural].getTextColor();
            for (ForgeDirection forgeSide : ForgeDirection.VALID_DIRECTIONS) {
                if (!hasItem || !this.isItemDisplaySide(barrelEntity, forgeSide)) continue;
                this.setLight(barrelEntity, forgeSide);
                if (forgeSide == ForgeDirection.DOWN || forgeSide == ForgeDirection.UP) {
                    this.renderStackOnBlock(barrelEntity.getStorage().getItemForRender(), forgeSide, orientation, barrelPos, 8.0f, 65.0, 64.0);
                } else {
                    this.renderStackOnBlock(barrelEntity.getStorage().getItemForRender(), forgeSide, orientation, barrelPos, 8.0f, 65.0, 75.0);
                }
                String barrelString = this.getBarrelString(barrelEntity);
                this.renderTextOnBlock(barrelString, forgeSide, orientation, barrelPos, 2.0f, 128.0, 10.0, color, TileEntityBaseRenderer.ALIGNCENTER);
            }
            if (isHammer) {
                for (ForgeDirection forgeSide : ForgeDirection.VALID_DIRECTIONS) {
                    this.setLight(barrelEntity, forgeSide);
                    if (barrelEntity.sideUpgrades[forgeSide.ordinal()] == UpgradeSide.REDSTONE) {
                        int index = barrelEntity.sideMetadata[forgeSide.ordinal()] + 32;
                        this.renderIconOnBlock(index, forgeSide, orientation, barrelPos, 2.0f, 224.0, 0.0, -0.01f);
                        continue;
                    }
                    if (!this.isItemDisplaySide(barrelEntity, forgeSide)) continue;
                    int offsetY = 224;
                    if (barrelEntity.coreUpgrades.levelStructural > 0) {
                        this.renderIconOnBlock(0, forgeSide, orientation, barrelPos, 2.0f, 0.0, 0.0, -0.01f);
                        this.renderTextOnBlock("x" + String.valueOf(barrelEntity.coreUpgrades.levelStructural), forgeSide, orientation, barrelPos, 2.0f, 37.0, 15.0, color, TileEntityBaseRenderer.ALIGNLEFT);
                        if (barrelEntity.coreUpgrades.getFreeSlots() > 0) {
                            String freeSlots = String.valueOf(barrelEntity.coreUpgrades.getFreeSlots());
                            if (freeSlots.length() < 4) {
                                this.renderTextOnBlock(freeSlots, forgeSide, orientation, barrelPos, 2.0f, 254.0, 127.0, color, TileEntityBaseRenderer.ALIGNRIGHT);
                            } else {
                                this.renderTextOnBlock(freeSlots, forgeSide, orientation, barrelPos, 2.0f, 248.0, 134.0, 90.0f, color, TileEntityBaseRenderer.ALIGNCENTER);
                            }
                        }
                    }
                    if (barrelEntity.coreUpgrades.nStorageUpg > 0) {
                        this.renderStackOnBlock(coreStorage, forgeSide, orientation, barrelPos, 2.0f, 224.0, 0.0);
                        this.renderTextOnBlock(String.valueOf(barrelEntity.coreUpgrades.nStorageUpg) + "x", forgeSide, orientation, barrelPos, 2.0f, 224.0, 15.0, color, TileEntityBaseRenderer.ALIGNRIGHT);
                    }
                    if (barrelEntity.coreUpgrades.hasRedstone) {
                        this.renderStackOnBlock(coreRedstone, forgeSide, orientation, barrelPos, 2.0f, 0.0, offsetY);
                        offsetY -= 35;
                    }
                    if (barrelEntity.coreUpgrades.hasHopper) {
                        this.renderStackOnBlock(coreHopper, forgeSide, orientation, barrelPos, 2.0f, 0.0, offsetY);
                        offsetY -= 35;
                    }
                    if (barrelEntity.coreUpgrades.hasEnder) {
                        this.renderStackOnBlock(coreEnder, forgeSide, orientation, barrelPos, 2.0f, 0.0, offsetY);
                        offsetY -= 35;
                    }
                    if (barrelEntity.coreUpgrades.hasVoid) {
                        this.renderStackOnBlock(coreVoid, forgeSide, orientation, barrelPos, 2.0f, 0.0, offsetY);
                        offsetY -= 35;
                    }
                    if (!barrelEntity.coreUpgrades.hasCreative) continue;
                    this.renderStackOnBlock(coreCreative, forgeSide, orientation, barrelPos, 2.0f, 0.0, offsetY);
                    offsetY -= 35;
                }
            }
            this.loadState();
        }
    }

    protected String getBarrelString(TileEntityBarrel barrel) {
        String outstring = null;
        if (!barrel.getStorage().hasItem()) {
            return "";
        }
        int maxstacksize = barrel.getStorage().getItem().func_77976_d();
        int amount = barrel.getStorage().getAmount();
        if (barrel.coreUpgrades.hasCreative) {
            outstring = "-";
        } else if (maxstacksize != 1) {
            int nstacks = amount / maxstacksize;
            int remains = amount % maxstacksize;
            if (nstacks > 0 && remains > 0) {
                outstring = String.format("%s*%s + %s", nstacks, maxstacksize, remains);
            } else if (nstacks == 0 && remains > 0) {
                outstring = String.format("%s", remains);
            } else if (nstacks > 0 && remains == 0) {
                outstring = String.format("%s*%s", nstacks, maxstacksize);
            } else if (amount == 0) {
                outstring = "0";
            }
        } else {
            outstring = maxstacksize == 1 ? String.format("%s", amount) : "";
        }
        return outstring;
    }

    protected void renderBarrelSide(int index, ForgeDirection side, ForgeDirection orientation, Coordinates barrelPos) {
        float size = 16.0f;
        GL11.glPushMatrix();
        this.alignRendering(side, orientation, barrelPos);
        this.moveRendering(16.0f, 0.0, 0.0, 0.0);
        this.texManager.func_110577_a(blocksSheetRes);
        this.drawTexturedModalRect(0, 0, 16 * (index % 16), 16 * (index / 16), 16, 16);
        GL11.glPopMatrix();
    }

    protected boolean isItemDisplaySide(TileEntityBarrel barrel, ForgeDirection forgeSide) {
        if (barrel.sideUpgrades[forgeSide.ordinal()] == UpgradeSide.NONE) {
            return false;
        }
        if (barrel.sideUpgrades[forgeSide.ordinal()] == UpgradeSide.FRONT) {
            return true;
        }
        return barrel.sideUpgrades[forgeSide.ordinal()] == UpgradeSide.STICKER;
    }
}

