/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.blocks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.common.blocks.IBarrelStorage;
import mcp.mobius.betterbarrels.common.blocks.logic.Coordinates;
import mcp.mobius.betterbarrels.common.blocks.logic.ItemImmut;
import mcp.mobius.betterbarrels.common.blocks.logic.OreDictPair;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class StorageLocal
implements IBarrelStorage {
    private ItemStack inputStack = null;
    private ItemStack prevInputStack = null;
    private ItemStack outputStack = null;
    private ItemStack prevOutputStack = null;
    private ItemStack itemTemplate = null;
    private ItemStack renderingTemplate = null;
    private int totalAmount = 0;
    private int stackAmount = 0;
    private int basestacks = BetterBarrels.stacksSize;
    private int maxstacks = BetterBarrels.stacksSize;
    private int upgCapacity = 0;
    private boolean keepLastItem = false;
    private boolean deleteExcess = false;
    private boolean alwaysProvide = false;
    private Set<Coordinates> linkedStorages = new HashSet<Coordinates>();
    private static HashMap<OreDictPair, Boolean> oreDictCache = new HashMap();

    public StorageLocal() {
        this.func_70296_d();
    }

    public StorageLocal(NBTTagCompound tag) {
        this.readTagCompound(tag);
        this.func_70296_d();
    }

    public StorageLocal(int nupgrades) {
        for (int i = 0; i < nupgrades; ++i) {
            this.addStorageUpgrade();
        }
        this.func_70296_d();
    }

    private ItemStack getStackFromSlot(int slot) {
        return slot == 0 ? this.inputStack : this.outputStack;
    }

    private int getFreeSpace() {
        if (this.hasItem()) {
            return this.itemTemplate.func_77976_d() * this.getMaxStacks() - (this.deleteExcess ? 0 : this.totalAmount);
        }
        return 64;
    }

    @Override
    public boolean hasItem() {
        return this.itemTemplate != null;
    }

    @Override
    public ItemStack getItem() {
        return this.itemTemplate;
    }

    @Override
    public ItemStack getItemForRender() {
        if (this.renderingTemplate == null) {
            this.renderingTemplate = this.itemTemplate.func_77946_l();
            if (this.renderingTemplate.func_77942_o() && this.renderingTemplate.func_77978_p().func_74764_b("ench")) {
                this.renderingTemplate.func_77978_p().func_82580_o("ench");
            }
            if (this.renderingTemplate.func_77942_o() && this.renderingTemplate.func_77978_p().func_74764_b("CustomPotionEffects")) {
                this.renderingTemplate.func_77978_p().func_82580_o("CustomPotionEffects");
            }
            if (this.renderingTemplate.func_77973_b() == Items.field_151068_bn) {
                this.renderingTemplate.func_77964_b(0);
            }
            if (this.renderingTemplate.func_77973_b() == Items.field_151062_by) {
                this.renderingTemplate = new ItemStack((Item)Items.field_151068_bn, 0, 0);
            }
        }
        return this.renderingTemplate;
    }

    @Override
    public void setItem(ItemStack stack) {
        if (stack != null) {
            this.itemTemplate = stack.func_77946_l();
            this.itemTemplate.field_77994_a = 0;
        } else {
            this.itemTemplate = null;
            this.renderingTemplate = null;
        }
    }

    @Override
    public boolean sameItem(ItemStack stack) {
        if (!this.hasItem() && this.isGhosting()) {
            return false;
        }
        if (!this.hasItem()) {
            return true;
        }
        if (stack == null) {
            return false;
        }
        if (this.getItem().func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)this.getItem(), (ItemStack)stack)) {
            return true;
        }
        OreDictPair orePair = new OreDictPair(new ItemImmut(Item.func_150891_b((Item)this.getItem().func_77973_b()), this.getItem().func_77960_j()), new ItemImmut(Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j()));
        if (!oreDictCache.containsKey(orePair)) {
            int oreIDStack;
            int[] oreIDBarrels = OreDictionary.getOreIDs((ItemStack)this.getItem());
            int oreIDBarrel = oreIDBarrels.length > 0 ? oreIDBarrels[0] : -1;
            int[] oreIDStacks = OreDictionary.getOreIDs((ItemStack)stack);
            int n = oreIDStack = oreIDStacks.length > 0 ? oreIDStacks[0] : -1;
            if (oreIDStack != -1 && oreIDBarrel != -1) {
                boolean stackIsMetal = OreDictionary.getOreName((int)oreIDBarrel).startsWith("ingot") || OreDictionary.getOreName((int)oreIDBarrel).startsWith("ore") || OreDictionary.getOreName((int)oreIDBarrel).startsWith("dust") || OreDictionary.getOreName((int)oreIDBarrel).startsWith("nugget");
                oreDictCache.put(orePair, oreIDBarrel == oreIDStack && stackIsMetal);
            } else {
                oreDictCache.put(orePair, false);
            }
        }
        return oreDictCache.get(orePair);
    }

    @Override
    public NBTTagCompound writeTagCompound() {
        NBTTagCompound retTag = new NBTTagCompound();
        retTag.func_74768_a("amount", this.totalAmount);
        retTag.func_74768_a("maxstacks", this.maxstacks);
        retTag.func_74768_a("upgCapacity", this.upgCapacity);
        if (this.getItem() != null) {
            NBTTagCompound var3 = new NBTTagCompound();
            this.getItem().func_77955_b(var3);
            retTag.func_74782_a("current_item", (NBTBase)var3);
        }
        if (this.keepLastItem) {
            retTag.func_74757_a("keepLastItem", this.keepLastItem);
        }
        if (this.deleteExcess) {
            retTag.func_74757_a("deleteExcess", this.deleteExcess);
        }
        if (this.alwaysProvide) {
            retTag.func_74757_a("alwaysProvide", this.alwaysProvide);
        }
        return retTag;
    }

    @Override
    public void readTagCompound(NBTTagCompound tag) {
        this.totalAmount = tag.func_74762_e("amount");
        this.maxstacks = tag.func_74762_e("maxstacks");
        this.upgCapacity = tag.func_74762_e("upgCapacity");
        this.itemTemplate = tag.func_74764_b("current_item") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("current_item")) : null;
        this.keepLastItem = tag.func_74764_b("keepLastItem") ? tag.func_74767_n("keepLastItem") : false;
        this.deleteExcess = tag.func_74764_b("deleteExcess") ? tag.func_74767_n("deleteExcess") : false;
        this.alwaysProvide = tag.func_74764_b("alwaysProvide") ? tag.func_74767_n("alwaysProvide") : false;
        this.setItem(this.itemTemplate);
    }

    @Override
    public int addStack(ItemStack stack) {
        int deposit;
        boolean skip;
        boolean bl = skip = stack == null || !this.sameItem(stack);
        if (!this.hasItem() && this.isGhosting() && stack != null) {
            skip = false;
        }
        if (skip) {
            return 0;
        }
        if (!this.hasItem()) {
            this.setItem(stack);
            this.totalAmount = stack.field_77994_a;
            deposit = stack.field_77994_a;
            stack.field_77994_a -= deposit;
        } else {
            int totalCapacity = this.getItem().func_77976_d() * this.maxstacks;
            int freeSpace = totalCapacity - this.totalAmount;
            deposit = Math.min(stack.field_77994_a, freeSpace);
            stack.field_77994_a -= deposit;
            this.totalAmount += deposit;
        }
        if (this.deleteExcess) {
            if (deposit == 0) {
                deposit = stack.field_77994_a;
            }
            if (stack.field_77994_a > 0) {
                stack.field_77994_a = 0;
            }
        }
        this.func_70296_d();
        return deposit;
    }

    @Override
    public ItemStack getStack() {
        if (this.hasItem()) {
            return this.getStack(this.getItem().func_77976_d());
        }
        return null;
    }

    @Override
    public ItemStack getStack(int amount) {
        this.func_70296_d();
        ItemStack retStack = null;
        if (this.hasItem()) {
            amount = Math.min(amount, this.getItem().func_77976_d());
            if (!this.alwaysProvide) {
                amount = Math.min(amount, this.totalAmount);
            }
            retStack = this.getItem().func_77946_l();
            if (!this.alwaysProvide) {
                this.totalAmount -= amount;
            }
            retStack.field_77994_a = amount;
        }
        this.func_70296_d();
        return retStack;
    }

    @Override
    public boolean switchGhosting() {
        this.keepLastItem = !this.keepLastItem;
        this.func_70296_d();
        return this.keepLastItem;
    }

    @Override
    public boolean isGhosting() {
        return this.keepLastItem;
    }

    @Override
    public void setGhosting(boolean locked) {
        this.keepLastItem = locked;
    }

    @Override
    public boolean isVoid() {
        return this.deleteExcess;
    }

    @Override
    public void setVoid(boolean delete) {
        this.deleteExcess = delete;
    }

    @Override
    public boolean isCreative() {
        return this.alwaysProvide;
    }

    @Override
    public void setCreative(boolean infinite) {
        this.alwaysProvide = infinite;
    }

    @Override
    public int getAmount() {
        return this.totalAmount;
    }

    @Override
    public void setAmount(int amount) {
        this.totalAmount = amount;
    }

    @Override
    public void setBaseStacks(int basestacks) {
        this.basestacks = basestacks;
        this.maxstacks = basestacks;
    }

    @Override
    public int getMaxStacks() {
        return this.maxstacks;
    }

    @Override
    public void addStorageUpgrade() {
        ++this.upgCapacity;
        this.maxstacks = this.basestacks * (this.upgCapacity + 1);
    }

    @Override
    public void rmStorageUpgrade() {
        --this.upgCapacity;
        this.maxstacks = this.basestacks * (this.upgCapacity + 1);
    }

    public int[] func_94128_d(int var1) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slot, ItemStack itemstack, int side) {
        if (slot == 1) {
            return false;
        }
        if (this.getFreeSpace() <= 0) {
            return false;
        }
        return this.sameItem(itemstack);
    }

    public boolean func_102008_b(int slot, ItemStack itemstack, int side) {
        if (slot == 0) {
            return false;
        }
        if (!this.hasItem()) {
            return false;
        }
        if (itemstack == null) {
            return true;
        }
        return this.sameItem(itemstack);
    }

    public int func_70302_i_() {
        return 2;
    }

    public ItemStack func_70301_a(int slot) {
        this.func_70296_d();
        return this.getStackFromSlot(slot);
    }

    public ItemStack func_70298_a(int slot, int quantity) {
        int stackSize;
        if (slot == 0) {
            throw new RuntimeException("[JABBA] Tried to decr the stack size of the input slot");
        }
        ItemStack stack = this.getStackFromSlot(slot).func_77946_l();
        stack.field_77994_a = stackSize = Math.min(quantity, stack.field_77994_a);
        this.getStackFromSlot((int)slot).field_77994_a -= stackSize;
        this.func_70296_d();
        return stack;
    }

    @Override
    public ItemStack decrStackSize_Hopper(int slot, int quantity) {
        int stackSize;
        if (slot == 0) {
            throw new RuntimeException("[JABBA] Tried to decr the stack size of the input slot");
        }
        ItemStack stack = this.getStackFromSlot(slot).func_77946_l();
        stack.field_77994_a = stackSize = Math.min(quantity, stack.field_77994_a);
        this.getStackFromSlot((int)slot).field_77994_a -= stackSize;
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        return this.getStackFromSlot(slot);
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        if (slot == 0) {
            this.inputStack = itemstack;
        } else {
            this.outputStack = itemstack;
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "jabba.localstorage";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
        if (this.inputStack != null) {
            if (!this.hasItem()) {
                this.setItem(this.inputStack);
            }
            if (!this.deleteExcess || this.itemTemplate.func_77976_d() * this.getMaxStacks() - this.totalAmount > 0) {
                this.totalAmount = this.prevInputStack != null ? (this.totalAmount += this.inputStack.field_77994_a - this.prevInputStack.field_77994_a) : (this.totalAmount += this.inputStack.field_77994_a);
            }
            this.inputStack = null;
        }
        if (this.hasItem() && this.getFreeSpace() < this.itemTemplate.func_77976_d()) {
            this.inputStack = this.itemTemplate.func_77946_l();
            this.inputStack.field_77994_a = this.itemTemplate.func_77976_d() - this.getFreeSpace();
        }
        if (this.hasItem() && this.outputStack == null && this.prevOutputStack != null && !this.alwaysProvide) {
            this.totalAmount -= this.prevOutputStack.field_77994_a;
        }
        if (this.prevOutputStack != null && this.outputStack != null) {
            int delta = this.prevOutputStack.field_77994_a - this.outputStack.field_77994_a;
            if (!this.alwaysProvide) {
                this.totalAmount -= delta;
            }
            int n = this.outputStack.field_77994_a = this.alwaysProvide ? this.outputStack.func_77976_d() : Math.min(this.outputStack.func_77976_d(), this.totalAmount);
        }
        if (this.hasItem() && this.outputStack == null) {
            this.outputStack = this.itemTemplate.func_77946_l();
            int n = this.outputStack.field_77994_a = this.alwaysProvide ? this.outputStack.func_77976_d() : Math.min(this.outputStack.func_77976_d(), this.totalAmount);
        }
        if (this.totalAmount == 0 && !this.isGhosting()) {
            this.itemTemplate = null;
            this.outputStack = null;
            this.inputStack = null;
            this.renderingTemplate = null;
        }
        this.prevOutputStack = this.outputStack != null ? this.outputStack.func_77946_l() : null;
        this.prevInputStack = this.inputStack != null ? this.inputStack.func_77946_l() : null;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return this.sameItem(itemstack);
    }

    @Override
    public ItemStack getStoredItemType() {
        if (this.hasItem()) {
            ItemStack stack = this.getItem().func_77946_l();
            stack.field_77994_a = this.alwaysProvide ? this.getItem().func_77976_d() * this.maxstacks : this.totalAmount;
            return stack;
        }
        if (!this.hasItem() && this.isGhosting()) {
            return new ItemStack(Blocks.field_150384_bq, 0);
        }
        return null;
    }

    @Override
    public void setStoredItemCount(int amount) {
        int totalcapacity;
        if (this.hasItem() && amount > (totalcapacity = this.getItem().func_77976_d() * this.maxstacks)) {
            amount = totalcapacity;
        }
        this.totalAmount = amount;
        this.func_70296_d();
    }

    @Override
    public void setStoredItemType(ItemStack type, int amount) {
        int totalcapacity;
        this.setItem(type);
        if (this.hasItem() && amount > (totalcapacity = this.getItem().func_77976_d() * this.maxstacks)) {
            amount = totalcapacity;
        }
        this.totalAmount = amount;
        this.func_70296_d();
    }

    @Override
    public int getMaxStoredCount() {
        if (this.hasItem()) {
            return this.deleteExcess ? (this.maxstacks + 1) * this.getItem().func_77976_d() : this.maxstacks * this.getItem().func_77976_d();
        }
        return this.maxstacks * 64;
    }
}

