/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.items.dolly;

import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import mcp.mobius.betterbarrels.common.JabbaCreativeTab;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemBarrelMover
extends Item {
    protected IIcon text_empty = null;
    protected IIcon text_filled = null;
    protected static ArrayList<Class> classExtensions = new ArrayList();
    protected static ArrayList<String> classExtensionsNames = new ArrayList();
    protected static HashMap<String, Class> classMap = new HashMap();

    public ItemBarrelMover() {
        this.func_77625_d(1);
        this.func_77655_b("dolly.normal.empty");
        this.func_77637_a(JabbaCreativeTab.tab);
        this.setNoRepair();
    }

    public void func_94581_a(IIconRegister par1IconRegister) {
        this.text_empty = this.field_77791_bV = par1IconRegister.func_94245_a("JABBA:dolly_empty");
        this.text_filled = par1IconRegister.func_94245_a("JABBA:dolly_filled");
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Container")) {
            return "item.dolly.normal.full";
        }
        return "item.dolly.normal.empty";
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.func_77650_f(stack);
    }

    public IIcon func_77650_f(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Container")) {
            return this.text_filled;
        }
        return this.text_empty;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!(world.field_72995_K || stack.func_77942_o() && stack.func_77978_p().func_74764_b("Container"))) {
            return this.pickupContainer(stack, player, world, x, y, z);
        }
        if (!world.field_72995_K && stack.func_77942_o() && stack.func_77978_p().func_74764_b("Container")) {
            return this.placeContainer(stack, player, world, x, y, z, side);
        }
        return false;
    }

    protected boolean placeContainer(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        int i;
        NBTTagCompound nbtStack = stack.func_77978_p();
        NBTTagCompound nbtContainerStack = nbtStack.func_74775_l("Container");
        Block storedBlock = nbtContainerStack.func_74764_b("ID") ? Block.func_149729_e((int)nbtContainerStack.func_74762_e("ID")) : Block.func_149684_b((String)nbtContainerStack.func_74779_i("Block"));
        int blockMeta = nbtContainerStack.func_74762_e("Meta");
        String TEClassName = nbtContainerStack.func_74779_i("TEClass");
        NBTTagCompound nbtContainer = nbtStack.func_74775_l("Container").func_74775_l("NBT");
        ForgeDirection targSide = ForgeDirection.getOrientation((int)side);
        int targX = x;
        int targY = y;
        int targZ = z;
        Block targetBlock = world.func_147439_a(targX, targY, targZ);
        if (targetBlock == Blocks.field_150433_aE) {
            targSide = ForgeDirection.UP;
        }
        if (!(targetBlock == Blocks.field_150395_bd || targetBlock == Blocks.field_150329_H || targetBlock == Blocks.field_150330_I || targetBlock != null && targetBlock.isReplaceable((IBlockAccess)world, targX, targY, targZ))) {
            if (targSide.equals((Object)ForgeDirection.NORTH)) {
                --targZ;
            }
            if (targSide.equals((Object)ForgeDirection.SOUTH)) {
                ++targZ;
            }
            if (targSide.equals((Object)ForgeDirection.WEST)) {
                --targX;
            }
            if (targSide.equals((Object)ForgeDirection.EAST)) {
                ++targX;
            }
            if (targSide.equals((Object)ForgeDirection.UP)) {
                ++targY;
            }
            if (targSide.equals((Object)ForgeDirection.DOWN)) {
                --targY;
            }
        }
        if (!world.func_147472_a(storedBlock, targX, targY, targZ, false, side, (Entity)null, stack)) {
            return false;
        }
        nbtContainer.func_74768_a("x", targX);
        nbtContainer.func_74768_a("y", targY);
        nbtContainer.func_74768_a("z", targZ);
        if (TEClassName.contains("net.minecraft.tileentity.TileEntityChest")) {
            blockMeta = this.getBarrelOrientationOnPlacement(player).ordinal();
        }
        if (TEClassName.contains("buildcraft.energy.TileEngine") && nbtContainer.func_74764_b("orientation")) {
            nbtContainer.func_74768_a("orientation", 1);
        }
        if (TEClassName.contains("mods.railcraft.common.blocks.machine.beta") && nbtContainer.func_74764_b("direction")) {
            nbtContainer.func_74774_a("direction", (byte)1);
        }
        if (TEClassName.contains("forestry.energy.gadgets") && nbtContainer.func_74764_b("Orientation")) {
            nbtContainer.func_74768_a("Orientation", 1);
        }
        if (TEClassName.contains("bluedart.tile.TileEntityForceEngine") && nbtContainer.func_74764_b("facing")) {
            nbtContainer.func_74774_a("facing", (byte)1);
        }
        if (TEClassName.contains("thermalexpansion.block.engine") && nbtContainer.func_74764_b("side.facing")) {
            nbtContainer.func_74774_a("side.facing", (byte)1);
        }
        if (TEClassName.contains("cpw.mods.ironchest") && nbtContainer.func_74764_b("facing")) {
            nbtContainer.func_74774_a("facing", (byte)this.getBarrelOrientationOnPlacement(player).ordinal());
        }
        if (TEClassName.contains("ic2.core.block") && nbtContainer.func_74764_b("facing")) {
            nbtContainer.func_74777_a("facing", (short)6);
        }
        if (TEClassName.contains("gregtechmod") && nbtContainer.func_74764_b("mFacing")) {
            nbtContainer.func_74777_a("mFacing", (short)this.getBarrelOrientationOnPlacement(player).ordinal());
        }
        if (TEClassName.contains("dmillerw.cchests.block.tile") && nbtContainer.func_74764_b("orientation")) {
            nbtContainer.func_74774_a("orientation", (byte)this.getBarrelOrientationOnPlacement(player).ordinal());
        }
        if (TEClassName.contains("net.mcft.copy.betterstorage.block.tileentity") && nbtContainer.func_74764_b("orientation")) {
            nbtContainer.func_74774_a("orientation", (byte)this.getBarrelOrientationOnPlacement(player).ordinal());
        }
        if (TEClassName.contains("jds.bibliocraft.tileentities") && nbtContainer.func_74764_b("bookcaseAngle")) {
            nbtContainer.func_74768_a("bookcaseAngle", (int)this.fromForgeToBiblio(this.getBarrelOrientationOnPlacement(player)));
        }
        if (TEClassName.contains("jds.bibliocraft.tileentities") && nbtContainer.func_74764_b("potionshelfAngle")) {
            nbtContainer.func_74768_a("potionshelfAngle", (int)this.fromForgeToBiblio(this.getBarrelOrientationOnPlacement(player)));
        }
        if (TEClassName.contains("jds.bibliocraft.tileentities") && nbtContainer.func_74764_b("rackAngle")) {
            nbtContainer.func_74768_a("rackAngle", (int)this.fromForgeToBiblio(this.getBarrelOrientationOnPlacement(player)));
        }
        if (TEClassName.contains("jds.bibliocraft.tileentities") && nbtContainer.func_74764_b("genericShelfAngle")) {
            nbtContainer.func_74768_a("genericShelfAngle", (int)this.fromForgeToBiblio(this.getBarrelOrientationOnPlacement(player)));
        }
        if (TEClassName.contains("jds.bibliocraft.tileentities.TileEntityArmorStand")) {
            blockMeta = this.fromForgeToBiblio(this.getBarrelOrientationOnPlacement(player));
        }
        if (TEClassName.contains("thermalexpansion.block.machine") && nbtContainer.func_74764_b("side.facing")) {
            ForgeDirection new_facing = this.getBarrelOrientationOnPlacement(player);
            byte[] side_array_old = nbtContainer.func_74770_j("side.array");
            byte[] side_array_new = (byte[])side_array_old.clone();
            int rotations = 0;
            for (ForgeDirection side_facing = ForgeDirection.getOrientation((int)nbtContainer.func_74771_c("side.facing")); side_facing != new_facing; side_facing = side_facing.getRotation(ForgeDirection.UP)) {
                ++rotations;
            }
            for (i = 2; i < 6; ++i) {
                ForgeDirection new_direction = ForgeDirection.getOrientation((int)i);
                for (int j = 0; j < rotations; ++j) {
                    new_direction = new_direction.getRotation(ForgeDirection.DOWN);
                }
                side_array_new[i] = side_array_old[new_direction.ordinal()];
            }
            nbtContainer.func_74773_a("side.array", side_array_new);
            nbtContainer.func_74774_a("side.facing", (byte)new_facing.ordinal());
        }
        if (nbtContainer.func_74779_i("id").equals("TileEntityBarrel")) {
            ForgeDirection newBarrelOrientation = this.getBarrelOrientationOnPlacement(player);
            int[] newSideArray = new int[6];
            int[] oldSideArray = nbtContainer.func_74759_k("sideUpgrades");
            int numberRotations = 0;
            for (ForgeDirection oldBarrelOrientation = ForgeDirection.getOrientation((int)nbtContainer.func_74762_e("orientation")); newBarrelOrientation != oldBarrelOrientation; oldBarrelOrientation = oldBarrelOrientation.getRotation(ForgeDirection.UP)) {
                ++numberRotations;
            }
            for (i = 0; i < 6; ++i) {
                ForgeDirection idir = ForgeDirection.getOrientation((int)i);
                for (int rot = 0; rot < numberRotations; ++rot) {
                    idir = idir.getRotation(ForgeDirection.UP);
                }
                newSideArray[idir.ordinal()] = oldSideArray[i];
            }
            nbtContainer.func_74768_a("orientation", newBarrelOrientation.ordinal());
            nbtContainer.func_74783_a("sideUpgrades", newSideArray);
        }
        world.func_147465_d(targX, targY, targZ, storedBlock, blockMeta, 3);
        world.func_147438_o(targX, targY, targZ).func_145839_a(nbtContainer);
        TileEntity entity = world.func_147438_o(targX, targY, targZ);
        if (classMap.get("ic2.api.tile.IWrenchable") != null && classMap.get("ic2.api.tile.IWrenchable").isInstance(entity)) {
            this.fixIC2Orientation(entity, player, targY);
        }
        if (TEClassName.contains("net.minecraft.tileentity.TileEntityChest")) {
            world.func_72921_c(targX, targY, targZ, blockMeta, 3);
        }
        stack.func_77978_p().func_82580_o("Container");
        world.func_147471_g(targX, targY, targZ);
        return true;
    }

    private void fixIC2Orientation(TileEntity entity, EntityPlayer player, int targY) {
        try {
            Method setFacing = classMap.get("ic2.api.tile.IWrenchable").getMethod("setFacing", Short.TYPE);
            Method wrenchCanSetFacing = classMap.get("ic2.api.tile.IWrenchable").getMethod("wrenchCanSetFacing", EntityPlayer.class, Integer.TYPE);
            if (((Boolean)wrenchCanSetFacing.invoke((Object)entity, player, (short)this.getBarrelOrientationOnPlacement(player, targY, true).ordinal())).booleanValue()) {
                setFacing.invoke((Object)entity, (short)this.getBarrelOrientationOnPlacement(player, targY, true).ordinal());
            } else {
                setFacing.invoke((Object)entity, (short)this.getBarrelOrientationOnPlacement(player, targY, false).ordinal());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean isTEMovable(TileEntity te) {
        if (te instanceof TileEntityMobSpawner) {
            return this.canPickSpawners();
        }
        if (te instanceof TileEntityBarrel) {
            return true;
        }
        if (te instanceof TileEntityChest) {
            return true;
        }
        for (Class c : classExtensions) {
            if (c == null || !c.isInstance(te)) continue;
            return true;
        }
        return false;
    }

    private boolean pickupBetterStorageFix(TileEntity container) {
        Method disconnect;
        Object lock;
        Method getLock;
        if (classMap.get("net.mcft.copy.betterstorage.api.lock.ILockable") != null && classMap.get("net.mcft.copy.betterstorage.api.lock.ILockable").isInstance(container)) {
            try {
                getLock = classMap.get("net.mcft.copy.betterstorage.api.lock.ILockable").getDeclaredMethod("getLock", null);
                lock = getLock.invoke((Object)container, (Object[])null);
                if (lock != null) {
                    return false;
                }
            }
            catch (Exception e) {
                System.out.printf("%s \n", e);
                return false;
            }
        }
        if (classMap.get("net.mcft.copy.betterstorage.api.ILockable") != null && classMap.get("net.mcft.copy.betterstorage.api.ILockable").isInstance(container)) {
            try {
                getLock = classMap.get("net.mcft.copy.betterstorage.api.ILockable").getDeclaredMethod("getLock", null);
                lock = getLock.invoke((Object)container, (Object[])null);
                if (lock != null) {
                    return false;
                }
            }
            catch (Exception e) {
                System.out.printf("%s \n", e);
                return false;
            }
        }
        if (classMap.get("net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable") != null && classMap.get("net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable").isInstance(container)) {
            try {
                disconnect = classMap.get("net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable").getDeclaredMethod("disconnect", null);
                disconnect.invoke((Object)container, (Object[])null);
            }
            catch (Exception e) {
                System.out.printf("%s \n", e);
                return false;
            }
        }
        if (classMap.get("net.mcft.copy.betterstorage.block.tileentity.TileEntityConnectable") != null && classMap.get("net.mcft.copy.betterstorage.block.tileentity.TileEntityConnectable").isInstance(container)) {
            try {
                disconnect = classMap.get("net.mcft.copy.betterstorage.block.tileentity.TileEntityConnectable").getDeclaredMethod("disconnect", null);
                disconnect.invoke((Object)container, (Object[])null);
            }
            catch (Exception e) {
                System.out.printf("%s \n", e);
                return false;
            }
        }
        return true;
    }

    protected boolean canPickSpawners() {
        return false;
    }

    protected boolean pickupContainer(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        Block storedBlock = world.func_147439_a(x, y, z);
        int blockMeta = world.func_72805_g(x, y, z);
        TileEntity containerTE = world.func_147438_o(x, y, z);
        NBTTagCompound nbtContainer = new NBTTagCompound();
        NBTTagCompound nbtTarget = new NBTTagCompound();
        if (!this.isTEMovable(containerTE)) {
            return false;
        }
        if (!this.pickupBetterStorageFix(containerTE)) {
            return false;
        }
        containerTE.func_145841_b(nbtContainer);
        nbtTarget.func_74778_a("Block", GameData.blockRegistry.func_148750_c((Object)storedBlock));
        nbtTarget.func_74768_a("Meta", blockMeta);
        nbtTarget.func_74778_a("TEClass", containerTE.getClass().getName());
        nbtTarget.func_74757_a("isSpawner", containerTE instanceof TileEntityMobSpawner);
        nbtTarget.func_74782_a("NBT", (NBTBase)nbtContainer);
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Container")) {
            stack.func_77978_p().func_82580_o("Container");
        }
        stack.func_77978_p().func_74782_a("Container", (NBTBase)nbtTarget);
        try {
            world.func_147475_p(x, y, z);
            world.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 3);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (world.field_72995_K) {
            return;
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Container") && entity instanceof EntityPlayer) {
            int amplifier = 1;
            if (stack.func_77978_p().func_74764_b("amount")) {
                amplifier = Math.min(4, stack.func_77978_p().func_74762_e("amount") / 2048);
            }
            ((EntityPlayer)entity).func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 10, amplifier));
            ((EntityPlayer)entity).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 10, amplifier));
        }
    }

    private ForgeDirection getBarrelOrientationOnPlacement(EntityPlayer player) {
        return this.getBarrelOrientationOnPlacement(player, 0, false);
    }

    private ForgeDirection getBarrelOrientationOnPlacement(EntityPlayer player, int targY, boolean allowVertical) {
        ForgeDirection barrelOrientation = ForgeDirection.UNKNOWN;
        Vec3 playerLook = player.func_70040_Z();
        barrelOrientation = Math.abs(playerLook.field_72450_a) >= Math.abs(playerLook.field_72449_c) ? (playerLook.field_72450_a > 0.0 ? ForgeDirection.WEST : ForgeDirection.EAST) : (playerLook.field_72449_c > 0.0 ? ForgeDirection.NORTH : ForgeDirection.SOUTH);
        if (allowVertical && player.field_70163_u > (double)targY) {
            barrelOrientation = ForgeDirection.UP;
        } else if (allowVertical && playerLook.field_72448_b > 0.73) {
            barrelOrientation = ForgeDirection.DOWN;
        }
        return barrelOrientation;
    }

    private ArrayList<ForgeDirection> convertOrientationFlagToForge(int flags) {
        ArrayList<ForgeDirection> directions = new ArrayList<ForgeDirection>();
        for (int i = 0; i < 4; ++i) {
            if ((1 << i & flags) == 0) continue;
            directions.add(ForgeDirection.getOrientation((int)(i + 2)));
        }
        return directions;
    }

    private int convertForgeToOrientationFlag(ArrayList<ForgeDirection> directions) {
        int flags = 0;
        for (ForgeDirection direction : directions) {
            flags += 1 << direction.ordinal() - 2;
        }
        return flags;
    }

    private String getBlockName(TileEntity tileEntity) {
        Block teBlock = tileEntity.func_145831_w().func_147439_a(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        ItemStack pick = null;
        try {
            pick = teBlock.getPickBlock(null, tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
            if (pick != null) {
                return pick.func_82833_r();
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return "<Unknown>";
    }

    private ForgeDirection fromMCToForge(short side) {
        switch (side) {
            case 0: {
                return ForgeDirection.DOWN;
            }
            case 1: {
                return ForgeDirection.UP;
            }
            case 2: {
                return ForgeDirection.EAST;
            }
            case 3: {
                return ForgeDirection.WEST;
            }
            case 4: {
                return ForgeDirection.NORTH;
            }
            case 5: {
                return ForgeDirection.SOUTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    private short fromForgeToMC(ForgeDirection side) {
        switch (side) {
            case DOWN: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case EAST: {
                return 2;
            }
            case WEST: {
                return 3;
            }
            case NORTH: {
                return 4;
            }
            case SOUTH: {
                return 5;
            }
            case UNKNOWN: {
                return -1;
            }
        }
        return -1;
    }

    private short fromForgeToBiblio(ForgeDirection side) {
        switch (side) {
            case EAST: {
                return 2;
            }
            case WEST: {
                return 0;
            }
            case NORTH: {
                return 1;
            }
            case SOUTH: {
                return 3;
            }
        }
        return -1;
    }

    static {
        classExtensionsNames.add("cpw.mods.ironchest.TileEntityIronChest");
        classExtensionsNames.add("buildcraft.energy.TileEngine");
        classExtensionsNames.add("buildcraft.factory.TileTank");
        classExtensionsNames.add("ic2.api.tile.IWrenchable");
        classExtensionsNames.add("mods.railcraft.common.blocks.machine.beta.TileEngine");
        classExtensionsNames.add("forestry.core.gadgets.Engine");
        classExtensionsNames.add("bluedart.tile.TileEntityForceEngine");
        classExtensionsNames.add("thermalexpansion.block.engine.TileEngineRoot");
        classExtensionsNames.add("thermalexpansion.block.machine.TileMachineRoot");
        classExtensionsNames.add("dmillerw.cchests.block.tile.TileChest");
        classExtensionsNames.add("net.mcft.copy.betterstorage.block.tileentity.TileEntityReinforcedChest");
        classExtensionsNames.add("net.mcft.copy.betterstorage.block.tileentity.TileEntityLocker");
        classExtensionsNames.add("net.mcft.copy.betterstorage.block.tileentity.TileEntityCardboardBox");
        classExtensionsNames.add("net.mcft.copy.betterstorage.tile.entity.TileEntityConnectable");
        classExtensionsNames.add("net.mcft.copy.betterstorage.block.tileentity.TileEntityConnectable");
        classExtensionsNames.add("net.mcft.copy.betterstorage.api.lock.ILockable");
        classExtensionsNames.add("net.mcft.copy.betterstorage.api.ILockable");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityBookcase");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityPotionShelf");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityWeaponRack");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityGenericShelf");
        classExtensionsNames.add("jds.bibliocraft.tileentities.TileEntityArmorStand");
        for (String s : classExtensionsNames) {
            try {
                classExtensions.add(Class.forName(s));
                classMap.put(s, Class.forName(s));
            }
            catch (ClassNotFoundException e) {
                classExtensions.add(null);
            }
        }
    }
}

