/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.common.items.upgrades;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.LanguageRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class StructuralLevel {
    public static String[] upgradeMaterialsList = new String[]{"Ore.plankWood", "Ore.ingotIron", "Ore.ingotGold", "Ore.gemDiamond", "Ore.obsidian", "Ore.whiteStone", "Ore.gemEmerald"};
    public static int maxCraftableTier = upgradeMaterialsList.length;
    public static StructuralLevel[] LEVELS;
    private static boolean structureArrayInitialized;
    public String name;
    public Utils.Material material;
    public ItemStack materialStack;
    private AccessibleTextureAtlasSprite iconBlockSide;
    private AccessibleTextureAtlasSprite iconBlockLabel;
    private AccessibleTextureAtlasSprite iconBlockTop;
    private AccessibleTextureAtlasSprite iconBlockTopLabel;
    private AccessibleTextureAtlasSprite iconItem;
    private int textColor;
    private int maxCoreSlots;
    private boolean needsMaterialInitialization = false;
    private int level = 0;
    @SideOnly(value=Side.CLIENT)
    private static BaseTextures baseTexturePixels;
    public static int[] structuralColorOverrides;

    private StructuralLevel() {
        this.textColor = -1;
        this.maxCoreSlots = 0;
    }

    private StructuralLevel(String materialin, int level) {
        this.level = level;
        this.material = new Utils.Material(materialin);
        this.needsMaterialInitialization = true;
        this.maxCoreSlots = 0;
        for (int i = 0; i < level; ++i) {
            this.maxCoreSlots += MathHelper.func_76128_c((double)Math.pow(2.0, i));
        }
        BetterBarrels.debug("03 - Created structural entry for [" + (this.material.isOreDict() ? this.material.name : this.material.modDomain + ":" + this.material.name + ":" + this.material.meta) + "] with " + this.maxCoreSlots + " slots.");
    }

    public void initializeMaterial() {
        if (this.needsMaterialInitialization) {
            this.materialStack = this.material.getStack();
        }
    }

    public static void initializeStructuralMaterials() {
        BetterBarrels.debug("04 - Looking up structural materials in the Ore Dictionary");
        for (StructuralLevel level : LEVELS) {
            level.initializeMaterial();
        }
    }

    public void discoverMaterialName() {
        BetterBarrels.debug("15 - Looking up user friendly name for " + (this.material.isOreDict() ? this.material.name : this.material.modDomain + ":" + this.material.name + ":" + this.material.meta));
        this.name = this.materialStack.func_82833_r();
        if (this.name.indexOf(".name") > 0) {
            this.name = LanguageRegistry.instance().getStringLocalization(this.name);
        }
        BetterBarrels.debug("16 - Found: " + this.name);
    }

    public static void createLevelArray() {
        if (structureArrayInitialized) {
            return;
        }
        LEVELS = new StructuralLevel[Math.min(18, upgradeMaterialsList.length) + 1];
        BetterBarrels.debug("02 - Creating materials array of length " + LEVELS.length);
        StructuralLevel.LEVELS[0] = new StructuralLevel();
        for (int i = 1; i < LEVELS.length; ++i) {
            StructuralLevel.LEVELS[i] = new StructuralLevel(upgradeMaterialsList[i - 1], i);
        }
        structureArrayInitialized = true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconSide() {
        return this.iconBlockSide;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTop() {
        return this.iconBlockTop;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconLabel() {
        return this.iconBlockLabel;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconLabelTop() {
        return this.iconBlockTopLabel;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconItem() {
        return this.iconItem;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTextColor() {
        return this.textColor;
    }

    public int getMaxCoreSlots() {
        return this.maxCoreSlots;
    }

    public static void loadBaseTextureData() {
        BetterBarrels.debug("08 - Pre-loading component texture data.");
        baseTexturePixels = new BaseTextures();
        StructuralLevel.baseTexturePixels.labelBorder = StructuralLevel.getPixelsForTexture(false, "JABBA:barrel_label_border");
        StructuralLevel.baseTexturePixels.labelBackground = StructuralLevel.getPixelsForTexture(false, "JABBA:barrel_label_background");
        StructuralLevel.baseTexturePixels.topBorder = StructuralLevel.getPixelsForTexture(false, "JABBA:barrel_top_border");
        StructuralLevel.baseTexturePixels.topBackground = StructuralLevel.getPixelsForTexture(false, "JABBA:barrel_top_background");
        StructuralLevel.baseTexturePixels.topLabel = StructuralLevel.getPixelsForTexture(false, "JABBA:barrel_top_label");
        StructuralLevel.baseTexturePixels.sideBorder = StructuralLevel.getPixelsForTexture(false, "JABBA:barrel_side_border");
        StructuralLevel.baseTexturePixels.sideBackground = StructuralLevel.getPixelsForTexture(false, "JABBA:barrel_side_background");
        StructuralLevel.baseTexturePixels.item = StructuralLevel.getPixelsForTexture(true, "JABBA:capaupg_base");
        StructuralLevel.baseTexturePixels.itemArrow = StructuralLevel.getPixelsForTexture(true, "JABBA:capaupg_color");
    }

    public static void unloadBaseTextureData() {
        BetterBarrels.debug("39 - Unloading preloaded texture data");
        baseTexturePixels = null;
    }

    @SideOnly(value=Side.CLIENT)
    private static AccessibleTextureAtlasSprite registerIcon(IIconRegister par1IconRegister, String key) {
        AccessibleTextureAtlasSprite ret = new AccessibleTextureAtlasSprite(key);
        if (((TextureMap)par1IconRegister).setTextureEntry(key, (TextureAtlasSprite)ret)) {
            return ret;
        }
        return (AccessibleTextureAtlasSprite)((TextureMap)par1IconRegister).getTextureExtry(key);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerItemIcon(IIconRegister par1IconRegister, int ordinal) {
        this.iconItem = StructuralLevel.registerIcon(par1IconRegister, "JABBA:blanks/capacity/" + String.valueOf(ordinal));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister par1IconRegister, int ordinal) {
        if (ordinal > 0) {
            this.iconBlockSide = StructuralLevel.registerIcon(par1IconRegister, "JABBA:blanks/side/" + String.valueOf(ordinal));
            this.iconBlockLabel = StructuralLevel.registerIcon(par1IconRegister, "JABBA:blanks/label/" + String.valueOf(ordinal));
            this.iconBlockTop = StructuralLevel.registerIcon(par1IconRegister, "JABBA:blanks/top/" + String.valueOf(ordinal));
            this.iconBlockTopLabel = StructuralLevel.registerIcon(par1IconRegister, "JABBA:blanks/toplabel/" + String.valueOf(ordinal));
        } else {
            this.iconBlockSide = StructuralLevel.registerIcon(par1IconRegister, "JABBA:barrel_side_" + String.valueOf(ordinal));
            this.iconBlockTop = StructuralLevel.registerIcon(par1IconRegister, "JABBA:barrel_top_" + String.valueOf(ordinal));
            this.iconBlockLabel = StructuralLevel.registerIcon(par1IconRegister, "JABBA:barrel_label_" + String.valueOf(ordinal));
            this.iconBlockTopLabel = StructuralLevel.registerIcon(par1IconRegister, "JABBA:barrel_labeltop_" + String.valueOf(ordinal));
        }
    }

    public static String romanNumeral(int num) {
        LinkedHashMap<String, Integer> numeralConversion = new LinkedHashMap<String, Integer>();
        numeralConversion.put("M", 1000);
        numeralConversion.put("CM", 900);
        numeralConversion.put("D", 500);
        numeralConversion.put("CD", 400);
        numeralConversion.put("C", 100);
        numeralConversion.put("XC", 90);
        numeralConversion.put("L", 50);
        numeralConversion.put("XL", 40);
        numeralConversion.put("X", 10);
        numeralConversion.put("IX", 9);
        numeralConversion.put("V", 5);
        numeralConversion.put("IV", 4);
        numeralConversion.put("I", 1);
        String result = new String();
        while (numeralConversion.size() > 0) {
            String romanKey = (String)numeralConversion.keySet().toArray()[0];
            Integer arabicValue = (Integer)numeralConversion.values().toArray()[0];
            if (num < arabicValue) {
                numeralConversion.remove(romanKey);
                continue;
            }
            num -= arabicValue.intValue();
            result = result + romanKey;
        }
        return result;
    }

    private void grainMergeArrayWithColor(int[] pixels, PixelARGB color) {
        BetterBarrels.debug("35 - Running grain merge on material with color");
        for (int i = 0; i < pixels.length; ++i) {
            PixelARGB pix = new PixelARGB(pixels[i]);
            pixels[i] = pix.A == 0 ? 0 : (StructuralLevel)this.new PixelARGB((int)255, (int)Math.max((int)0, (int)Math.min((int)255, (int)(pix.R + color.R - 128))), (int)Math.max((int)0, (int)Math.min((int)255, (int)(pix.G + color.G - 128))), (int)Math.max((int)0, (int)Math.min((int)255, (int)(pix.B + color.B - 128)))).combined;
        }
        BetterBarrels.debug("36 - sanity check, pixels.length:" + pixels.length);
    }

    private void mergeArraysBasedOnAlpha(int[] target, int[] merge) {
        for (int i = 0; i < merge.length; ++i) {
            PixelARGB targetPixel = new PixelARGB(target[i]);
            PixelARGB mergePixel = new PixelARGB(merge[i]);
            target[i] = mergePixel.A == 0 ? targetPixel.combined : mergePixel.combined;
        }
    }

    private PixelARGB averageColorFromArray(int[] pixels) {
        PixelARGB totals = new PixelARGB(0);
        for (int pixel : pixels) {
            totals.alphaAdd(new PixelARGB(pixel));
        }
        return totals.normalize();
    }

    private PixelARGB averageColorFromArrayB(int[] pixels) {
        PixelARGB totals = new PixelARGB(0);
        for (int pixel : pixels) {
            totals.addSkipTransparent(new PixelARGB(pixel));
        }
        return totals.normalizeIgnoreAlpha();
    }

    @SideOnly(value=Side.CLIENT)
    private static int[] getPixelsForTexture(boolean item, ResourceLocation resourcelocation) {
        BetterBarrels.debug("09 - Entering texture load method for texture : " + resourcelocation.toString());
        ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), String.format("%s/%s%s", item ? "textures/items" : "textures/blocks", resourcelocation.func_110623_a(), ".png"));
        BetterBarrels.debug("11 - Modified resource path : " + resourcelocation1.toString());
        int[] pixels = null;
        try {
            pixels = TextureUtil.func_110986_a((IResourceManager)Minecraft.func_71410_x().func_110442_L(), (ResourceLocation)resourcelocation1);
        }
        catch (Throwable t) {
            BetterBarrels.log.severe("JABBA-Debug Problem loading texture: " + resourcelocation);
        }
        BetterBarrels.debug("12 - read texture data of length : " + (pixels != null ? Integer.valueOf(pixels.length) : "(null)"));
        return pixels;
    }

    @SideOnly(value=Side.CLIENT)
    private static int[] getPixelsForTexture(boolean item, String location) {
        return StructuralLevel.getPixelsForTexture(item, new ResourceLocation(location));
    }

    @SideOnly(value=Side.CLIENT)
    private static int[] getPixelsForTexture(boolean item, IIcon icon) {
        int[] pixels = StructuralLevel.getPixelsForTexture(item, new ResourceLocation(icon.func_94215_i()));
        if (pixels == null) {
            pixels = new int[icon.func_94216_b() * icon.func_94211_a()];
            BetterBarrels.debug("13 - No texture data read, creating empty array of length : " + pixels.length);
        }
        return pixels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @SideOnly(value=Side.CLIENT)
    public void generateIcons() {
        BetterBarrels.debug("17 - Entering Texture Generation for Structural Tier with Material: " + this.name);
        terrainTextureId = Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110575_b).func_110552_b();
        itemTextureId = Minecraft.func_71410_x().field_71446_o.func_110581_b(TextureMap.field_110576_c).func_110552_b();
        if (terrainTextureId != 0 && itemTextureId != 0) {
            previousTextureID = GL11.glGetInteger((int)32873);
            labelBorderPixels = (int[])StructuralLevel.baseTexturePixels.labelBorder.clone();
            BetterBarrels.debug("18 - " + labelBorderPixels.length);
            labelBackgroundPixels = (int[])StructuralLevel.baseTexturePixels.labelBackground.clone();
            BetterBarrels.debug("19 - " + labelBackgroundPixels.length);
            topBorderPixels = (int[])StructuralLevel.baseTexturePixels.topBorder.clone();
            BetterBarrels.debug("20 - " + topBorderPixels.length);
            topBackgroundPixels = (int[])StructuralLevel.baseTexturePixels.topBackground.clone();
            BetterBarrels.debug("21 - " + topBackgroundPixels.length);
            topLabelBorderPixels = (int[])StructuralLevel.baseTexturePixels.topBorder.clone();
            BetterBarrels.debug("22 - " + topLabelBorderPixels.length);
            topLabelBackgroundPixels = (int[])StructuralLevel.baseTexturePixels.topLabel.clone();
            BetterBarrels.debug("23 - " + topLabelBackgroundPixels.length);
            sideBorderPixels = (int[])StructuralLevel.baseTexturePixels.sideBorder.clone();
            BetterBarrels.debug("24 - " + sideBorderPixels.length);
            sideBackgroundPixels = (int[])StructuralLevel.baseTexturePixels.sideBackground.clone();
            BetterBarrels.debug("25 - " + sideBackgroundPixels.length);
            itemBasePixels = (int[])StructuralLevel.baseTexturePixels.item.clone();
            BetterBarrels.debug("26 - " + itemBasePixels.length);
            itemArrowPixels = (int[])StructuralLevel.baseTexturePixels.itemArrow.clone();
            BetterBarrels.debug("27 - " + itemArrowPixels.length);
            itemRomanPixels = StructuralLevel.getPixelsForTexture(true, (IIcon)this.iconItem);
            BetterBarrels.debug("28 - " + itemRomanPixels.length);
            materialPixels = null;
            foundSourceMaterial = false;
            if (StructuralLevel.structuralColorOverrides[this.level - 1] == -1) {
                try {
                    materialBlock = Block.func_149634_a((Item)this.materialStack.func_77973_b());
                    materialItem = this.materialStack.func_77973_b();
                    if (materialBlock != Blocks.field_150350_a && !materialBlock.func_149739_a().equalsIgnoreCase("tile.ForgeFiller")) {
                        BetterBarrels.debug("32 - Block found");
                        materialPixels = StructuralLevel.getPixelsForTexture(false, (IIcon)((TextureAtlasSprite)materialBlock.func_149691_a(0, this.materialStack.func_77960_j())));
                        foundSourceMaterial = true;
                        BetterBarrels.debug("33 - Loaded texture data for [" + this.name + "]: read an array of length: " + (materialPixels != null ? Integer.valueOf(materialPixels.length) : "(null)"));
                    } else if (materialItem != null) {
                        BetterBarrels.debug("30 - Item found, attempting to load");
                        materialPixels = StructuralLevel.getPixelsForTexture(true, (IIcon)((TextureAtlasSprite)materialItem.func_77617_a(this.materialStack.func_77960_j())));
                        foundSourceMaterial = true;
                        BetterBarrels.debug("30 - Loaded texture data for [" + this.name + "]: read an array of length: " + (materialPixels != null ? Integer.valueOf(materialPixels.length) : "(null)"));
                    }
                    if (foundSourceMaterial) ** GOTO lbl64
                    BetterBarrels.log.severe("Encountered an issue while locating the requested source material[" + (this.material.isOreDict() != false ? this.material.name : this.material.modDomain + ":" + this.material.name + ":" + this.material.meta) + "].  Ore Dictionary returned " + this.materialStack.func_77977_a() + " as the first itemStack for that request.");
                }
                catch (Throwable t) {
                    try {
                        BetterBarrels.debug("34 - MATERIAL LOOKUP ERROR");
                        BetterBarrels.log.severe("Error loading resource material texture: " + t.getMessage());
                        t.printStackTrace();
                        if (foundSourceMaterial) ** GOTO lbl64
                        BetterBarrels.log.severe("Encountered an issue while locating the requested source material[" + (this.material.isOreDict() != false ? this.material.name : this.material.modDomain + ":" + this.material.name + ":" + this.material.meta) + "].  Ore Dictionary returned " + this.materialStack.func_77977_a() + " as the first itemStack for that request.");
                    }
                    catch (Throwable var19_21) {
                        if (!foundSourceMaterial) {
                            BetterBarrels.log.severe("Encountered an issue while locating the requested source material[" + (this.material.isOreDict() != false ? this.material.name : this.material.modDomain + ":" + this.material.name + ":" + this.material.meta) + "].  Ore Dictionary returned " + this.materialStack.func_77977_a() + " as the first itemStack for that request.");
                        }
                        throw var19_21;
                    }
                }
            } else {
                materialPixels = new int[]{StructuralLevel.structuralColorOverrides[this.level - 1]};
                foundSourceMaterial = true;
            }
lbl64:
            // 5 sources

            if (foundSourceMaterial) {
                color = this.averageColorFromArrayB(materialPixels);
                BetterBarrels.debug("Calculated Color for [" + this.name + "]: {R: " + color.R + ", G: " + color.G + ", B: " + color.B + "}");
                this.textColor = color.YIQContrastTextColor().combined;
                this.grainMergeArrayWithColor(labelBorderPixels, color);
                this.grainMergeArrayWithColor(topBorderPixels, color);
                this.grainMergeArrayWithColor(topLabelBorderPixels, color);
                this.grainMergeArrayWithColor(sideBorderPixels, color);
                this.grainMergeArrayWithColor(itemArrowPixels, color);
                this.textColor = this.averageColorFromArrayB((int[])labelBorderPixels).YIQContrastTextColor().combined;
                try {
                    this.mergeArraysBasedOnAlpha(labelBorderPixels, labelBackgroundPixels);
                    this.mergeArraysBasedOnAlpha(topBorderPixels, topBackgroundPixels);
                    this.mergeArraysBasedOnAlpha(topLabelBorderPixels, topLabelBackgroundPixels);
                    this.mergeArraysBasedOnAlpha(sideBorderPixels, sideBackgroundPixels);
                    this.mergeArraysBasedOnAlpha(itemBasePixels, itemArrowPixels);
                    this.mergeArraysBasedOnAlpha(itemBasePixels, itemRomanPixels);
                    GL11.glPushAttrib((int)1048575);
                    GL11.glBindTexture((int)3553, (int)terrainTextureId);
                    this.iconBlockLabel.replaceTextureData(labelBorderPixels, Minecraft.func_71410_x().field_71474_y.field_151442_I);
                    this.iconBlockTop.replaceTextureData(topBorderPixels, Minecraft.func_71410_x().field_71474_y.field_151442_I);
                    this.iconBlockTopLabel.replaceTextureData(topLabelBorderPixels, Minecraft.func_71410_x().field_71474_y.field_151442_I);
                    this.iconBlockSide.replaceTextureData(sideBorderPixels, Minecraft.func_71410_x().field_71474_y.field_151442_I);
                    GL11.glBindTexture((int)3553, (int)itemTextureId);
                    this.iconItem.replaceTextureData(itemBasePixels, 0);
                    GL11.glBindTexture((int)3553, (int)previousTextureID);
                    GL11.glPopAttrib();
                }
                catch (Exception e) {
                    BetterBarrels.log.severe("" + e.getMessage());
                }
            }
        }
    }

    static {
        structureArrayInitialized = false;
        structuralColorOverrides = null;
    }

    private class PixelARGB {
        int A;
        int R;
        int G;
        int B;
        int combined;
        private int addCount = 0;

        PixelARGB(int pixel) {
            this.A = pixel >> 24 & 0xFF;
            this.R = pixel >> 16 & 0xFF;
            this.G = pixel >> 8 & 0xFF;
            this.B = pixel & 0xFF;
            this.combined = pixel;
        }

        PixelARGB(int alpha, int red, int green, int blue) {
            this.A = alpha;
            this.R = red;
            this.G = green;
            this.B = blue;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
        }

        PixelARGB alphaAdd(PixelARGB add) {
            ++this.addCount;
            this.A += add.A;
            this.R += add.R * add.A / 255;
            this.G += add.G * add.G / 255;
            this.B += add.B * add.B / 255;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
            return this;
        }

        PixelARGB normalize() {
            if (this.addCount == 0) {
                return this;
            }
            this.R = this.R * 255 / this.A;
            this.G = this.G * 255 / this.A;
            this.B = this.B * 255 / this.A;
            this.A /= this.addCount;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
            this.addCount = 0;
            return this;
        }

        PixelARGB addIgnoreAlpha(PixelARGB add) {
            ++this.addCount;
            this.R += add.R;
            this.G += add.G;
            this.B += add.B;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
            return this;
        }

        PixelARGB addSkipTransparent(PixelARGB add) {
            if (add.A == 0) {
                return this;
            }
            ++this.addCount;
            this.R += add.R;
            this.G += add.G;
            this.B += add.B;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
            return this;
        }

        PixelARGB normalizeIgnoreAlpha() {
            if (this.addCount == 0) {
                return this;
            }
            this.R /= this.addCount;
            this.G /= this.addCount;
            this.B /= this.addCount;
            this.combined = ((this.A & 0xFF) << 24) + ((this.R & 0xFF) << 16) + ((this.G & 0xFF) << 8) + (this.B & 0xFF);
            this.addCount = 0;
            return this;
        }

        PixelARGB YIQContrastTextColor() {
            int color = (this.R * 299 + this.G * 587 + this.B * 114) / 1000 >= 128 ? 0 : 255;
            return new PixelARGB(255, color, color, color);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class AccessibleTextureAtlasSprite
    extends TextureAtlasSprite {
        private static Method fixPixels = null;
        private static Method setupAnisotropic = null;
        private static Field useAnisotropic = null;

        AccessibleTextureAtlasSprite(String par1Str) {
            super(par1Str);
        }

        public void replaceTextureData(int[] pixels, int mipmapLevels) throws Exception {
            this.func_110968_a(Lists.newArrayList());
            int[][] aint = new int[1 + mipmapLevels][];
            aint[0] = pixels;
            fixPixels.invoke((Object)this, new Object[]{aint});
            this.field_110976_a.add((int[][])setupAnisotropic.invoke((Object)this, new Object[]{aint, useAnisotropic.getBoolean((Object)this) ? this.field_130223_c - 16 : this.field_130223_c, useAnisotropic.getBoolean((Object)this) ? this.field_130224_d - 16 : this.field_130224_d}));
            this.func_147963_d(mipmapLevels);
            BetterBarrels.debug("37 - Attempting to replace texture for [" + this.func_94215_i() + "] with an array of [" + (this.func_147965_a(0) != null ? Integer.valueOf(this.func_147965_a(0)[0].length) : "(null)") + "] pixels, current texture dims are [" + this.field_130223_c + "x" + this.field_130224_d + "] for a total size of " + this.field_130223_c * this.field_130224_d);
            BetterBarrels.debug(this.toString());
            if (this.func_147965_a(0)[0].length != this.field_130224_d * this.field_130223_c) {
                throw new Exception("Attempting to replace texture image data with too much or too little data.");
            }
            BetterBarrels.debug("38 - Calling Minecraft Texture upload utility method");
            TextureUtil.func_147955_a((int[][])this.func_147965_a(0), (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            this.func_130103_l();
        }

        static {
            for (String fieldName : new String[]{"k", "field_147966_k", "useAnisotropicFiltering"}) {
                try {
                    useAnisotropic = TextureAtlasSprite.class.getDeclaredField(fieldName);
                    if (useAnisotropic == null) continue;
                    useAnisotropic.setAccessible(true);
                    break;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (useAnisotropic == null) {
                BetterBarrels.log.severe("Unable to locate required field 'useAnisotropicFiltering' for texture generation.  Please post this error at the error tracker along with a copy of your ForgeModLoader-client-0.log.");
            }
            for (String methodName : new String[]{"a", "func_147961_a", "fixTransparentPixels"}) {
                try {
                    fixPixels = TextureAtlasSprite.class.getDeclaredMethod(methodName, int[][].class);
                    if (fixPixels == null) continue;
                    fixPixels.setAccessible(true);
                    break;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (fixPixels == null) {
                BetterBarrels.log.severe("Unable to locate required method 'fixTransparentPixels' for texture generation.  Please post this error at the error tracker along with a copy of your ForgeModLoader-client-0.log.");
            }
            for (String methodName : new String[]{"a", "func_147960_a", "prepareAnisotropicFiltering"}) {
                try {
                    setupAnisotropic = TextureAtlasSprite.class.getDeclaredMethod(methodName, int[][].class, Integer.TYPE, Integer.TYPE);
                    if (setupAnisotropic == null) continue;
                    setupAnisotropic.setAccessible(true);
                    break;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (setupAnisotropic == null) {
                BetterBarrels.log.severe("Unable to locate required method 'prepareAnisotropicFiltering' for texture generation.  Please post this error at the error tracker along with a copy of your ForgeModLoader-client-0.log.");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class BaseTextures {
        public int[] labelBackground;
        public int[] labelBorder;
        public int[] topBackground;
        public int[] topBorder;
        public int[] topLabel;
        public int[] sideBackground;
        public int[] sideBorder;
        public int[] item;
        public int[] itemArrow;

        private BaseTextures() {
        }
    }
}

