/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public abstract class DerpyRegistry {
    public static LinkedHashMap<ItemStack, TieredMachineEntry> millstoneRecipes = new LinkedHashMap();
    public static LinkedHashMap<ItemStack, CentrifugeEntry> centrifugeRecipes = new LinkedHashMap();
    public static List<BasicBlockEntry> leafTypes = new ArrayList<BasicBlockEntry>();

    public static ItemStack getKey(Map<ItemStack, ? extends BasicMachineEntry> machine, ItemStack stack) {
        for (Map.Entry<ItemStack, ? extends BasicMachineEntry> entry : machine.entrySet()) {
            if (!DerpyRegistry.isValidFor(stack, entry.getKey())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static TieredMachineEntry getOutput(Map<ItemStack, ? extends TieredMachineEntry> machine, ItemStack stack, int tier) {
        for (Map.Entry<ItemStack, ? extends TieredMachineEntry> entry : machine.entrySet()) {
            if (!DerpyRegistry.isValidForWithTier(stack, entry.getKey(), entry.getValue(), tier)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static boolean isValidForMachine(Map<ItemStack, ? extends TieredMachineEntry> machine, ItemStack stack, int tier) {
        if (stack == null) {
            return false;
        }
        for (Map.Entry<ItemStack, ? extends TieredMachineEntry> entry : machine.entrySet()) {
            if (!DerpyRegistry.isValidForWithTier(stack, entry.getKey(), entry.getValue(), tier)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidForWithTier(ItemStack stack, ItemStack key, TieredMachineEntry value, int tier) {
        return value.tier <= tier && DerpyRegistry.isValidFor(stack, key);
    }

    public static boolean isValidForWithSize(ItemStack stack, ItemStack key) {
        return stack.field_77994_a >= key.field_77994_a && DerpyRegistry.isValidFor(stack, key);
    }

    public static boolean isValidFor(ItemStack stack, ItemStack key) {
        return stack.func_77973_b() == key.func_77973_b() && stack.func_77960_j() == key.func_77960_j() || DerpyRegistry.matchesOredict(stack, key);
    }

    public static boolean matchesOredict(ItemStack stack, ItemStack key) {
        int[] stackDict = OreDictionary.getOreIDs((ItemStack)stack);
        int[] keyDict = OreDictionary.getOreIDs((ItemStack)key);
        for (int s : stackDict) {
            for (int e : keyDict) {
                if (s != e) continue;
                return true;
            }
        }
        return false;
    }

    public static class BasicBlockEntry {
        public Block block;
        public int meta;

        public BasicBlockEntry(Block block, int meta) {
            this.block = block;
            this.meta = meta;
        }
    }

    public static class CentrifugeEntry
    extends TieredMachineEntry {
        public ItemStack output2;
        public ItemStack output3;

        public CentrifugeEntry(ItemStack output, ItemStack output2, ItemStack output3, float exp, int energy, int tier) {
            super(output, exp, energy, tier);
            this.output2 = output2;
            this.output3 = output3;
        }
    }

    public static class TieredMachineEntry
    extends BasicMachineEntry {
        public int tier;

        public TieredMachineEntry(ItemStack output, float exp, int energy, int tier) {
            super(output, exp, energy);
            this.tier = tier;
        }
    }

    public static class BasicMachineEntry {
        public ItemStack output;
        public float exp;
        public int energy;

        public BasicMachineEntry(ItemStack output, float exp, int energy) {
            this.output = output;
            this.exp = exp;
            this.energy = energy;
        }
    }
}

