/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz;

import com.google.common.primitives.UnsignedBytes;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.config.Configuration;
import net.wuerfel21.derpyshiz.CommonProxy;
import net.wuerfel21.derpyshiz.DerpyRegistry;
import net.wuerfel21.derpyshiz.TabRotary;

@Mod(modid="derpyshiz", name="The Derpy Shiz Mod", version="beta 0.4.1")
public class Main {
    public static final Material machineMaterial = new Material(MapColor.field_151663_o);
    public static final int[] orientationHelper = new int[]{0, 0, 2, 2, 1, 1};
    public static final int[] reverseHelper = new int[]{1, 0, 3, 2, 5, 4};
    public static final int[] diodeHelper = new int[]{-1, -1, 0, 2, 3, 1};
    public static final int[] stairHelper = new int[]{-1, -1, 2, 3, 0, 1};
    public static final int[] armorTypeToSlot = new int[]{4, 3, 2, 1};
    public static final String MODID = "derpyshiz";
    public static final String MODNAME = "The Derpy Shiz Mod";
    public static final String VERSION = "beta 0.4.1";
    public static Configuration config;
    public static int idMagicBiome;
    public static boolean fancyGearbox;
    public static boolean flashy;
    public static int maxWaterswordDistance;
    public static boolean checkForUpdates;
    public static String updateURL;
    public static int[] oreTries;
    public static int[] oreVeinSize;
    public static double gearboxBaseDistance;
    public static double seizureWoolDistance;
    public static boolean isDevEnv;
    public static SimpleNetworkWrapper derpnet;
    public static CreativeTabs tabRotary;
    @Mod.Instance(value="derpyshiz")
    public static Main instance;
    @SidedProxy(clientSide="net.wuerfel21.derpyshiz.ClientProxy", serverSide="net.wuerfel21.derpyshiz.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        try {
            isDevEnv = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
        }
        catch (Exception exception) {
            // empty catch block
        }
        instance = this;
        derpnet = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        config = new Configuration(e.getSuggestedConfigurationFile(), null);
        config.load();
        idMagicBiome = UnsignedBytes.saturatedCast((long)config.getInt("idMagicBiome", "ids", 69, 0, 255, "The id of the Magic Forest"));
        fancyGearbox = config.getBoolean("fancyGearbox", "client", true, "If gearboxes should be uber fancy");
        flashy = config.getBoolean("flashy", "client", true, "If flashing textures should be used. false also saves some tiny bits of performance when near such things.");
        maxWaterswordDistance = config.getInt("maxWaterswordDistance", "server", 64, 0, 255, "Maximum distance one can go up/down with a flood cutlass. Normally you wont have 64 blocks deep oceans, so you wont notice this setting too much. This is used to reduce server load on servers with loads of flood cutlasses/lots of oceans.");
        checkForUpdates = config.getBoolean("checkForUpdates", "updates", !isDevEnv, "Wheter to check for updates or not");
        updateURL = config.getString("updateURL", "updates", "https://raw.githubusercontent.com/Wuerfel21/The-Derpy-Shiz-Mod/master/currentVersion.thisIsUsedForUpdateChecking", "where to check for updates. dont change unless you know what a tacco is.");
        gearboxBaseDistance = config.getFloat("gearboxBaseDistance", "client", 128.0f, 32.0f, 4096.0f, "Base render distance For gearboxes and other rotary output things, in Blocks. Actually used value will be this + the length of the axis");
        seizureWoolDistance = Math.pow(config.getFloat("seizureWoolDistance", "client", 128.0f, 32.0f, 4096.0f, "Render distance for seizure wool. Increase to be able to see seizure wool from further away."), 2.0);
        Main.oreTries[0] = config.getInt("triesAmber", "oreTries", 6, 0, Integer.MAX_VALUE, "Maximum amount of Amber veins per chunk");
        Main.oreTries[1] = config.getInt("triesFakediamond", "oreTries", 5, 0, Integer.MAX_VALUE, "Maximum amount of Fakediamond veins per chunk");
        Main.oreTries[2] = config.getInt("triesTitanium", "oreTries", 5, 0, Integer.MAX_VALUE, "Maximum amount of Titanium veins per chunk");
        Main.oreTries[3] = config.getInt("triesRuby", "oreTries", 1, 0, Integer.MAX_VALUE, "Maximum amount of Ruby veins per chunk");
        Main.oreTries[4] = config.getInt("triesTurquoise", "oreTries", 20, 0, Integer.MAX_VALUE, "Maximum amount of Turquoise veins per chunk");
        Main.oreTries[5] = config.getInt("triesAmethyst", "oreTries", 2, 0, Integer.MAX_VALUE, "Maximum amount of Amethyst veins per chunk");
        Main.oreTries[6] = config.getInt("triesFluorite", "oreTries", 6, 0, Integer.MAX_VALUE, "Maximum amount of Fluorite veins per chunk (All colors combined)");
        Main.oreTries[7] = config.getInt("triesCopper", "oreTries", 16, 0, Integer.MAX_VALUE, "Maximum amount of Copper veins per chunk");
        Main.oreTries[8] = config.getInt("triesEnderium", "oreTries", 19, 0, Integer.MAX_VALUE, "Maximum amount of Enderium veins per chunk");
        Main.oreTries[9] = config.getInt("triesElectrimite", "oreTries", 9, 0, Integer.MAX_VALUE, "Maximum amount of Electrimite veins per chunk");
        Main.oreTries[10] = config.getInt("triesDarkness", "oreTries", 5, 0, Integer.MAX_VALUE, "Maximum amount of Dark Ore veins per chunk (Different reduction mechanic!)");
        Main.oreTries[11] = config.getInt("triesTin", "oreTries", 17, 0, Integer.MAX_VALUE, "Maximum amount of Tin veins per chunk");
        Main.oreTries[12] = config.getInt("triesLead", "oreTries", 4, 0, Integer.MAX_VALUE, "Maximum amount of Lead veins per chunk");
        Main.oreTries[13] = config.getInt("triesWuerfelium", "oreTries", 8, 0, Integer.MAX_VALUE, "Maximum amount of Wuerfelium veins per chunk");
        Main.oreVeinSize[0] = config.getInt("veinSizeAmber", "oreVeinSize", 8, 0, Integer.MAX_VALUE, "Maximum size of Amber veins");
        Main.oreVeinSize[1] = config.getInt("veinSizeFakediamond", "oreVeinSize", 5, 0, Integer.MAX_VALUE, "Maximum size of Fakediamond veins");
        Main.oreVeinSize[2] = config.getInt("veinSizeTitanium", "oreVeinSize", 7, 0, Integer.MAX_VALUE, "Maximum size of Titanium veins");
        Main.oreVeinSize[3] = config.getInt("veinSizeRuby", "oreVeinSize", 7, 0, Integer.MAX_VALUE, "Maximum size of Ruby veins");
        Main.oreVeinSize[4] = config.getInt("veinSizeTurquoise", "oreVeinSize", 3, 0, Integer.MAX_VALUE, "Maximum size of Turquoise veins");
        Main.oreVeinSize[5] = config.getInt("veinSizeAmethyst", "oreVeinSize", 12, 0, Integer.MAX_VALUE, "Maximum size of Amethyst veins");
        Main.oreVeinSize[6] = config.getInt("veinSizeFluorite", "oreVeinSize", 10, 0, Integer.MAX_VALUE, "Maximum size of Fluorite veins (All colors combined)");
        Main.oreVeinSize[7] = config.getInt("veinSizeCopper", "oreVeinSize", 10, 0, Integer.MAX_VALUE, "Maximum size of Copper veins");
        Main.oreVeinSize[8] = config.getInt("veinSizeEnderium", "oreVeinSize", 8, 0, Integer.MAX_VALUE, "Maximum size of Enderium veins");
        Main.oreVeinSize[9] = config.getInt("veinSizeElectrimite", "oreVeinSize", 7, 0, Integer.MAX_VALUE, "Maximum size of Electrimite veins");
        Main.oreVeinSize[10] = config.getInt("veinSizeDarkness", "oreVeinSize", 5, 0, Integer.MAX_VALUE, "Maximum size of Dark Ore veins");
        Main.oreVeinSize[11] = config.getInt("veinSizeTin", "oreVeinSize", 10, 0, Integer.MAX_VALUE, "Maximum size of Tin veins");
        Main.oreVeinSize[12] = config.getInt("veinSizeLead", "oreVeinSize", 15, 0, Integer.MAX_VALUE, "Maximum size of Lead veins");
        Main.oreVeinSize[13] = config.getInt("veinSizeWuerfelium", "oreVeinSize", 10, 0, Integer.MAX_VALUE, "Maximum size of Wuerfelium veins");
        config.save();
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
        NBTTagCompound tag = new NBTTagCompound();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    @Mod.EventHandler
    public void IMCCallback(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            switch (msg.key) {
                case "registerLeafType": {
                    DerpyRegistry.leafTypes.add(new DerpyRegistry.BasicBlockEntry(GameRegistry.findBlock((String)msg.getNBTValue().func_74779_i("sourceMod"), (String)msg.getNBTValue().func_74779_i("blockID")), msg.getNBTValue().func_74762_e("meta")));
                }
            }
        }
    }

    static {
        oreTries = new int[14];
        oreVeinSize = new int[14];
        isDevEnv = false;
        tabRotary = new TabRotary();
    }
}

