/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.wuerfel21.derpyshiz.IMetaItemBlock;

public class DerpyOres
extends Block
implements IMetaItemBlock {
    public IIcon[] icons = new IIcon[16];
    public static final String[] names = new String[]{"amber", "fakediamond", "titanium", "ruby", "turquoise", "amethyst", "fluorite_brown", "fluorite_red", "fluorite_pink", "copper", "enderium", "electrimite", "darkness", "tin", "lead", "wuerfelium"};
    public static final int amberIndex = 0;
    public static final int amethystIndex = 5;
    public static final int darknessIndex = 12;
    public static final float[] hardness = new float[]{2.0f, 1.0f, 4.0f, 3.0f, 3.0f, 10.0f, 2.0f, 2.0f, 2.0f, 2.0f, 15.0f, 2.0f, 20.0f, 1.5f, 2.5f, 8.0f};
    public static final int[] level = new int[]{1, 0, 2, 2, 1, 3, 1, 1, 1, 1, 4, 2, 3, 1, 2, 2};
    public static final boolean[] dropself = new boolean[]{false, false, true, false, false, false, false, false, false, true, true, true, false, true, true, false};

    public DerpyOres() {
        super(Material.field_151576_e);
        this.func_149663_c("derpyshiz.ore");
        this.func_149658_d("derpyshiz:ore");
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149672_a(field_149780_i);
        this.func_149752_b(5.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public void func_149651_a(IIconRegister reg) {
        for (int i = 0; i < 16; ++i) {
            this.icons[i] = reg.func_94245_a(this.field_149768_d + "_" + names[i]);
        }
    }

    public IIcon func_149691_a(int side, int meta) {
        return this.icons[meta];
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 16; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta >= 16) {
            return 1.5f;
        }
        return hardness[meta];
    }

    public int getHarvestLevel(int meta) {
        if (meta >= 16) {
            return 1;
        }
        return level[meta];
    }

    public int calcFortune(int meta, int level, int normal, Random rand) {
        if (level > 0) {
            int j = rand.nextInt(level + 2) - 1;
            if (j < 0) {
                j = 0;
            }
            return this.func_149745_a(rand) * (j + 1);
        }
        return normal;
    }

    public int quantityDropped(int meta, int fortune, Random rand) {
        if (meta >= 16) {
            return 64;
        }
        if (dropself[meta]) {
            return 1;
        }
        switch (meta) {
            case 0: {
                return this.calcFortune(meta, fortune, rand.nextInt(2) + 1, rand);
            }
            case 5: {
                return this.calcFortune(meta, fortune, rand.nextInt(20 + fortune * 2) == 0 ? 0 : 1, rand);
            }
            case 12: {
                return 1;
            }
        }
        return this.calcFortune(meta, fortune, 1, rand);
    }

    public Item func_149650_a(int meta, Random rand, int fortune) {
        if (meta >= 16) {
            return Item.func_150898_a((Block)Blocks.field_150330_I);
        }
        if (dropself[meta]) {
            return Item.func_150898_a((Block)this);
        }
        return GameRegistry.findItem((String)"derpyshiz", (String)"ore_item");
    }

    @Override
    public String getUnlocalizedName(int meta) {
        return this.func_149739_a() + "_" + names[meta % 16];
    }
}

