/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.client;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.wuerfel21.derpyshiz.client.DerpyRenderHelper;
import net.wuerfel21.derpyshiz.client.WholeTexture;
import net.wuerfel21.derpyshiz.rotary.AxisChain;
import org.lwjgl.opengl.GL11;

public class RotaryRender {
    public static final boolean[][] axisFaces = new boolean[][]{{false, false, true, true, true, true}, {false, false, true, true, true, true}, {true, true, false, false, true, true}, {true, true, false, false, true, true}, {true, true, true, true, false, false}, {true, true, true, true, false, false}};
    public static final boolean[][] axisEnds = new boolean[][]{{true, false, true, true, true, true}, {false, true, true, true, true, true}, {true, true, true, false, true, true}, {true, true, false, true, true, true}, {true, true, true, true, true, false}, {true, true, true, true, false, true}};
    public static final double maxAxisWidth = 0.375;
    public static final double minAxisWidth = 0.625;
    public static final double wp2 = 0.125;
    public static final double minAxisLength = 0.0;
    public static final double minC = 0.25;
    public static final double maxC = 0.75;
    public static final ResourceLocation axisTexture = new ResourceLocation("minecraft:textures/blocks/planks_oak.png");
    public static final WholeTexture axisIIcon = new WholeTexture(axisTexture);

    public static void rotateAxis(double position, int dir) {
        switch (dir) {
            default: {
                GL11.glRotated((double)position, (double)0.0, (double)-1.0, (double)0.0);
                break;
            }
            case 1: {
                GL11.glRotated((double)position, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 2: {
                GL11.glRotated((double)position, (double)0.0, (double)0.0, (double)-1.0);
                break;
            }
            case 3: {
                GL11.glRotated((double)position, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case 4: {
                GL11.glRotated((double)position, (double)-1.0, (double)0.0, (double)0.0);
                break;
            }
            case 5: {
                GL11.glRotated((double)position, (double)1.0, (double)0.0, (double)0.0);
            }
        }
    }

    public static void renderAxisChain(Tessellator tessellator, AxisChain chain) {
        if (chain.length <= 0) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.5, (double)0.5, (double)0.5);
        RotaryRender.rotateAxis(chain.position, chain.dir);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        tessellator.func_78382_b();
        boolean x = false;
        boolean y = false;
        boolean z = false;
        ForgeDirection fdir = ForgeDirection.getOrientation((int)chain.dir);
        switch (chain.dir) {
            default: {
                DerpyRenderHelper.addBox(tessellator, axisIIcon, 0.625, 0.0 + (double)(-chain.length), 0.625, 0.375, 0.0, 0.375, axisEnds[0]);
                break;
            }
            case 1: {
                DerpyRenderHelper.addBox(tessellator, axisIIcon, 0.625, 1.0, 0.625, 0.375, 1 + chain.length, 0.375, axisEnds[1]);
                break;
            }
            case 2: {
                DerpyRenderHelper.addBox(tessellator, axisIIcon, 0.625, 0.625, 0.0 + (double)(-chain.length), 0.375, 0.375, 0.0, axisEnds[2]);
                break;
            }
            case 3: {
                DerpyRenderHelper.addBox(tessellator, axisIIcon, 0.625, 0.625, 1.0, 0.375, 0.375, 1 + chain.length, axisEnds[3]);
                break;
            }
            case 4: {
                DerpyRenderHelper.addBox(tessellator, axisIIcon, 0.0 + (double)(-chain.length), 0.625, 0.625, 0.0, 0.375, 0.375, axisEnds[4]);
                break;
            }
            case 5: {
                DerpyRenderHelper.addBox(tessellator, axisIIcon, 1.0, 0.625, 0.625, 1 + chain.length, 0.375, 0.375, axisEnds[5]);
            }
        }
        tessellator.func_78381_a();
        GL11.glPopMatrix();
    }

    public static void fancyConnection(Tessellator tessellator, IIcon texture, IIcon overlay, int dir) {
        switch (dir) {
            default: {
                DerpyRenderHelper.addBox(tessellator, texture, 0.25, 0.005, 0.25, 0.75, 0.125, 0.75, axisEnds[0]);
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                tessellator.func_78374_a(0.75, 0.0, 0.25, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.75, 0.0, 0.75, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.25, 0.0, 0.75, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.25, 0.0, 0.25, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
                break;
            }
            case 1: {
                DerpyRenderHelper.addBox(tessellator, texture, 0.25, 0.875, 0.25, 0.75, 0.995, 0.75, axisEnds[1]);
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                tessellator.func_78374_a(0.75, 1.0, 0.25, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.25, 1.0, 0.25, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.25, 1.0, 0.75, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.75, 1.0, 0.75, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                break;
            }
            case 2: {
                DerpyRenderHelper.addBox(tessellator, texture, 0.25, 0.25, 0.005, 0.75, 0.75, 0.125, axisEnds[2]);
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                tessellator.func_78374_a(0.75, 0.25, 0.0, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.25, 0.25, 0.0, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.25, 0.75, 0.0, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.75, 0.75, 0.0, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
                break;
            }
            case 3: {
                DerpyRenderHelper.addBox(tessellator, texture, 0.25, 0.25, 0.875, 0.75, 0.75, 0.995, axisEnds[3]);
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                tessellator.func_78374_a(0.75, 0.25, 1.0, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.75, 0.75, 1.0, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.25, 0.75, 1.0, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.25, 0.25, 1.0, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                break;
            }
            case 4: {
                DerpyRenderHelper.addBox(tessellator, texture, 0.005, 0.25, 0.25, 0.125, 0.75, 0.75, axisEnds[4]);
                tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                tessellator.func_78374_a(0.0, 0.25, 0.75, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.0, 0.75, 0.75, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.0, 0.75, 0.25, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.0, 0.25, 0.25, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                break;
            }
            case 5: {
                DerpyRenderHelper.addBox(tessellator, texture, 0.875, 0.25, 0.25, 0.995, 0.75, 0.75, axisEnds[5]);
                tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                tessellator.func_78374_a(1.0, 0.25, 0.75, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(1.0, 0.25, 0.25, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(1.0, 0.75, 0.25, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(1.0, 0.75, 0.75, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
            }
        }
    }

    public static void uglyConnection(Tessellator tessellator, IIcon overlay, int dir) {
        switch (dir) {
            default: {
                tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
                tessellator.func_78374_a(0.75, -0.005, 0.25, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.75, -0.005, 0.75, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.25, -0.005, 0.75, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.25, -0.005, 0.25, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
                break;
            }
            case 1: {
                tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
                tessellator.func_78374_a(0.75, 1.005, 0.25, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.25, 1.005, 0.25, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.25, 1.005, 0.75, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.75, 1.005, 0.75, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                break;
            }
            case 2: {
                tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
                tessellator.func_78374_a(0.75, 0.25, -0.005, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.25, 0.25, -0.005, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.25, 0.75, -0.005, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.75, 0.75, -0.005, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
                break;
            }
            case 3: {
                tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
                tessellator.func_78374_a(0.75, 0.25, 1.005, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(0.75, 0.75, 1.005, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.25, 0.75, 1.005, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(0.25, 0.25, 1.005, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                break;
            }
            case 4: {
                tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
                tessellator.func_78374_a(-0.005, 0.25, 0.75, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(-0.005, 0.75, 0.75, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(-0.005, 0.75, 0.25, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(-0.005, 0.25, 0.25, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                break;
            }
            case 5: {
                tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
                tessellator.func_78374_a(1.005, 0.25, 0.75, (double)overlay.func_94209_e(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(1.005, 0.25, 0.25, (double)overlay.func_94212_f(), (double)overlay.func_94210_h());
                tessellator.func_78374_a(1.005, 0.75, 0.25, (double)overlay.func_94212_f(), (double)overlay.func_94206_g());
                tessellator.func_78374_a(1.005, 0.75, 0.75, (double)overlay.func_94209_e(), (double)overlay.func_94206_g());
            }
        }
    }
}

