/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.entity.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.wuerfel21.derpyshiz.Main;
import net.wuerfel21.derpyshiz.rotary.AxisChain;
import net.wuerfel21.derpyshiz.rotary.IRotaryInput;
import net.wuerfel21.derpyshiz.rotary.IRotaryOutput;
import net.wuerfel21.derpyshiz.rotary.ITieredTE;
import net.wuerfel21.derpyshiz.rotary.RotaryManager;

public abstract class AbstractGearbox
extends TileEntity
implements IRotaryInput,
IRotaryOutput,
ITieredTE {
    public boolean ready = false;
    public int dir = 0;
    public int output = 0;
    public int[] input = new int[6];
    public int[] length = new int[6];
    public int tier = 0;
    public int sync_offset;
    public AxisChain chain = new AxisChain(0, 5000000);
    public boolean inInventory;
    public static final int[] maxChainLength = new int[]{16, 32};
    public static final int[] breakSpeed = new int[]{100, 1000};

    public AbstractGearbox() {
        for (int i = 0; i < this.input.length; ++i) {
            this.input[i] = 0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        switch (this.chain.dir) {
            default: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - this.chain.length), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            }
            case 1: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1 + this.chain.length), (double)(this.field_145849_e + 1));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)(this.field_145849_e - this.chain.length), (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1 + this.chain.length));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.chain.length), (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            }
            case 5: 
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1 + this.chain.length), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public void rotate(int newDir) {
        this.dir = newDir;
        if (this.chain != null) {
            this.chain.cleanup(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.chain = new AxisChain(this.dir, maxChainLength[this.tier]);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.dir = tag.func_74762_e("direction");
        NBTTagCompound rotary = tag.func_74775_l("rotary");
        RotaryManager.inputFromNBT(this, rotary);
        RotaryManager.outputFromNBT(this, rotary);
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("direction", this.dir);
        NBTTagCompound rotary = new NBTTagCompound();
        rotary.func_74782_a("input", (NBTBase)RotaryManager.inputToNBT(this));
        rotary.func_74782_a("output", (NBTBase)RotaryManager.outputToNBT(this));
        tag.func_74782_a("rotary", (NBTBase)rotary);
    }

    public double func_145833_n() {
        return Math.pow(Main.gearboxBaseDistance + (double)this.chain.length, 2.0);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkg) {
        NBTTagCompound tag = pkg.func_148857_g();
        this.dir = tag.func_74762_e("direction");
        this.chain.fromNetworkNBT(tag.func_74775_l("axis"));
    }

    public Packet func_145844_m() {
        if (!this.ready) {
            this.setTier(this.func_145831_w().func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.rotate(this.dir);
            this.ready = true;
            this.sync_offset = this.field_145850_b.field_73012_v.nextInt(200);
            this.func_70296_d();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("direction", this.dir);
        tag.func_74782_a("axis", (NBTBase)this.chain.toNetworkNBT());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    @Override
    public boolean isOutputFace(int side) {
        return side == this.dir;
    }

    @Override
    public boolean isInputFace(int side) {
        return side != this.dir;
    }

    @Override
    public int getRotaryOutput(int side) {
        if (this.isOutputFace(side)) {
            return this.output;
        }
        return 0;
    }

    @Override
    public void setRotaryOutput(int side, int speed) {
        if (this.isOutputFace(side)) {
            this.output = speed;
        }
    }

    @Override
    public void setRotaryInput(int side, int speed, int length) {
        if (this.isInputFace(side)) {
            this.input[side] = speed;
            this.length[side] = length;
        }
    }

    @Override
    public int getRotaryInput(int side) {
        if (this.isInputFace(side)) {
            return this.input[side];
        }
        return 0;
    }

    public void cleanup() {
        if (this.chain != null) {
            this.chain.cleanup(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }

    @Override
    public int getRotaryInputLength(int side) {
        if (this.isInputFace(side)) {
            return this.length[side];
        }
        return 0;
    }
}

