/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.entity.tile;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.wuerfel21.derpyshiz.DerpyRegistry;
import net.wuerfel21.derpyshiz.IExperienceMachine;
import net.wuerfel21.derpyshiz.blocks.BlockCentrifuge;
import net.wuerfel21.derpyshiz.rotary.AxisChain;
import net.wuerfel21.derpyshiz.rotary.IRotaryInput;
import net.wuerfel21.derpyshiz.rotary.ITieredTE;
import net.wuerfel21.derpyshiz.rotary.RotaryManager;

public class TileEntityCentrifuge
extends TileEntity
implements ISidedInventory,
ITieredTE,
IRotaryInput,
IExperienceMachine {
    public ItemStack[] stacks = new ItemStack[4];
    public String name = null;
    public int tier = 0;
    public boolean inInventory = false;
    public int progress = 0;
    public int energyNeeded = 0;
    public int inputSpeed;
    public int[] input = new int[2];
    public int[] length = new int[2];
    public int[] access = new int[]{0, 1, 2, 3};
    public float lastXP;
    public AxisChain pseudoChain;
    public int[] breakSpeed = new int[]{75, 750};

    public TileEntityCentrifuge() {
        this.pseudoChain = new AxisChain(0, 0);
    }

    public void func_145845_h() {
        if (this.field_145850_b != null) {
            this.setTier(this.func_145831_w().func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            if (!this.field_145850_b.field_72995_K) {
                this.inputSpeed = Math.abs(this.input[RotaryManager.getMaxInput(this)]);
                RotaryManager.updateRotaryInput(this, this, 0);
                RotaryManager.updateRotaryInput(this, this, 1);
                if (this.inputSpeed > this.breakSpeed[this.getTier()]) {
                    this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, true);
                    return;
                }
                this.pseudoChain.lastSpeed = this.pseudoChain.speed;
                if (this.stacks[0] != null && DerpyRegistry.isValidForMachine(DerpyRegistry.centrifugeRecipes, this.stacks[0], this.tier)) {
                    this.func_70296_d();
                    DerpyRegistry.CentrifugeEntry output = (DerpyRegistry.CentrifugeEntry)DerpyRegistry.getOutput(DerpyRegistry.centrifugeRecipes, this.stacks[0], this.getTier());
                    if (this.canOperate()) {
                        this.energyNeeded = output.energy;
                        this.progress += this.inputSpeed;
                        this.pseudoChain.speed = this.inputSpeed;
                        if (this.progress >= this.energyNeeded) {
                            this.stacks[0].field_77994_a -= DerpyRegistry.getKey(DerpyRegistry.centrifugeRecipes, (ItemStack)this.stacks[0]).field_77994_a;
                            if (this.stacks[0].field_77994_a < 1) {
                                this.stacks[0] = null;
                            }
                            if (this.stacks[1] == null) {
                                this.stacks[1] = output.output.func_77946_l();
                            } else {
                                this.stacks[1].field_77994_a += output.output.field_77994_a;
                            }
                            if (this.stacks[2] == null) {
                                this.stacks[2] = output.output2.func_77946_l();
                            } else {
                                this.stacks[2].field_77994_a += output.output2.field_77994_a;
                            }
                            if (this.stacks[3] == null) {
                                this.stacks[3] = output.output3.func_77946_l();
                            } else {
                                this.stacks[3].field_77994_a += output.output3.field_77994_a;
                            }
                            this.progress -= this.energyNeeded;
                            this.lastXP = output.exp;
                        }
                    } else {
                        this.progress = 0;
                        this.energyNeeded = 0;
                        this.pseudoChain.speed = 0;
                    }
                } else {
                    this.progress = 0;
                    this.energyNeeded = 0;
                    this.pseudoChain.speed = 0;
                }
                if (this.pseudoChain.speed != this.pseudoChain.lastSpeed) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            this.pseudoChain.updateVisualPosition();
        }
    }

    public boolean canOperate() {
        if (DerpyRegistry.isValidForMachine(DerpyRegistry.centrifugeRecipes, this.stacks[0], this.getTier())) {
            DerpyRegistry.CentrifugeEntry output = (DerpyRegistry.CentrifugeEntry)DerpyRegistry.getOutput(DerpyRegistry.centrifugeRecipes, this.stacks[0], this.getTier());
            ItemStack key = DerpyRegistry.getKey(DerpyRegistry.centrifugeRecipes, this.stacks[0]);
            if (!(this.stacks[1] != null && !OreDictionary.itemMatches((ItemStack)output.output, (ItemStack)this.stacks[1], (boolean)true) || this.stacks[2] != null && !OreDictionary.itemMatches((ItemStack)output.output2, (ItemStack)this.stacks[2], (boolean)true) || this.stacks[3] != null && !OreDictionary.itemMatches((ItemStack)output.output3, (ItemStack)this.stacks[3], (boolean)true) || this.stacks[0].field_77994_a < key.field_77994_a || this.stacks[1] != null && this.stacks[1].field_77994_a + output.output.field_77994_a > this.stacks[1].func_77976_d() || this.stacks[2] != null && this.stacks[2].field_77994_a + output.output2.field_77994_a > this.stacks[2].func_77976_d() || this.stacks[3] != null && this.stacks[3].field_77994_a + output.output3.field_77994_a > this.stacks[3].func_77976_d())) {
                return true;
            }
        }
        return false;
    }

    public int func_70302_i_() {
        return 4;
    }

    public ItemStack func_70301_a(int slot) {
        return slot < this.func_70302_i_() ? this.stacks[slot] : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.stacks[slot] != null) {
            if (this.stacks[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.stacks[slot];
                this.stacks[slot] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.stacks[slot].func_77979_a(amount);
            if (this.stacks[slot].field_77994_a == 0) {
                this.stacks[slot] = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        this.func_70296_d();
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagCompound inventory = new NBTTagCompound();
        if (this.stacks[0] != null) {
            inventory.func_74782_a("input", (NBTBase)this.stacks[0].func_77955_b(new NBTTagCompound()));
        } else {
            inventory.func_82580_o("input");
        }
        if (this.stacks[1] != null) {
            inventory.func_74782_a("output", (NBTBase)this.stacks[1].func_77955_b(new NBTTagCompound()));
        } else {
            inventory.func_82580_o("output");
        }
        if (this.stacks[2] != null) {
            inventory.func_74782_a("output2", (NBTBase)this.stacks[2].func_77955_b(new NBTTagCompound()));
        } else {
            inventory.func_82580_o("output2");
        }
        if (this.stacks[3] != null) {
            inventory.func_74782_a("output3", (NBTBase)this.stacks[3].func_77955_b(new NBTTagCompound()));
        } else {
            inventory.func_82580_o("output3");
        }
        tag.func_74782_a("inventory", (NBTBase)inventory);
        NBTTagCompound rotary = new NBTTagCompound();
        rotary.func_74782_a("input", (NBTBase)RotaryManager.inputToNBT(this));
        tag.func_74782_a("rotary", (NBTBase)rotary);
        tag.func_74768_a("progress", this.progress);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.name);
        }
        tag.func_74776_a("lastXP", this.lastXP);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound inventory = tag.func_74775_l("inventory");
        if (inventory.func_74764_b("input")) {
            this.stacks[0] = ItemStack.func_77949_a((NBTTagCompound)inventory.func_74775_l("input"));
        }
        if (inventory.func_74764_b("output")) {
            this.stacks[1] = ItemStack.func_77949_a((NBTTagCompound)inventory.func_74775_l("output"));
        }
        if (inventory.func_74764_b("output2")) {
            this.stacks[2] = ItemStack.func_77949_a((NBTTagCompound)inventory.func_74775_l("output2"));
        }
        if (inventory.func_74764_b("output3")) {
            this.stacks[3] = ItemStack.func_77949_a((NBTTagCompound)inventory.func_74775_l("output3"));
        }
        NBTTagCompound rotary = tag.func_74775_l("rotary");
        RotaryManager.inputFromNBT(this, rotary);
        this.progress = tag.func_74762_e("progress");
        if (tag.func_74764_b("CustomName")) {
            this.name = tag.func_74779_i("CustomName");
        }
        this.lastXP = tag.func_74760_g("lastXP");
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot < this.func_70302_i_()) {
            this.func_70296_d();
            this.stacks[slot] = stack;
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkg) {
        NBTTagCompound tag = pkg.func_148857_g();
        this.name = tag.func_74779_i("CustomName");
        this.pseudoChain.fromNetworkNBT(tag.func_74775_l("chain"));
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.name);
        }
        tag.func_74782_a("chain", (NBTBase)this.pseudoChain.toNetworkNBT());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.name : StatCollector.func_74838_a((String)"container.derpyshiz.centrifuge.name");
    }

    public boolean func_145818_k_() {
        return this.name != null && this.name.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : p_70300_1_.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot == 0;
    }

    public int[] func_94128_d(int side) {
        return this.access;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot != 0;
    }

    public void dropInv(World world, int x, int y, int z) {
        Block block = this.func_145838_q();
        if (!(block instanceof BlockCentrifuge)) {
            return;
        }
        for (ItemStack stack : this.stacks) {
            if (stack == null) continue;
            ((BlockCentrifuge)block).func_149642_a(world, x, y, z, stack);
        }
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }

    @Override
    public boolean isInputFace(int side) {
        return side <= 1;
    }

    @Override
    public void setRotaryInput(int side, int speed, int length) {
        if (this.isInputFace(side)) {
            this.input[side] = speed;
            this.length[side] = length;
        }
    }

    @Override
    public int getRotaryInput(int side) {
        if (this.isInputFace(side)) {
            return this.input[side];
        }
        return 0;
    }

    @Override
    public int getRotaryInputLength(int side) {
        if (this.isInputFace(side)) {
            return this.length[side];
        }
        return 0;
    }

    public int getProgressScaled(int scale) {
        if (this.energyNeeded != 0) {
            return this.progress * scale / this.energyNeeded;
        }
        return 0;
    }

    public int getSpeedScaled(int scale) {
        if (this.inputSpeed != 0) {
            return this.inputSpeed * scale / this.breakSpeed[this.getTier()];
        }
        return 0;
    }

    @Override
    public float getLastOperationXP() {
        return this.lastXP;
    }
}

