/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.entity.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.wuerfel21.derpyshiz.Main;
import net.wuerfel21.derpyshiz.blocks.BlockMillstone;
import net.wuerfel21.derpyshiz.entity.tile.TileEntityGearbox;
import net.wuerfel21.derpyshiz.rotary.AxisChain;
import net.wuerfel21.derpyshiz.rotary.IRotaryOutput;
import net.wuerfel21.derpyshiz.rotary.RotaryManager;

public class TileEntityCompactEngine
extends TileEntity
implements IRotaryOutput,
IInventory {
    public boolean ready = false;
    public int dir = 0;
    public int output = 0;
    public int ticksLeft;
    public int ticksForUsedFuel;
    public ItemStack fuel;
    public String name;
    public int sync_offset;
    public AxisChain chain = new AxisChain(0, 5000000);
    public boolean inInventory;

    public void func_145845_h() {
        if (this.func_145831_w() != null) {
            if (this.ticksLeft > 0) {
                --this.ticksLeft;
            }
            if (!this.func_145831_w().field_72995_K) {
                if (!this.ready) {
                    this.rotate(this.dir);
                    this.ready = true;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.sync_offset = this.field_145850_b.field_73012_v.nextInt(200);
                    this.func_70296_d();
                }
                if (this.dir != this.chain.dir) {
                    this.rotate(this.dir);
                }
                if (this.ticksLeft > 0) {
                    this.setRotaryOutput(this.dir, 10);
                } else {
                    this.setRotaryOutput(this.dir, 0);
                }
                if (this.ticksLeft <= 0 && TileEntityFurnace.func_145954_b((ItemStack)this.fuel) && this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 0) {
                    this.ticksLeft = this.ticksForUsedFuel = TileEntityFurnace.func_145952_a((ItemStack)this.fuel);
                    --this.fuel.field_77994_a;
                    this.setRotaryOutput(this.dir, 10);
                    if (this.fuel.field_77994_a <= 0) {
                        this.fuel = this.fuel.func_77973_b().getContainerItem(this.fuel);
                    }
                }
                RotaryManager.updateRotaryOutput(this, this.chain, this, this.dir);
                if (this.field_145850_b.func_82737_E() % 200L == (long)this.sync_offset) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.chain.updateChainBlocksToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            this.chain.updateVisualPosition();
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("fuel")) {
            this.fuel = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("fuel"));
        }
        this.dir = tag.func_74762_e("direction");
        this.ticksLeft = tag.func_74762_e("ticksLeft");
        this.ticksForUsedFuel = tag.func_74762_e("ticksForUsedFuel");
        NBTTagCompound rotary = tag.func_74775_l("rotary");
        RotaryManager.outputFromNBT(this, rotary);
        if (tag.func_74764_b("CustomName")) {
            this.name = tag.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        if (this.fuel != null) {
            tag.func_74782_a("fuel", (NBTBase)this.fuel.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74768_a("direction", this.dir);
        tag.func_74768_a("ticksLeft", this.ticksLeft);
        tag.func_74768_a("ticksForUsedFuel", this.ticksForUsedFuel);
        NBTTagCompound rotary = new NBTTagCompound();
        rotary.func_74782_a("output", (NBTBase)RotaryManager.outputToNBT(this));
        tag.func_74782_a("rotary", (NBTBase)rotary);
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.name);
        }
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkg) {
        NBTTagCompound tag = pkg.func_148857_g();
        this.dir = tag.func_74762_e("direction");
        this.chain.fromNetworkNBT(tag.func_74775_l("axis"));
        this.name = tag.func_74779_i("CustomName");
    }

    public Packet func_145844_m() {
        if (!this.ready) {
            this.rotate(this.dir);
            this.ready = true;
            this.sync_offset = this.field_145850_b.field_73012_v.nextInt(200);
            this.func_70296_d();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("direction", this.dir);
        tag.func_74782_a("axis", (NBTBase)this.chain.toNetworkNBT());
        if (this.func_145818_k_()) {
            tag.func_74778_a("CustomName", this.name);
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    public double func_145833_n() {
        return Math.pow(Main.gearboxBaseDistance + (double)this.chain.length, 2.0);
    }

    @Override
    public boolean isOutputFace(int side) {
        return this.dir == side;
    }

    @Override
    public int getRotaryOutput(int side) {
        if (this.isOutputFace(side)) {
            return this.output;
        }
        return 0;
    }

    @Override
    public void setRotaryOutput(int side, int speed) {
        if (this.isOutputFace(side)) {
            this.output = speed;
        }
    }

    public void rotate(int newDir) {
        this.dir = newDir;
        if (this.chain != null) {
            this.chain.cleanup(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.chain = new AxisChain(this.dir, TileEntityGearbox.maxChainLength[1]);
    }

    public void cleanup() {
        if (this.chain != null) {
            this.chain.cleanup(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slot) {
        return slot == 0 ? this.fuel : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.fuel != null) {
            if (this.fuel.field_77994_a <= amount) {
                ItemStack itemstack = this.fuel;
                this.fuel = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.fuel.func_77979_a(amount);
            if (this.fuel.field_77994_a == 0) {
                this.fuel = null;
            }
            this.func_70296_d();
            return itemstack;
        }
        this.func_70296_d();
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot == 0) {
            this.fuel = stack;
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.name : StatCollector.func_74838_a((String)"container.derpyshiz.compact_engine.name");
    }

    public boolean func_145818_k_() {
        return this.name != null && this.name.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : p_70300_1_.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public void dropInv(World world, int x, int y, int z) {
        Block block = this.func_145838_q();
        if (!(block instanceof BlockMillstone)) {
            return;
        }
        if (this.fuel != null) {
            ((BlockMillstone)block).func_149642_a(world, x, y, z, this.fuel);
        }
    }

    public int getTicksLeftScaled(int scale) {
        if (this.ticksLeft != 0 && this.ticksForUsedFuel != 0) {
            return this.ticksLeft * scale / this.ticksForUsedFuel;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        switch (this.chain.dir) {
            default: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - this.chain.length), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            }
            case 1: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1 + this.chain.length), (double)(this.field_145849_e + 1));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)(this.field_145849_e - this.chain.length), (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1 + this.chain.length));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.chain.length), (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            }
            case 5: 
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1 + this.chain.length), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }
}

