/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.entity.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.wuerfel21.derpyshiz.Main;
import net.wuerfel21.derpyshiz.entity.tile.TileEntityGearbox;
import net.wuerfel21.derpyshiz.rotary.AxisChain;
import net.wuerfel21.derpyshiz.rotary.IRotaryOutput;
import net.wuerfel21.derpyshiz.rotary.ITieredTE;
import net.wuerfel21.derpyshiz.rotary.RotaryManager;

public class TileEntityCrank
extends TileEntity
implements IRotaryOutput,
ITieredTE {
    public boolean ready = false;
    public int dir = 0;
    public int output = 0;
    public int tier = 0;
    public int cooldown = 0;
    public int sync_offset;
    public AxisChain chain = new AxisChain(0, 5000000);
    public boolean inInventory;
    public static final int[] speeds = new int[]{30, 40};
    public static final int[] cooldowns = new int[]{40, 30};

    public void func_145845_h() {
        if (this.func_145831_w() != null) {
            this.setTier(this.func_145831_w().func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            if (!this.func_145831_w().field_72995_K) {
                if (!this.ready) {
                    this.rotate(this.dir);
                    this.ready = true;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.sync_offset = this.field_145850_b.field_73012_v.nextInt(200);
                    this.func_70296_d();
                }
                if (this.dir != this.chain.dir) {
                    this.rotate(this.dir);
                }
                if (this.cooldown > 0) {
                    --this.cooldown;
                    this.setRotaryOutput(this.dir, speeds[this.getTier()]);
                    this.func_70296_d();
                } else {
                    this.setRotaryOutput(this.dir, 0);
                }
                RotaryManager.updateRotaryOutput(this, this.chain, this, this.dir);
                if (this.field_145850_b.func_82737_E() % 200L == (long)this.sync_offset) {
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.chain.updateChainBlocksToClients(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            this.chain.updateVisualPosition();
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.dir = tag.func_74762_e("direction");
        NBTTagCompound rotary = tag.func_74775_l("rotary");
        RotaryManager.outputFromNBT(this, rotary);
        this.cooldown = tag.func_74762_e("cooldown");
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("direction", this.dir);
        NBTTagCompound rotary = new NBTTagCompound();
        rotary.func_74782_a("output", (NBTBase)RotaryManager.outputToNBT(this));
        tag.func_74782_a("rotary", (NBTBase)rotary);
        tag.func_74768_a("cooldown", this.cooldown);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkg) {
        NBTTagCompound tag = pkg.func_148857_g();
        this.dir = tag.func_74762_e("direction");
        this.chain.fromNetworkNBT(tag.func_74775_l("axis"));
    }

    public Packet func_145844_m() {
        if (!this.ready) {
            this.setTier(this.func_145831_w().func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            this.rotate(this.dir);
            this.ready = true;
            this.sync_offset = this.field_145850_b.field_73012_v.nextInt(200);
            this.func_70296_d();
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("direction", this.dir);
        tag.func_74782_a("axis", (NBTBase)this.chain.toNetworkNBT());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    @Override
    public boolean isOutputFace(int side) {
        return side == this.dir;
    }

    @Override
    public int getRotaryOutput(int side) {
        if (this.isOutputFace(side)) {
            return this.output;
        }
        return 0;
    }

    @Override
    public void setRotaryOutput(int side, int speed) {
        if (this.isOutputFace(side)) {
            this.output = speed;
        }
    }

    public void rotate(int newDir) {
        this.dir = newDir;
        if (this.chain != null) {
            this.chain.cleanup(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.chain = new AxisChain(this.dir, TileEntityGearbox.maxChainLength[this.getTier()]);
    }

    public void cleanup() {
        if (this.chain != null) {
            this.chain.cleanup(this.func_145831_w(), this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public double func_145833_n() {
        return Math.pow(Main.gearboxBaseDistance + (double)this.chain.length, 2.0);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        switch (this.chain.dir) {
            default: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)(this.field_145848_d - this.chain.length), (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            }
            case 1: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1 + this.chain.length), (double)(this.field_145849_e + 1));
            }
            case 2: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)(this.field_145849_e - this.chain.length), (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            }
            case 3: {
                return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1 + this.chain.length));
            }
            case 4: {
                return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - this.chain.length), (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
            }
            case 5: 
        }
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1 + this.chain.length), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    @Override
    public void setTier(int tier) {
        this.tier = tier;
    }
}

