/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.wuerfel21.derpyshiz.DerpyBlocks;
import net.wuerfel21.derpyshiz.DerpyItems;
import net.wuerfel21.derpyshiz.DerpyRegistry;
import net.wuerfel21.derpyshiz.IModeItem;
import net.wuerfel21.derpyshiz.ISpecialActionItem;
import net.wuerfel21.derpyshiz.ItemModeHelper;
import net.wuerfel21.derpyshiz.items.DerpySword;

public class NaturalSword
extends DerpySword
implements IModeItem,
ISpecialActionItem {
    public static final int[] xOff = new int[]{0, -1, 0, 1};
    public static final int[] zOff = new int[]{1, 0, -1, 0};
    public static final int[] revDir = new int[]{2, 3, 0, 1};
    public static final String[] modes = new String[]{"mode.derpyshiz.naturalsword_front.name", "mode.derpyshiz.naturalsword_back.name", "mode.derpyshiz.naturalsword_all.name"};

    public NaturalSword(Item.ToolMaterial material, Item rep, int m) {
        super(material, rep, m);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (entity instanceof EntityAnimal || entity instanceof EntitySquid) {
            return true;
        }
        if (entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect(2, 180));
        }
        return false;
    }

    @Override
    public void specialAction(ItemStack stack, EntityPlayer player, boolean isClient) {
        if (isClient || !player.field_70122_E || player.func_70090_H() || player.func_70617_f_()) {
            return;
        }
        int blocksGenerated = 0;
        boolean blocking = player.func_70632_aY();
        int blockX = (int)Math.floor(player.field_70165_t);
        int blockY = (int)Math.floor(player.field_70163_u);
        int blockZ = (int)Math.floor(player.field_70161_v);
        int playerDir = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        DerpyRegistry.BasicBlockEntry leafType = DerpyRegistry.leafTypes.get(player.func_70681_au().nextInt(DerpyRegistry.leafTypes.size()));
        int unnaturalBlocks = 0;
        int totalBlocks = 0;
        for (int i = blockX - 10; i < blockX + 10; ++i) {
            for (int j = blockZ - 10; j < blockZ + 10; ++j) {
                for (int k = blockY - 5; k < blockY + 5; ++k) {
                    if (player.field_70170_p.func_147437_c(i, k, j)) continue;
                    Block block = player.field_70170_p.func_147439_a(i, k, j);
                    Material m = block.func_149688_o();
                    if (m != Material.field_151570_A && m != Material.field_151577_b && m != Material.field_151578_c && m != Material.field_151584_j && m != Material.field_151569_G && m != Material.field_151575_d && m != Material.field_151585_k) {
                        ++unnaturalBlocks;
                    }
                    ++totalBlocks;
                }
            }
        }
        switch (ItemModeHelper.getMode(stack)) {
            default: {
                blocksGenerated += NaturalSword.genLeafWall(player.field_70170_p, blockX, blockY, blockZ, leafType, playerDir, 2);
                if (!blocking) break;
                blocksGenerated += NaturalSword.genLeafWall(player.field_70170_p, blockX + xOff[playerDir], blockY + 1, blockZ + zOff[playerDir], leafType, playerDir, 1);
                break;
            }
            case 1: {
                blocksGenerated += NaturalSword.genLeafWall(player.field_70170_p, blockX, blockY, blockZ, leafType, revDir[playerDir], 2);
                if (!blocking) break;
                blocksGenerated += NaturalSword.genLeafWall(player.field_70170_p, blockX + xOff[revDir[playerDir]], blockY + 1, blockZ + zOff[revDir[playerDir]], leafType, revDir[playerDir], 1);
                break;
            }
            case 2: {
                for (int d = 0; d < 4; ++d) {
                    blocksGenerated += NaturalSword.genLeafWall(player.field_70170_p, blockX, blockY, blockZ, leafType, d, 2);
                }
                if (!blocking) break;
                blocksGenerated += NaturalSword.genLeafWall(player.field_70170_p, blockX, blockY + 2, blockZ, leafType, 4, 1);
            }
        }
        if (blocksGenerated < 1) {
            return;
        }
        if (totalBlocks == 0) {
            return;
        }
        double rawMulti = (double)unnaturalBlocks / (double)totalBlocks;
        double multi = rawMulti * 0.9 + 0.1;
        double damage = (double)blocksGenerated / 1.5 * multi;
        DerpyItems.damageItem(stack, (int)Math.ceil(damage), (EntityLivingBase)player);
        player.field_70170_p.func_72956_a((Entity)player, "dig.grass", 1.0f, player.func_70681_au().nextFloat() * 0.1f + 0.9f);
    }

    public static int genLeafWall(World world, int blockX, int blockY, int blockZ, DerpyRegistry.BasicBlockEntry block, int dir, int height) {
        int maxX;
        int maxZ;
        int blocksGenerated = 0;
        switch (dir) {
            default: {
                int minZ = blockZ + 2;
                maxZ = blockZ + 2;
                int minX = blockX - 2;
                maxX = blockX + 2;
                break;
            }
            case 1: {
                int minZ = blockZ - 2;
                maxZ = blockZ + 2;
                int minX = blockX - 2;
                maxX = blockX - 2;
                break;
            }
            case 2: {
                int minZ = blockZ - 2;
                maxZ = blockZ - 2;
                int minX = blockX - 2;
                maxX = blockX + 2;
                break;
            }
            case 3: {
                int minZ = blockZ - 2;
                maxZ = blockZ + 2;
                int minX = blockX + 2;
                maxX = blockX + 2;
                break;
            }
            case 4: {
                int minZ = blockZ - 2;
                maxZ = blockZ + 2;
                int minX = blockX - 2;
                maxX = blockX + 2;
            }
        }
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = blockY; y < blockY + height; ++y) {
                    if (!NaturalSword.genLeafBlock(world, x, y, z, block)) continue;
                    ++blocksGenerated;
                }
            }
        }
        return blocksGenerated;
    }

    public static boolean genLeafBlock(World world, int x, int y, int z, DerpyRegistry.BasicBlockEntry block) {
        if (world.func_72899_e(x, y, z) && (world.func_147437_c(x, y, z) || world.func_147439_a(x, y, z).isReplaceable((IBlockAccess)world, x, y, z))) {
            world.func_147465_d(x, y, z, block.block, block.meta | 8, 2);
            return true;
        }
        return false;
    }

    public static void registerLeafTypes() {
        List<DerpyRegistry.BasicBlockEntry> lt = DerpyRegistry.leafTypes;
        lt.add(new DerpyRegistry.BasicBlockEntry((Block)Blocks.field_150362_t, 0));
        lt.add(new DerpyRegistry.BasicBlockEntry((Block)Blocks.field_150362_t, 1));
        lt.add(new DerpyRegistry.BasicBlockEntry((Block)Blocks.field_150362_t, 2));
        lt.add(new DerpyRegistry.BasicBlockEntry((Block)Blocks.field_150362_t, 3));
        lt.add(new DerpyRegistry.BasicBlockEntry((Block)Blocks.field_150361_u, 0));
        lt.add(new DerpyRegistry.BasicBlockEntry((Block)Blocks.field_150361_u, 1));
        lt.add(new DerpyRegistry.BasicBlockEntry(DerpyBlocks.leaves, 0));
        lt.add(new DerpyRegistry.BasicBlockEntry(DerpyBlocks.leaves, 1));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer p_77624_2_, List list, boolean p_77624_4_) {
        ItemModeHelper.displayMode(stack, list);
    }

    @Override
    public int getNumModes() {
        return 3;
    }

    @Override
    public String getModeName(int index) {
        return modes[index];
    }
}

