/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Map;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.wuerfel21.derpyshiz.DerpyRegistry;
import net.wuerfel21.derpyshiz.gui.GuiMillstone;

public class NEIMillstone
extends TemplateRecipeHandler {
    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"container.derpyshiz.millstone.name");
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiMillstone.class;
    }

    public void drawExtras(int recipe) {
        MillstonePair arecipe = (MillstonePair)((Object)this.arecipes.get(recipe));
        this.drawProgressBar(74, 23, 176, 17, 24, 16, arecipe.output.energy / 150, 0);
        String desc = (arecipe.output.tier == 0 ? "Normal, " : "Advanced, ") + Integer.toString(arecipe.output.energy) + " " + StatCollector.func_74838_a((String)"text.derpyshiz.mccr.name");
        GuiDraw.drawStringC((String)desc, (int)88, (int)50, (int)0x404040, (boolean)false);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("ds_grinding")) {
            for (Map.Entry<ItemStack, DerpyRegistry.TieredMachineEntry> entry : DerpyRegistry.millstoneRecipes.entrySet()) {
                this.arecipes.add(new MillstonePair(entry.getKey(), entry.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ItemStack, DerpyRegistry.TieredMachineEntry> recipe : DerpyRegistry.millstoneRecipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getValue().output, (ItemStack)result)) continue;
            this.arecipes.add(new MillstonePair(recipe.getKey(), recipe.getValue()));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        for (Map.Entry<ItemStack, DerpyRegistry.TieredMachineEntry> recipe : DerpyRegistry.millstoneRecipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getKey(), (ItemStack)ingredient)) continue;
            MillstonePair arecipe = new MillstonePair(recipe.getKey(), recipe.getValue());
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.getIngredient()), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    public String getOverlayIdentifier() {
        return "ds_grinding";
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "ds_grinding", new Object[0]));
    }

    public String getGuiTexture() {
        return "derpyshiz:textures/gui/millstone.png";
    }

    public class MillstonePair
    extends TemplateRecipeHandler.CachedRecipe {
        public ItemStack input;
        public DerpyRegistry.TieredMachineEntry output;

        public MillstonePair(ItemStack input, DerpyRegistry.TieredMachineEntry output) {
            super((TemplateRecipeHandler)NEIMillstone.this);
            this.input = input;
            this.output = output;
        }

        public PositionedStack getResult() {
            return new PositionedStack((Object)this.output.output, 111, 24);
        }

        public PositionedStack getIngredient() {
            return new PositionedStack((Object)this.input, 51, 6);
        }
    }
}

