/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.rotary;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.wuerfel21.derpyshiz.Main;
import net.wuerfel21.derpyshiz.blocks.BlockAxis;
import net.wuerfel21.derpyshiz.rotary.IRotaryInput;
import net.wuerfel21.derpyshiz.rotary.IRotaryOutput;

public class AxisChain {
    public int dir;
    public int maxLength = 20;
    public int[] tilePos = new int[3];
    public boolean connected = false;
    public int length = 0;
    public int speed = 0;
    public double position;
    public int lastLength = 0;
    public int lastSpeed = 0;

    public AxisChain(int direction, int maxL) {
        this.dir = direction;
        this.maxLength = maxL;
    }

    public void updateVisualPosition() {
        this.position += (double)this.speed * 0.3;
        this.position %= 360.0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean updateChain(IRotaryOutput output, World world, int rotation, int x, int y, int z) {
        int l;
        block9: {
            Block block;
            this.lastLength = this.length;
            this.lastSpeed = this.speed;
            this.speed = rotation;
            ForgeDirection direction = ForgeDirection.getOrientation((int)this.dir);
            boolean usedFlag = false;
            l = 0;
            while ((block = world.func_147439_a(x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ)) instanceof BlockAxis) {
                if ((world.func_72805_g(x, y, z) & 7) == Main.orientationHelper[this.dir]) {
                    if (l > this.maxLength) {
                        world.func_147480_a(x, y, z, true);
                        this.connected = false;
                        break block9;
                    } else {
                        ++l;
                        if ((world.func_72805_g(x, y, z) & 8) != 0) continue;
                        world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) | 8, 2);
                        continue;
                    }
                }
                this.connected = false;
                break block9;
            }
            if (world.func_147438_o(x, y, z) instanceof IRotaryOutput && ((IRotaryOutput)world.func_147438_o(x, y, z)).isOutputFace(Main.reverseHelper[this.dir])) {
                world.func_147480_a(x, y, z, true);
                this.connected = false;
            } else if (world.func_147438_o(x, y, z) instanceof IRotaryInput && ((IRotaryInput)world.func_147438_o(x, y, z)).isInputFace(Main.reverseHelper[this.dir])) {
                ((IRotaryInput)world.func_147438_o(x, y, z)).setRotaryInput(Main.reverseHelper[this.dir], rotation, l);
                this.tilePos[0] = x;
                this.tilePos[1] = y;
                this.tilePos[2] = z;
                this.connected = true;
            } else {
                this.connected = false;
            }
        }
        if (this.length > l) {
            this.cleanup(world, x, y, z);
        }
        this.length = l;
        if (this.lastSpeed != this.speed) return true;
        if (this.lastLength != this.length) return true;
        return false;
    }

    public void cleanup(World world, int x, int y, int z) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)this.dir);
        for (int i = 0; i < this.length; ++i) {
            Block block = world.func_147439_a(x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ);
            if (!(block instanceof BlockAxis)) continue;
            world.func_72921_c(x, y, z, world.func_72805_g(x, y, z) & 7, 2);
        }
        TileEntity t = world.func_147438_o(this.tilePos[0], this.tilePos[1], this.tilePos[2]);
        if (t != null && t instanceof IRotaryInput) {
            ((IRotaryInput)t).setRotaryInput(Main.reverseHelper[this.dir], 0, 0);
        }
    }

    public void updateChainBlocksToClients(World world, int x, int y, int z) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)this.dir);
        for (int i = 0; i < this.length; ++i) {
            if (!(world.func_147439_a(x += direction.offsetX, y += direction.offsetY, z += direction.offsetZ) instanceof BlockAxis) || (world.func_72805_g(x, y, z) & 8) == 0) continue;
            world.func_147471_g(x, y, z);
        }
    }

    public NBTTagCompound toNetworkNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("speed", this.speed);
        tag.func_74768_a("length", this.length);
        tag.func_74768_a("dir", this.dir);
        tag.func_74780_a("visual_position", this.position);
        return tag;
    }

    public void fromNetworkNBT(NBTTagCompound tag) {
        this.speed = tag.func_74762_e("speed");
        this.length = tag.func_74762_e("length");
        this.dir = tag.func_74762_e("dir");
        this.position = tag.func_74769_h("visual_position");
    }
}

