/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.rotary;

import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.wuerfel21.derpyshiz.blocks.BlockAxis;
import net.wuerfel21.derpyshiz.rotary.AxisChain;
import net.wuerfel21.derpyshiz.rotary.IRotaryInput;
import net.wuerfel21.derpyshiz.rotary.IRotaryOutput;

public abstract class RotaryManager {
    public static void updateRotaryOutput(IRotaryOutput output, AxisChain chain, TileEntity tile, int dir) {
        if (chain.updateChain(output, tile.func_145831_w(), output.getRotaryOutput(dir), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e)) {
            tile.func_145831_w().func_147471_g(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        }
    }

    public static void updateRotaryInput(IRotaryInput input, TileEntity tile, int dir) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)dir);
        Block block = tile.func_145831_w().func_147439_a(tile.field_145851_c + direction.offsetX, tile.field_145848_d + direction.offsetY, tile.field_145849_e + direction.offsetZ);
        TileEntity te = tile.func_145831_w().func_147438_o(tile.field_145851_c + direction.offsetX, tile.field_145848_d + direction.offsetY, tile.field_145849_e + direction.offsetZ);
        if (input.getRotaryInput(dir) != 0 && !(block instanceof BlockAxis) && !(te instanceof IRotaryOutput)) {
            input.setRotaryInput(dir, 0, 0);
        }
    }

    public static NBTTagCompound inputToNBT(IRotaryInput input) {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < 6; ++i) {
            tag.func_74768_a("input" + Integer.toString(i), input.getRotaryInput(i));
            tag.func_74768_a("length" + Integer.toString(i), input.getRotaryInputLength(i));
        }
        return tag;
    }

    public static void inputFromNBT(IRotaryInput input, NBTTagCompound tag) {
        for (int i = 0; i < 6; ++i) {
            if (!tag.func_74764_b("input" + Integer.toString(i))) continue;
            input.setRotaryInput(i, tag.func_74762_e("input" + Integer.toString(i)), tag.func_74762_e("length" + Integer.toString(i)));
        }
    }

    public static NBTTagCompound outputToNBT(IRotaryOutput output) {
        NBTTagCompound tag = new NBTTagCompound();
        for (int i = 0; i < 6; ++i) {
            tag.func_74768_a("output" + Integer.toString(i), output.getRotaryOutput(i));
        }
        return tag;
    }

    public static void outputFromNBT(IRotaryOutput output, NBTTagCompound tag) {
        for (int i = 0; i < 6; ++i) {
            if (!tag.func_74764_b("output" + Integer.toString(i))) continue;
            output.setRotaryOutput(i, tag.func_74762_e("output" + Integer.toString(i)));
        }
    }

    public static int getMaxInput(IRotaryInput input) {
        int index = 0;
        int value = 0;
        for (int i = 0; i < 6; ++i) {
            int e = Math.abs(input.getRotaryInput(i));
            if (e <= value) continue;
            index = i;
            value = e;
        }
        return index;
    }

    public static int removeRotation(int speed, int op) {
        if (speed > 0) {
            return (speed -= op) > 0 ? speed : 0;
        }
        if (speed < 0) {
            return (speed += op) < 0 ? speed : 0;
        }
        return 0;
    }

    public static int calcLoss(int input, int length, int div) {
        int loss = (int)Math.ceil(1.0 + (double)((int)Math.floor((double)length / (double)div)) * RotaryManager.getLossMulti(input));
        return RotaryManager.removeRotation(input, loss);
    }

    public static double getLossMulti(int speed) {
        if (Math.abs(speed) <= 32) {
            return 1.0;
        }
        return Math.abs((double)speed / 32.0);
    }
}

