/*
 * Decompiled with CFR 0.152.
 */
package net.wuerfel21.derpyshiz.world;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSapling;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenMagicTree
extends WorldGenAbstractTree {
    public WorldGenMagicTree(boolean notify) {
        super(notify);
    }

    public void genSide(World world, int x, int y, int z, int meta) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z) || block instanceof BlockBush) {
            this.func_150516_a(world, x, y, z, GameRegistry.findBlock((String)"derpyshiz", (String)"log"), meta);
        }
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int size = rand.nextInt(5) + 6;
        if (rand.nextInt(10) == 0) {
            size += rand.nextInt(5);
        }
        boolean flag = true;
        if (y >= 1 && y + size + 1 <= 256) {
            int k1;
            int j1;
            for (int i1 = y; i1 <= y + 1 + size; ++i1) {
                int b0 = 1;
                if (i1 == y) {
                    b0 = 0;
                }
                if (i1 >= y + 1 + size - 2) {
                    b0 = 2;
                }
                for (j1 = x - b0; j1 <= x + b0 && flag; ++j1) {
                    for (k1 = z - b0; k1 <= z + b0 && flag; ++k1) {
                        if (i1 >= 0 && i1 < 256) {
                            Block block = world.func_147439_a(j1, i1, k1);
                            if (this.isReplaceable(world, j1, i1, k1)) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            Block block2 = world.func_147439_a(x, y - 1, z);
            boolean isSoil = block2.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && y < 256 - size - 1) {
                int k2;
                block2.onPlantGrow(world, x, y - 1, z, x, y, z);
                for (k2 = 0; k2 < size; ++k2) {
                    int X = x;
                    int Z = z;
                    Block block3 = world.func_147439_a(X, y + k2, Z);
                    if (!block3.isAir((IBlockAccess)world, X, y + k2, Z) && !block3.isLeaves((IBlockAccess)world, X, y + k2, Z)) continue;
                    this.func_150516_a(world, X, y + k2, Z, GameRegistry.findBlock((String)"derpyshiz", (String)"log"), 1);
                }
                for (k2 = y - 3 + size; k2 <= y + size; ++k2) {
                    j1 = k2 - (y + size);
                    k1 = 1 - j1 / 2;
                    for (int l2 = x - k1; l2 <= x + k1; ++l2) {
                        int l1 = l2 - x;
                        for (int i2 = z - k1; i2 <= z + k1; ++i2) {
                            Block block1;
                            int j2 = i2 - z;
                            int X = l2;
                            int Z = i2;
                            if (Math.abs(l1) == k1 && Math.abs(j2) == k1 && (rand.nextInt(2) == 0 || j1 == 0) || !(block1 = world.func_147439_a(X, k2, Z)).isAir((IBlockAccess)world, X, k2, Z) && !block1.isLeaves((IBlockAccess)world, X, k2, Z)) continue;
                            this.func_150516_a(world, X, k2, Z, GameRegistry.findBlock((String)"derpyshiz", (String)"leaves"), 1);
                        }
                    }
                }
                this.genSide(world, x + 1, y, z, 5);
                this.genSide(world, x - 1, y, z, 5);
                this.genSide(world, x, y, z + 1, 9);
                this.genSide(world, x, y, z - 1, 9);
                return true;
            }
            return false;
        }
        return false;
    }
}

