/*
 * Decompiled with CFR 0.152.
 */
package so101.bricks;

import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import so101.bricks.ConfigBricks;
import so101.bricks.DamageSourceBricks;
import so101.bricks.EnumBrickAbilities;
import so101.bricks.EnumBricks;
import so101.bricks.ThrowableBricksMod;

public class EntityBrick
extends EntityThrowable {
    public boolean shouldDrop;
    public float scale;
    public int explosionSize;
    public float damage = -1.0f;
    private int ticksSpawned;
    public boolean normalPlayerThrow = false;

    public EntityBrick(World par1World) {
        super(par1World);
        if (this.getEntityData().func_74764_b("Scale") && this.getEntityData().func_74760_g("Scale") != 1.0f) {
            this.func_70105_a(this.getEntityData().func_74760_g("Scale"), this.getEntityData().func_74760_g("Scale"));
        }
        this.init();
    }

    public EntityBrick(World world, EntityPlayer player, ItemStack brick) {
        super(world, (EntityLivingBase)player);
        brick.field_77994_a = 1;
        this.init();
        this.shouldDrop = !player.field_71075_bZ.field_75098_d;
        this.func_70096_w().func_75692_b(16, (Object)brick);
        this.func_70096_w().func_75692_b(17, (Object)Float.valueOf(EnumBricks.getStatsForItem((ItemStack)brick).abilityScale));
    }

    public EntityBrick(World world, EntityPlayer player, ItemStack brick, boolean playerThrown) {
        this(world, player, brick);
        PotionEffect p = player.func_70660_b(Potion.field_76420_g);
        if (p != null && playerThrown) {
            int i = p.func_76458_c() > 3 ? 4 : p.func_76458_c();
            double multiplyer = 1.0 + 0.2 * (double)(i + 1);
            this.field_70159_w *= multiplyer;
            this.field_70181_x *= multiplyer;
            this.field_70179_y *= multiplyer;
        }
    }

    public EntityBrick(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(16, (Object)new ItemStack(Items.field_151118_aC, 1));
        this.field_70180_af.func_75682_a(17, (Object)Float.valueOf(0.0f));
    }

    public void init() {
        this.shouldDrop = true;
        this.scale = 1.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.ticksSpawned;
        if (this.getEnumType().special == EnumBrickAbilities.BURNING) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(3) && this.field_70170_p.field_72995_K; ++i) {
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextDouble() / 4.0 - 0.1, this.field_70146_Z.nextDouble() / 4.0 - 0.1, this.field_70146_Z.nextDouble() / 4.0 - 0.1);
            }
        } else if (this.getEnumType().special == EnumBrickAbilities.SPARKLY) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(3) && this.field_70170_p.field_72995_K; ++i) {
                this.field_70170_p.func_72869_a("fireworksSpark", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextDouble() / 4.0 - 0.1, this.field_70146_Z.nextDouble() / 4.0 - 0.1, this.field_70146_Z.nextDouble() / 4.0 - 0.1);
            }
        } else if (this.getEnumType().special == EnumBrickAbilities.REDSTONE) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(3); ++i) {
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0, 0.0, 0.0);
            }
        } else if (this.getEnumType().special == EnumBrickAbilities.ENDER) {
            for (int i = 0; i < 1 + this.field_70146_Z.nextInt(3) && this.field_70170_p.field_72995_K; ++i) {
                this.field_70170_p.func_72869_a("portal", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getRndMinorDouble(), this.getRndMinorDouble(), this.getRndMinorDouble());
            }
        } else if (ThrowableBricksMod.isDay(ThrowableBricksMod.DATE_CHRISTMAS)) {
            for (int i = 0; i < 3 + this.field_70146_Z.nextInt(7) && this.field_70170_p.field_72995_K; ++i) {
                this.field_70170_p.func_72869_a("reddust", this.field_70165_t + this.getRndMinorDouble(), this.field_70163_u + this.getRndMinorDouble(), this.field_70161_v + this.getRndMinorDouble(), 0.0, 0.0, 0.0);
            }
            this.field_70170_p.func_72869_a("happyVillager", this.field_70165_t + this.getRndMinorDouble(), this.field_70163_u + this.getRndMinorDouble(), this.field_70161_v + this.getRndMinorDouble(), 0.0, 0.0, 0.0);
        }
    }

    protected void func_70184_a(MovingObjectPosition mop) {
        float dd = 0.0f;
        if (mop.field_72308_g != null && mop.field_72308_g instanceof EntityLivingBase) {
            float density;
            double maxVelocity;
            double velY;
            double velXZ = Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y);
            boolean flag = velXZ + (velY = Math.abs(this.field_70181_x)) > Math.abs((maxVelocity = (double)(4.0f * ((density = this.getEnumType().density) * density)) + 0.5) * 1.2 + (double)density);
            double vel = velXZ + velY;
            float f = (int)(vel * 10.0) / 10;
            float damage = 4.0f + 3.0f * f / 10.0f * density + (flag ? (float)(3 + this.field_70146_Z.nextInt(7)) * density : 0.0f);
            damage = mop.field_72308_g instanceof EntitySkeleton ? damage * 2.0f : damage;
            mop.field_72308_g.func_70097_a(DamageSourceBricks.causeBrickDamage((Entity)this, (Entity)this.func_85052_h()), this.damage == -1.0f ? damage : this.damage);
            if (this.getEnumType().special == EnumBrickAbilities.BURNING) {
                mop.field_72308_g.func_70015_d((int)(this.getEnumType().abilityScale * 10.0f));
            } else if (this.getEnumType().special == EnumBrickAbilities.FREEZER && mop.field_72308_g instanceof EntityLivingBase) {
                ((EntityLivingBase)mop.field_72308_g).func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, (int)this.getEnumType().abilityScale * 10, 9));
            }
            dd = damage;
        }
        if (mop.field_72313_a.equals((Object)MovingObjectPosition.MovingObjectType.BLOCK)) {
            boolean flag;
            Block blockHit = this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            boolean bl = flag = blockHit.func_149688_o() == Material.field_151592_s || blockHit.func_149688_o() == Material.field_151585_k || blockHit.func_149688_o() == Material.field_151594_q || blockHit.func_149688_o() == Material.field_151582_l;
            if (flag) {
                int meta = this.field_70170_p.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (!this.field_70170_p.field_72995_K) {
                    blockHit.func_149697_b(this.field_70170_p, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d, meta, 0);
                    this.field_70170_p.func_147468_f(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                    this.field_70170_p.func_72908_a(this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, blockHit.field_149762_H.func_150495_a(), 1.0f, 1.0f);
                }
                for (int i = 0; i < 32 && this.field_70170_p.field_72995_K; ++i) {
                    this.field_70170_p.func_72869_a("blockcrack_" + Block.func_149682_b((Block)blockHit) + "_" + (meta << 12), (double)mop.field_72311_b, (double)mop.field_72312_c, (double)mop.field_72309_d, this.getRndMinorDouble(), this.getRndMinorDouble(), this.getRndMinorDouble());
                }
                return;
            }
            if (this.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) instanceof BlockTNT && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_147468_f(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                this.field_70170_p.func_72876_a((Entity)(this.func_85052_h() != null ? this.func_85052_h() : null), (double)mop.field_72311_b + 0.5, (double)mop.field_72312_c + 0.5, (double)mop.field_72309_d + 0.5, 4.0f, true);
            } else if (this.getEnumType().special == EnumBrickAbilities.BURNING && this.field_70170_p.func_147439_a((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) == Blocks.field_150350_a && !this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_147449_b((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, (Block)Blocks.field_150480_ab);
            }
        }
        if (this.getEnumType().special == EnumBrickAbilities.BURNING && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5 + this.field_70146_Z.nextInt(7); ++i) {
                this.field_70170_p.func_72869_a("smoke", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextDouble() / 4.0 - 0.1, this.field_70146_Z.nextDouble() / 4.0 - 0.1, this.field_70146_Z.nextDouble() / 4.0 - 0.1);
            }
        } else if (this.getEnumType().special == EnumBrickAbilities.SPARKLY && this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5 + this.field_70146_Z.nextInt(7); ++i) {
                this.field_70170_p.func_72869_a("fireworksSpark", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70146_Z.nextDouble() / 4.0 - 0.1, this.field_70146_Z.nextDouble() / 4.0 - 0.1, this.field_70146_Z.nextDouble() / 4.0 - 0.1);
            }
        } else if (this.getEnumType().special == EnumBrickAbilities.ENDER) {
            float f = -1.0f;
            float f1 = this.field_70180_af.func_111145_d(17);
            if (!this.field_70170_p.field_72995_K) {
                f = this.field_70146_Z.nextFloat();
            }
            if (f1 > f && !this.field_70170_p.field_72995_K) {
                this.field_70180_af.func_75692_b(17, (Object)Float.valueOf(f1 - f / 2.0f));
                int x = (int)this.field_70165_t;
                int y = (int)this.field_70163_u;
                int z = (int)this.field_70161_v;
                for (int t = 0; this.field_70170_p.func_147439_a(x, y, z) != Blocks.field_150350_a && x != (int)this.field_70165_t && y != (int)this.field_70163_u && z != (int)this.field_70161_v && t < 25; ++t) {
                    if (this.field_70170_p.func_147439_a(x += this.field_70146_Z.nextInt(10) - 5, y += this.field_70146_Z.nextInt(4) + 3, z += this.field_70146_Z.nextInt(10) - 5) != Blocks.field_150350_a) continue;
                    for (int i = 0; i < 5 + this.field_70146_Z.nextInt(7); ++i) {
                        this.field_70170_p.func_72869_a("portal", this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getRndMinorDouble(), this.getRndMinorDouble(), this.getRndMinorDouble());
                    }
                    this.field_70165_t = (double)x + 0.5;
                    this.field_70163_u = (double)y + 0.5;
                    this.field_70161_v = (double)z + 0.5;
                    this.field_70142_S = (double)x + 0.5;
                    this.field_70137_T = (double)y + 0.5;
                    this.field_70136_U = (double)z + 0.5;
                    return;
                }
            }
        }
        ItemStack drop = null;
        if (this.shouldDrop && this.explosionSize <= 0 && this.getEnumType().special != EnumBrickAbilities.EXPLOSIVE) {
            float density;
            double maxVelocity;
            double velY;
            boolean flag;
            double velXZ = Math.abs(this.field_70159_w) + Math.abs(this.field_70179_y);
            boolean bl = flag = velXZ + (velY = Math.abs(this.field_70181_x)) > Math.abs((maxVelocity = (double)(4.0f * ((density = this.getEnumType().density) * density)) + 0.5) * 1.2 + (double)density) && this.getEnumType().special != EnumBrickAbilities.UNBREAKABLE;
            boolean flag1 = this.normalPlayerThrow ? this.ticksSpawned > 10 : true;
            ItemStack item = this.func_70096_w().func_82710_f(16);
            Object object = item.func_77973_b().equals(Items.field_151118_aC) ? new ItemStack(ThrowableBricksMod.brickChunks, 1 + this.field_70146_Z.nextInt(2), 0) : (drop = item.func_77973_b().equals(Items.field_151130_bT) ? new ItemStack(ThrowableBricksMod.brickChunks, 1 + this.field_70146_Z.nextInt(2), 1) : null);
            if (item.func_77977_a().toLowerCase().contains("ingot")) {
                ItemStack nugget;
                String s2 = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)item));
                String s = s2.replaceFirst("ingot", "");
                String s1 = "nugget" + s;
                ItemStack itemStack = nugget = OreDictionary.getOres((String)s1).size() > 0 ? (ItemStack)OreDictionary.getOres((String)s1).get(0) : null;
                if (nugget != null) {
                    drop = new ItemStack(nugget.func_77973_b(), this.field_70146_Z.nextInt(5) + 1, nugget.func_77960_j());
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                EntityItem eitem = null;
                if (flag && drop != null && flag1) {
                    eitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, drop);
                } else if (flag && flag1 && drop == null) {
                    eitem = null;
                } else if (!flag || !flag1) {
                    eitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, item);
                }
                if (eitem != null) {
                    this.field_70170_p.func_72838_d(eitem);
                }
                if (this.getEnumType().special == EnumBrickAbilities.EXPLODEONSHATTER && flag && flag1) {
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getEnumType().abilityScale, ConfigBricks.enableTerrainDamage);
                }
            }
            if (ThrowableBricksMod.DEBUG && this.func_85052_h() instanceof EntityPlayer) {
                EntityPlayer p = (EntityPlayer)this.func_85052_h();
                p.func_146105_b((IChatComponent)new ChatComponentText("Vel: " + (float)this.field_70159_w + " " + (float)this.field_70181_x + " " + (float)this.field_70179_y));
                p.func_146105_b((IChatComponent)new ChatComponentText("Enum: " + this.getEnumType().toString()));
                p.func_146105_b((IChatComponent)new ChatComponentText("ItemName: " + this.getItem().func_77977_a()));
                if (dd != 0.0f) {
                    p.func_146105_b((IChatComponent)new ChatComponentText("Damage: " + dd));
                }
            }
        }
        for (int i = 0; i < 8 + (drop == null ? 16 : 0) && this.field_70170_p.field_72995_K; ++i) {
            this.field_70170_p.func_72869_a("iconcrack_" + Item.field_150901_e.func_148757_b((Object)this.getItem().func_77973_b()) + "_" + this.getItem().func_77960_j(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getRndMinorDouble(), this.getRndMinorDouble(), this.getRndMinorDouble());
        }
        if (!(this.field_70170_p.field_72995_K || this.explosionSize <= 0 && this.getEnumType().special != EnumBrickAbilities.EXPLOSIVE)) {
            EntityBrick cause = this;
            if (this.func_85052_h() != null) {
                cause = this.func_85052_h();
            }
            float explosionSize = this.explosionSize >= 0 ? (float)this.explosionSize : this.getEnumType().abilityScale * 10.0f;
            this.field_70170_p.func_72876_a((Entity)cause, mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c, explosionSize, ConfigBricks.enableTerrainDamage);
        }
        this.func_70106_y();
    }

    public void func_70020_e(NBTTagCompound nbt) {
        if (nbt.func_150297_b("ShouldDrop", 99)) {
            this.shouldDrop = nbt.func_74767_n("ShouldDrop");
        }
        if (nbt.func_150297_b("Scale", 99)) {
            this.scale = nbt.func_74760_g("Scale");
        }
        if (nbt.func_150297_b("ExplosionRadius", 99)) {
            this.explosionSize = nbt.func_74771_c("ExplosionRadius");
        }
        if (nbt.func_74764_b("Damage")) {
            this.damage = nbt.func_74760_g("Damage");
        }
        if (nbt.func_74764_b("Item")) {
            ItemStack i = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Item"));
            if (i == null) {
                throw new NullPointerException("Tag \"Item\" returned null ItemStack");
            }
            this.field_70180_af.func_75692_b(16, (Object)ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("Item")));
        }
        super.func_70020_e(nbt);
    }

    public void func_70109_d(NBTTagCompound nbt) {
        nbt.func_74757_a("ShouldDrop", this.shouldDrop);
        nbt.func_74776_a("Scale", this.scale);
        nbt.func_74776_a("Damage", this.damage);
        nbt.func_74774_a("ExplosionRadius", (byte)this.explosionSize);
        nbt.func_74782_a("Item", (NBTBase)this.field_70180_af.func_82710_f(16).func_77955_b(new NBTTagCompound()));
        super.func_70109_d(nbt);
    }

    protected double getRndMinorDouble() {
        return (this.field_70146_Z.nextDouble() - 0.5) / 4.0;
    }

    protected float func_70185_h() {
        return 0.1f;
    }

    protected float func_70182_d() {
        return 0.75f;
    }

    public ItemStack getItem() {
        return this.field_70180_af.func_82710_f(16);
    }

    public EnumBricks getEnumType() {
        return EnumBricks.getStatsForItem(this.getItem());
    }
}

