/*
 * Decompiled with CFR 0.152.
 */
package so101.bricks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import so101.bricks.EnumBrickAbilities;
import so101.bricks.ThrowableBricksMod;

public enum EnumBricks {
    BRICK(0.35f, 0.3f),
    NETHERBRICK(0.375f, 0.35f, EnumBrickAbilities.BURNING, 0.68f),
    TNTBRICK(0.375f, 0.25f, EnumBrickAbilities.EXPLOSIVE, 4.0f),
    ITEM(0.2f, 0.6f, EnumBrickAbilities.ITEM, 1.0f),
    LEAD(0.5f, 0.2f),
    COPPER(0.4f, 0.5f),
    DIAMOND(0.6f, 0.95f),
    OBSIDIAN(0.6f, 0.95f),
    BRONZE(0.4f, 0.5f),
    IRON(0.48f, 0.45f),
    GOLD(0.95f, 0.18f),
    PLATINUM(1.0f, 0.85f),
    SHINY(1.0f, 0.85f),
    MYTHRIL(1.0f, 0.85f),
    MITHRIL(1.0f, 0.85f),
    NICKEL(0.45f, 0.48f),
    SILVER(0.45f, 0.4f),
    STEEL(0.58f, 0.6f),
    TIN(0.35f, 0.25f),
    OSMIUM(0.42f, 0.48f),
    BEDROCKIUM(2.0f, 0.8f, EnumBrickAbilities.UNBREAKABLE, 1.0f),
    ENDERIUM(1.0f, 0.8f, EnumBrickAbilities.ENDER, 1.0f),
    ALUMINUM(0.46f, 0.38f),
    UNSTABLE(0.8f, 0.5f, EnumBrickAbilities.EXPLODEONSHATTER, 0.05f),
    BLUTONIUM(0.8f, 0.5f, EnumBrickAbilities.EXPLODEONSHATTER, 0.25f),
    FAIRY(0.4f, 0.5f, EnumBrickAbilities.SPARKLY, 0.5f),
    INVAR(0.49f, 0.5f),
    ELECTRUM(0.44f, 0.44f),
    ELECTRUMFLUX(0.42f, 0.44f, EnumBrickAbilities.REDSTONE, 0.8f),
    REDSTONEALLOY(0.5f, 0.43f, EnumBrickAbilities.REDSTONE, 0.3f),
    FIERY(0.45f, 0.49f, EnumBrickAbilities.BURNING, 0.68f),
    SEAREDBRICK(0.35f, 0.35f);

    public float weight = 0.35f;
    public float density = 0.35f;
    public EnumBrickAbilities special = EnumBrickAbilities.NONE;
    public float abilityScale = 0.0f;
    public static List<String> ingotExceptionsList;
    public static List<String> ingotExceptionsExclude;

    private EnumBricks(float weight, float density) {
        this.weight = weight;
        this.density = density;
    }

    private EnumBricks(float weight, float density, EnumBrickAbilities special, float scale) {
        this.weight = weight;
        this.density = density;
        this.special = special;
        this.abilityScale = scale;
    }

    public static EnumBricks getStatsForItem(ItemStack item) {
        boolean flag = false;
        for (String s : ingotExceptionsList) {
            if (!item.func_77977_a().contains(s)) continue;
            flag = true;
            break;
        }
        if (item.func_77977_a().toLowerCase().contains("brick")) {
            if (item.func_77973_b().equals(Items.field_151130_bT)) {
                return NETHERBRICK;
            }
            if (item.func_77973_b().equals(ThrowableBricksMod.brickTNT)) {
                return TNTBRICK;
            }
            return BRICK;
        }
        if (item.func_77977_a().toLowerCase().contains("ingot") && !item.func_77977_a().toLowerCase().contains("nugget") || flag) {
            String s = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)item));
            if (s.startsWith("ingot")) {
                String s1 = s.replaceFirst("ingot", "");
                ArrayList<EnumBricks> l = new ArrayList<EnumBricks>();
                for (EnumBricks b : (EnumBricks[])BRICK.getDeclaringClass().getEnumConstants()) {
                    l.add(b);
                }
                for (int i = 0; i < l.size(); ++i) {
                    if (!((EnumBricks)((Object)l.get(i))).toString().toLowerCase().equals(s1.toLowerCase())) continue;
                    return (EnumBricks)((Object)l.get(i));
                }
            } else if (item.func_77977_a().toLowerCase().contains("bedrockium")) {
                return BEDROCKIUM;
            }
            return IRON;
        }
        return ITEM;
    }

    static {
        ingotExceptionsList = new ArrayList<String>();
        ingotExceptionsExclude = new ArrayList<String>();
        ingotExceptionsList.add("darkSteel");
        ingotExceptionsList.add("electricalSteel");
        ingotExceptionsList.add("energeticAlloy");
        ingotExceptionsList.add("redstoneAlloy");
        ingotExceptionsList.add("conductiveIron");
        ingotExceptionsList.add("soularium");
        ingotExceptionsExclude.add("item.for.cratedBrick");
        ingotExceptionsExclude.add("item.for.cratedNetherBrick");
        ingotExceptionsExclude.add("item.steeleafIngot");
        ingotExceptionsExclude.add("item.tconstruct.MetalPattern.ingot");
    }
}

