/*
 * Decompiled with CFR 0.152.
 */
package so101.bricks;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Calendar;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityInteractEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;
import so101.bricks.BehaviorBrickDispense;
import so101.bricks.CommonProxy;
import so101.bricks.ConfigBricks;
import so101.bricks.EntityBrick;
import so101.bricks.EnumBricks;
import so101.bricks.Utils;
import so101.bricks.client.ParticleDustManager;
import so101.bricks.item.ItemBrickChunks;
import so101.bricks.item.ItemCannon;

@Mod(modid="ThrowableBricks", name="Throwable Bricks Mod", version="3.0")
public class ThrowableBricksMod {
    @SidedProxy(clientSide="so101.bricks.client.ClientProxy", serverSide="so101.bricks.CommonProxy")
    public static CommonProxy proxy;
    public static final String modID = "ThrowableBricks";
    public static final String version = "3.0";
    public static final Item brick;
    public static final Item brickNether;
    public static final Item brickTNT;
    public static final Item brickChunks;
    public static final Item brickCannon;
    public static EasterEggDate DATE_THANKSGIVING;
    public static EasterEggDate DATE_CHRISTMAS;
    public static boolean DEBUG;
    public ConfigBricks config;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new ConfigBricks(event.getSuggestedConfigurationFile());
        this.config.load();
        this.config.save();
        if (ConfigBricks.enableTNTBricks) {
            GameRegistry.registerItem((Item)brickTNT, (String)"explosivebrick", (String)modID);
            OreDictionary.registerOre((String)"brickTNT", (Item)brickTNT);
            OreDictionary.registerOre((String)"itemBrick", (Item)brickTNT);
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(brickTNT), (Object[])new Object[]{Items.field_151118_aC, Blocks.field_150335_W});
        }
        if (ConfigBricks.enableBrickCannon) {
            GameRegistry.registerItem((Item)brickCannon, (String)"brickcannon");
            GameRegistry.addRecipe((ItemStack)new ItemStack(brickCannon, 1), (Object[])new Object[]{"BI ", "BBI", " SB", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('S'), Items.field_151055_y, Character.valueOf('B'), Blocks.field_150336_V});
            GameRegistry.addRecipe((ItemStack)new ItemStack(brickCannon, 1), (Object[])new Object[]{"BI ", "BBI", " SB", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('S'), Items.field_151055_y, Character.valueOf('B'), Blocks.field_150385_bj});
        }
        GameRegistry.registerItem((Item)brickChunks, (String)"brickchunks", (String)modID);
        proxy.registerRendering();
        EntityRegistry.registerModEntity(EntityBrick.class, (String)"Brick", (int)ConfigBricks.brickID, (Object)this, (int)80, (int)2, (boolean)true);
        EntityList.func_75618_a(EntityBrick.class, (String)"Brick", (int)ConfigBricks.brickID);
        OreDictionary.registerOre((String)"brickNormal", (Item)brick);
        OreDictionary.registerOre((String)"brickNether", (Item)brickNether);
        OreDictionary.registerOre((String)"itemBrick", (Item)brick);
        OreDictionary.registerOre((String)"itemBrick", (Item)brickNether);
        GameRegistry.addRecipe((ItemStack)new ItemStack(brick, 1), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack(brickChunks, 1, 0)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(brickNether, 1), (Object[])new Object[]{"XX", "XX", Character.valueOf('X'), new ItemStack(brickChunks, 1, 1)});
        GameRegistry.addRecipe((ItemStack)new ItemStack(brick, 4), (Object[])new Object[]{"X", Character.valueOf('X'), Blocks.field_150336_V});
        GameRegistry.addRecipe((ItemStack)new ItemStack(brickNether, 4), (Object[])new Object[]{"X", Character.valueOf('X'), Blocks.field_150385_bj});
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
        new ParticleDustManager();
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent e) {
        if (e.getPlayer() != null && e.getPlayer().func_70694_bm() != null && ConfigBricks.enableBrickCustomDrops) {
            if (!e.block.equals(Blocks.field_150336_V) && !e.block.equals(Blocks.field_150385_bj)) {
                return;
            }
            float f = 0.7f;
            double d0 = (double)(e.world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(e.world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(e.world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem eitem = new EntityItem(e.world, (double)e.x + d0, (double)e.y + d1, (double)e.z + d2);
            if (e.getPlayer().func_70694_bm().func_77973_b() instanceof ItemPickaxe) {
                if (e.block.equals(Blocks.field_150336_V)) {
                    e.setCanceled(true);
                    e.world.func_147468_f(e.x, e.y, e.z);
                    eitem.func_92058_a(new ItemStack(Items.field_151118_aC, 3 + e.world.field_73012_v.nextInt(2)));
                } else if (e.block.equals(Blocks.field_150385_bj)) {
                    e.setCanceled(true);
                    e.world.func_147468_f(e.x, e.y, e.z);
                    eitem.func_92058_a(new ItemStack(Items.field_151130_bT, 3 + e.world.field_73012_v.nextInt(2)));
                } else {
                    return;
                }
            }
            if (eitem.func_92059_d() != null) {
                e.world.func_72838_d((Entity)eitem);
            }
        }
    }

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent event) {
        BlockDispenser.field_149943_a.func_82595_a((Object)brick, (Object)new BehaviorBrickDispense());
        BlockDispenser.field_149943_a.func_82595_a((Object)brickNether, (Object)new BehaviorBrickDispense());
        if (ConfigBricks.enableTNTBricks) {
            BlockDispenser.field_149943_a.func_82595_a((Object)brickTNT, (Object)new BehaviorBrickDispense());
        }
        if (ConfigBricks.enableIngotThrows) {
            BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151043_k, (Object)new BehaviorBrickDispense());
            BlockDispenser.field_149943_a.func_82595_a((Object)Items.field_151042_j, (Object)new BehaviorBrickDispense());
        }
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.entityPlayer.field_71071_by == null || event.entityPlayer.field_71071_by.field_70462_a == null) {
            return;
        }
        if (ThrowableBricksMod.canThrow(event.itemStack) && ConfigBricks.enableTooltipRightClickToThrow && (!event.itemStack.func_77942_o() || !event.itemStack.func_77978_p().func_74767_n("NoTooltip"))) {
            String s = "Right click to throw!";
            if (ThrowableBricksMod.isDay(DATE_CHRISTMAS)) {
                s = Utils.formatChristmasColors(s);
            }
            event.toolTip.add(EnumChatFormatting.GRAY.toString() + s);
            boolean flag1 = false;
            if (event.itemStack.func_77942_o()) {
                boolean flag;
                NBTTagCompound nbt = event.itemStack.func_77978_p();
                flag1 = flag = nbt.func_74764_b("Damage") || nbt.func_74764_b("Scale") || nbt.func_74764_b("ExplosionRadius");
                if (flag) {
                    event.toolTip.add("");
                }
                if (nbt.func_74764_b("Damage")) {
                    event.toolTip.add(EnumChatFormatting.GRAY.toString() + "Damage: " + nbt.func_74760_g("Damage"));
                }
                if (nbt.func_74764_b("Scale")) {
                    event.toolTip.add(EnumChatFormatting.GRAY.toString() + "Scale: " + nbt.func_74760_g("Scale"));
                }
            }
            if (event.itemStack.func_77942_o() && event.itemStack.func_77978_p().func_74764_b("ExplosionRadius") || event.itemStack.func_77973_b().equals(brickTNT)) {
                if (!flag1) {
                    event.toolTip.add("");
                }
                if (event.showAdvancedItemTooltips) {
                    event.toolTip.add(EnumChatFormatting.GRAY.toString() + "Explosion Radius: " + (event.itemStack.func_77942_o() ? event.itemStack.func_77978_p().func_74762_e("ExplosionRadius") : 4));
                } else {
                    event.toolTip.add(EnumChatFormatting.GRAY.toString() + "Explodes on Impact");
                }
            }
        } else if (event.itemStack.func_77973_b().equals(brickCannon)) {
            ItemStack item = null;
            boolean gunpowder = false;
            for (int i = 0; i < event.entityPlayer.field_71071_by.field_70462_a.length; ++i) {
                if (ThrowableBricksMod.canThrow(event.entityPlayer.field_71071_by.field_70462_a[i]) && item == null) {
                    item = event.entityPlayer.field_71071_by.field_70462_a[i];
                } else if (event.entityPlayer.field_71071_by.field_70462_a[i] != null && event.entityPlayer.field_71071_by.field_70462_a[i].func_77973_b() == Items.field_151016_H) {
                    gunpowder = true;
                }
                if (item != null && gunpowder) break;
            }
            if (!gunpowder && ConfigBricks.brickCannonsGunpowder && !event.entityPlayer.field_71075_bZ.field_75098_d) {
                event.toolTip.add(EnumChatFormatting.GRAY.toString() + "No Gunpowder to Fire!");
            } else if (item != null) {
                event.toolTip.add(EnumChatFormatting.GRAY.toString() + "Firing: " + item.func_82833_r());
            } else {
                event.toolTip.add(EnumChatFormatting.GRAY.toString() + "No Item to Fire!");
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent e) {
        Block block;
        if (e.isCanceled()) {
            return;
        }
        if (e.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
            this.throwBrickEvent(e.entityPlayer);
        } else if (e.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && e.entityPlayer.func_70694_bm() != null && ThrowableBricksMod.canThrow(e.entityPlayer.func_70694_bm()) && !((block = e.world.func_147439_a(e.x, e.y, e.z)) instanceof ITileEntityProvider) && !(block instanceof BlockWorkbench)) {
            this.throwBrickEvent(e.entityPlayer);
        }
    }

    @SubscribeEvent
    public void onEntityRightClick(EntityInteractEvent e) {
        this.throwBrickEvent(e.entityPlayer);
    }

    public void throwBrickEvent(EntityPlayer player) {
        ItemStack iitem;
        if (player.func_70694_bm() != null && ThrowableBricksMod.canThrow(iitem = player.func_70694_bm())) {
            EntityBrick brick = new EntityBrick(player.field_70170_p, player, player.func_70694_bm().func_77946_l(), true);
            boolean flag1 = player.func_70694_bm().func_77973_b().equals(brickTNT) || player.func_70694_bm().func_77942_o() && player.func_70694_bm().func_77978_p().func_74764_b("ExplosionRadius");
            brick.shouldDrop = !player.field_71075_bZ.field_75098_d;
            brick.explosionSize = flag1 ? 4 : 0;
            brick.normalPlayerThrow = true;
            if (player.func_70694_bm().func_82837_s()) {
                brick.getEntityData().func_74778_a("CustomName", player.func_70694_bm().func_82833_r());
            }
            if (player.func_70694_bm().func_77978_p() != null) {
                if (player.func_70694_bm().func_77978_p().func_74764_b("Damage")) {
                    brick.damage = player.func_70694_bm().func_77978_p().func_74760_g("Damage");
                }
                if (player.func_70694_bm().func_77978_p().func_74764_b("ExplosionRadius")) {
                    brick.explosionSize = player.func_70694_bm().func_77978_p().func_74771_c("ExplosionRadius");
                }
                if (player.func_70694_bm().func_77978_p().func_74764_b("ShouldDrop")) {
                    brick.shouldDrop = player.func_70694_bm().func_77978_p().func_74767_n("ShouldDrop");
                }
            }
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_72838_d((Entity)brick);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --player.func_70694_bm().field_77994_a;
            }
        }
    }

    public static boolean canThrow(ItemStack item) {
        if (item == null) {
            return false;
        }
        boolean flag1 = item.func_77973_b() instanceof ItemBlock || item.func_77973_b() instanceof ItemArmor;
        boolean flag2 = item.func_77977_a().toLowerCase().contains("brick") && !item.func_77977_a().toLowerCase().contains("chunk") && !item.func_77977_a().toLowerCase().contains("cannon");
        boolean flag3 = item.func_77977_a().toLowerCase().contains("ingot") && ConfigBricks.enableIngotThrows;
        boolean flag4 = item.func_77942_o() && item.func_77978_p().func_74767_n("Throwable");
        boolean flag5 = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)item)).startsWith("ingot") && EnumBricks.ingotExceptionsList.contains(OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)item)).replaceFirst("ingot", "")) && ConfigBricks.enableIngotThrows;
        boolean flag6 = EnumBricks.ingotExceptionsExclude.contains(item.func_77977_a());
        return !flag1 && (flag2 || flag3 || flag4 || flag5) && !flag6;
    }

    public static boolean isDay(EasterEggDate date) {
        return Calendar.getInstance().get(2) == date.MONTH && Calendar.getInstance().get(5) == date.DAY;
    }

    static {
        brick = Items.field_151118_aC;
        brickNether = Items.field_151130_bT;
        brickTNT = new Item().func_77655_b("brickTNT").func_111206_d("ThrowableBricks:brickTNT").func_77637_a(CreativeTabs.field_78035_l);
        brickChunks = new ItemBrickChunks().func_77655_b("brickChunks");
        brickCannon = new ItemCannon();
        DATE_THANKSGIVING = EasterEggDate.THANKSGIVING;
        DATE_CHRISTMAS = EasterEggDate.CHRISTMAS;
        DEBUG = false;
    }

    public static enum EasterEggDate {
        THANKSGIVING(27, 10),
        CHRISTMAS(25, 11);

        public int MONTH;
        public int DAY;

        private EasterEggDate(int day, int month) {
            this.MONTH = month;
            this.DAY = day;
        }
    }
}

