/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import tk.nukeduck.hud.BetterHud;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.HudElements;
import tk.nukeduck.hud.element.settings.ElementSettingAbsolutePosition;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.element.settings.ElementSettingSlider;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementBlockViewer
extends ExtraGuiElement {
    private ElementSettingMode posMode;
    private ElementSettingPosition pos;
    private ElementSettingAbsolutePosition pos2;
    private ElementSettingBoolean showBlock;
    private ElementSettingSlider distance;
    private ElementSettingBoolean showIds;
    private HashMap<Block, ItemStack> replaceStacks = new HashMap();
    private Bounds bounds = Bounds.EMPTY;

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.posMode.index = 0;
        this.pos.value = ElementSettingPosition.Position.TOP_CENTER;
        this.pos2.x = 5;
        this.pos2.y = 5;
        this.showBlock.value = true;
        this.distance.value = 256.0;
        this.showIds.value = false;
    }

    @Override
    public String getName() {
        return "blockViewer";
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        return this.bounds;
    }

    public ExtraGuiElementBlockViewer() {
        this.replaceStacks.put(Blocks.field_150474_ac, new ItemStack(Blocks.field_150474_ac));
        this.replaceStacks.put(Blocks.field_150439_ay, new ItemStack(Blocks.field_150450_ax));
        this.replaceStacks.put(Blocks.field_150380_bt, new ItemStack(Blocks.field_150380_bt));
        this.replaceStacks.put(Blocks.field_150384_bq, new ItemStack(Blocks.field_150378_br));
        this.settings.add(new ElementSettingDivider("position"));
        this.posMode = new ElementSettingMode("posMode", new String[]{"setPos", "absolute"});
        this.settings.add(this.posMode);
        this.pos = new ElementSettingPosition("position", ElementSettingPosition.Position.combine(ElementSettingPosition.Position.TOP_LEFT, ElementSettingPosition.Position.TOP_CENTER, ElementSettingPosition.Position.TOP_RIGHT, ElementSettingPosition.Position.BOTTOM_LEFT, ElementSettingPosition.Position.BOTTOM_RIGHT, ElementSettingPosition.Position.MIDDLE_CENTER)){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementBlockViewer)ExtraGuiElementBlockViewer.this).posMode.index == 0;
            }
        };
        this.settings.add(this.pos);
        this.pos2 = new ElementSettingAbsolutePosition("position2"){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementBlockViewer)ExtraGuiElementBlockViewer.this).posMode.index == 1;
            }
        };
        this.settings.add(this.pos2);
        this.settings.add(new ElementSettingDivider("misc"));
        this.showBlock = new ElementSettingBoolean("showBlock");
        this.settings.add(this.showBlock);
        this.distance = new ElementSettingSlider("distance", 6.0, 256.0){

            @Override
            public String getSliderText() {
                if (this.value % 16.0 == 0.0) {
                    int chunks = (int)(this.value / 16.0);
                    String chunkString = FormatUtil.translatePre(chunks == 1 ? "strings.chunk" : "strings.chunks", String.valueOf(chunks));
                    return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), chunkString);
                }
                String distanceString = FormatUtil.translatePre("strings.distanceShort", String.valueOf((int)this.value));
                return FormatUtil.translatePre("menu.settingButton", this.getLocalizedName(), distanceString);
            }
        };
        this.settings.add(this.distance);
        this.distance.accuracy = 16.0;
        this.showIds = new ElementSettingBoolean("showIds");
        this.settings.add(this.showIds);
    }

    @Override
    public void update(Minecraft mc) {
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        MovingObjectPosition mop = mc.field_71451_h.func_70614_a(this.distance.value, 1.0f);
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            String l;
            if (mc.field_71441_e.func_147437_c(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d)) {
                return;
            }
            Block te = mc.field_71441_e.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            ItemStack stack = te.getPickBlock(mop, (World)mc.field_71441_e, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
            for (Block block : this.replaceStacks.keySet()) {
                if (!te.equals(block)) continue;
                stack = this.replaceStacks.get(block);
                break;
            }
            try {
                l = stack.func_82833_r();
            }
            catch (NullPointerException e) {
                try {
                    l = te.func_149732_F();
                    stack = new ItemStack(Blocks.field_150348_b);
                }
                catch (Exception ex) {
                    l = FormatUtil.translatePre("strings.unknownBlock", new String[0]);
                    stack = new ItemStack(Blocks.field_150348_b);
                }
            }
            if (this.showIds.value) {
                String name = Block.field_149771_c.func_148750_c((Object)te).toString();
                String id = String.format("%04d", Block.func_149682_b((Block)te));
                String meta = String.valueOf(mc.field_71441_e.func_72805_g(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d));
                l = l + " " + ChatFormatting.YELLOW + FormatUtil.translatePre("strings.brackets", name + "/#" + id + ":" + meta);
            }
            int w = mc.field_71466_p.func_78256_a(l) + 10;
            if (this.showBlock.value) {
                w += 21;
            }
            int x = resolution.func_78326_a() / 2 - w - 5;
            int y = resolution.func_78328_b() / 2 - mc.field_71466_p.field_78288_b - 15;
            if (this.posMode.index == 1) {
                x = this.pos2.x;
                y = this.pos2.y;
            } else if (this.pos.value == ElementSettingPosition.Position.TOP_LEFT) {
                x = 5;
                y = layoutManager.get(this.pos.value);
                layoutManager.add(10 + mc.field_71466_p.field_78288_b, this.pos.value);
            } else if (this.pos.value == ElementSettingPosition.Position.TOP_CENTER) {
                x = (resolution.func_78326_a() - w) / 2;
                y = HudElements.biome.enabled ? 60 : 50;
            } else if (this.pos.value == ElementSettingPosition.Position.TOP_RIGHT) {
                x = resolution.func_78326_a() - 5 - w;
                y = layoutManager.get(this.pos.value);
                layoutManager.add(10 + mc.field_71466_p.field_78288_b, this.pos.value);
            } else if (this.pos.value == ElementSettingPosition.Position.BOTTOM_LEFT) {
                x = 5;
                y = resolution.func_78328_b() - layoutManager.get(this.pos.value) - 10 - mc.field_71466_p.field_78288_b;
                layoutManager.add(10 + mc.field_71466_p.field_78288_b, this.pos.value);
            } else if (this.pos.value == ElementSettingPosition.Position.BOTTOM_RIGHT) {
                x = resolution.func_78326_a() - 5 - w;
                y = resolution.func_78328_b() - layoutManager.get(this.pos.value) - 10 - mc.field_71466_p.field_78288_b;
                layoutManager.add(10 + mc.field_71466_p.field_78288_b, this.pos.value);
            }
            this.bounds = new Bounds(x, y, w, 11 + mc.field_71466_p.field_78288_b);
            this.renderBox(x, y, w, 11 + mc.field_71466_p.field_78288_b, RenderUtil.colorARGB(58, 0, 0, 0));
            if (this.showBlock.value) {
                mc.field_71456_v.func_73731_b(mc.field_71466_p, l, x + 26, y + 6, RenderUtil.colorRGB(255, 255, 255));
                RenderHelper.func_74520_c();
                GL11.glEnable((int)32826);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                BetterHud.renderItem.func_82406_b(mc.field_71466_p, mc.func_110434_K(), stack, x + 5, y + 2);
                RenderHelper.func_74518_a();
            } else {
                mc.field_71456_v.func_73731_b(mc.field_71466_p, l, x + 5, y + 6, RenderUtil.colorRGB(255, 255, 255));
            }
        }
    }

    public void renderBox(int x, int y, int width, int height, int color) {
        RenderUtil.drawRect(x + 1, y, x + width - 1, y + height, color);
        RenderUtil.drawRect(x, y + 1, x + 1, y + height - 1, color);
        RenderUtil.drawRect(x + width - 1, y + 1, x + width, y + height - 1, color);
        RenderUtil.drawRect(x + 1, y + 1, x + (width - 1), y + 2, color);
        RenderUtil.drawRect(x + 1, y + height - 2, x + (width - 1), y + height - 1, color);
        RenderUtil.drawRect(x + 1, y + 2, x + 2, y + height - 2, color);
        RenderUtil.drawRect(x + (width - 2), y + 2, x + (width - 1), y + height - 2, color);
    }

    @Override
    public boolean shouldProfile() {
        return true;
    }
}

