/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import tk.nukeduck.hud.BetterHud;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.ExtraGuiElementArmorBars;
import tk.nukeduck.hud.element.settings.ElementSettingAbsolutePosition;
import tk.nukeduck.hud.element.settings.ElementSettingBoolean;
import tk.nukeduck.hud.element.settings.ElementSettingDivider;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FormatUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.StringManager;

public class ExtraGuiElementHandBar
extends ExtraGuiElement {
    private ElementSettingMode posMode;
    private ElementSettingAbsolutePosition pos;
    private ElementSettingBoolean showName;
    private ElementSettingBoolean showDurability;
    private ElementSettingMode durabilityMode;
    private ElementSettingBoolean showItem;
    private Bounds bounds = Bounds.EMPTY;

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.posMode.index = 0;
        this.pos.x = 5;
        this.pos.y = 5;
        this.showName.value = true;
        this.showDurability.value = true;
        this.durabilityMode.index = 0;
        this.showItem.value = true;
    }

    @Override
    public String getName() {
        return "handBar";
    }

    public ExtraGuiElementHandBar() {
        this.settings.add(new ElementSettingDivider("position"));
        this.posMode = new ElementSettingMode("posMode", new String[]{"setPos", "absolute"});
        this.settings.add(this.posMode);
        this.pos = new ElementSettingAbsolutePosition("position"){

            @Override
            public boolean getEnabled() {
                return ((ExtraGuiElementHandBar)ExtraGuiElementHandBar.this).posMode.index == 1;
            }
        };
        this.settings.add(this.pos);
        this.settings.add(new ElementSettingDivider("misc"));
        this.showItem = new ElementSettingBoolean("showItem");
        this.settings.add(this.showItem);
        this.showDurability = new ElementSettingBoolean("showDurability");
        this.settings.add(this.showDurability);
        this.durabilityMode = new ElementSettingMode("durabilityMode", new String[]{"values", "percent"});
        this.settings.add(this.durabilityMode);
        this.showName = new ElementSettingBoolean("showName");
        this.settings.add(this.showName);
    }

    @Override
    public void update(Minecraft mc) {
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        return this.bounds;
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        TextureManager tm = mc.func_110434_K();
        ItemStack item = mc.field_71439_g.func_71045_bC();
        if (item != null && item.func_77958_k() > 0) {
            int maxDamage = item.func_77958_k();
            float value = (float)(maxDamage - item.func_77960_j()) / (float)maxDamage;
            byte green = (byte)(255.0f * value);
            byte red = (byte)(256 - green);
            String text = "";
            String dur = this.durabilityMode.getValue().equals("percent") ? FormatUtil.translatePre("strings.percent", ExtraGuiElementArmorBars.ONE_PLACE.format((double)value * 100.0)) : FormatUtil.translatePre("strings.outOf", String.valueOf(maxDamage - item.func_77960_j()), String.valueOf(maxDamage));
            if (this.showName.value && this.showDurability.value) {
                text = FormatUtil.translatePre("strings.separated", item.func_82833_r(), dur);
            } else if (this.showName.value) {
                text = item.func_82833_r();
            } else if (this.showDurability.value) {
                text = dur;
            }
            int totalWidth = mc.field_71466_p.func_78256_a(text);
            if (this.showItem.value) {
                totalWidth += 21;
            }
            int x = this.posMode.index == 0 ? resolution.func_78326_a() / 2 - 90 : this.pos.x;
            int y = this.posMode.index == 0 ? resolution.func_78328_b() - 84 : this.pos.y;
            this.bounds = new Bounds(x, y, 180, 18);
            if (this.showItem.value) {
                mc.field_71424_I.func_76320_a("items");
                RenderHelper.func_74520_c();
                BetterHud.renderItem.func_82406_b(mc.field_71466_p, tm, item, x + 90 - totalWidth / 2, y);
                RenderHelper.func_74518_a();
                mc.field_71424_I.func_76319_b();
            }
            mc.field_71424_I.func_76320_a("text");
            mc.field_71456_v.func_73731_b(mc.field_71466_p, text, x + 90 - totalWidth / 2 + (this.showItem.value ? 21 : 0), y + 4, RenderUtil.colorRGB(255, 255, 255));
            mc.field_71424_I.func_76319_b();
            mc.field_71424_I.func_76320_a("bars");
            RenderUtil.drawRect(x, y + 16, x + 180, y + 18, RenderUtil.colorARGB(255, 0, 0, 0));
            RenderUtil.drawRect(x, y + 16, x + Math.round(value * 180.0f), y + 17, RenderUtil.colorARGB(255, red, green, 0));
            mc.field_71424_I.func_76319_b();
        }
    }

    @Override
    public boolean shouldProfile() {
        return true;
    }
}

