/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.element.text;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import tk.nukeduck.hud.element.ExtraGuiElement;
import tk.nukeduck.hud.element.settings.ElementSettingAbsolutePosition;
import tk.nukeduck.hud.element.settings.ElementSettingMode;
import tk.nukeduck.hud.element.settings.ElementSettingPosition;
import tk.nukeduck.hud.element.settings.ElementSettingSlider;
import tk.nukeduck.hud.util.Bounds;
import tk.nukeduck.hud.util.FuncsUtil;
import tk.nukeduck.hud.util.LayoutManager;
import tk.nukeduck.hud.util.RenderUtil;
import tk.nukeduck.hud.util.StringManager;

public abstract class ExtraGuiElementText
extends ExtraGuiElement {
    protected ElementSettingMode posMode;
    protected ElementSettingPosition pos;
    protected ElementSettingAbsolutePosition pos2;
    protected ElementSettingSlider red;
    protected ElementSettingSlider green;
    protected ElementSettingSlider blue;
    private Bounds bounds = Bounds.EMPTY;

    public ExtraGuiElementText() {
        this.posMode = new ElementSettingMode("posMode", new String[]{"setPos", "absolute"});
        this.settings.add(this.posMode);
        this.pos = new ElementSettingPosition("position", ElementSettingPosition.Position.CORNERS){

            @Override
            public boolean getEnabled() {
                return ExtraGuiElementText.this.posMode.index == 0;
            }
        };
        this.settings.add(this.pos);
        this.pos2 = new ElementSettingAbsolutePosition("position2"){

            @Override
            public boolean getEnabled() {
                return ExtraGuiElementText.this.posMode.index == 1;
            }
        };
        this.settings.add(this.pos2);
        this.red = new ElementSettingSlider("red", 0.0, 255.0);
        this.settings.add(this.red);
        this.red.accuracy = 1.0;
        this.green = new ElementSettingSlider("green", 0.0, 255.0);
        this.settings.add(this.green);
        this.green.accuracy = 1.0;
        this.blue = new ElementSettingSlider("blue", 0.0, 255.0);
        this.settings.add(this.blue);
        this.blue.accuracy = 1.0;
    }

    public int getColor() {
        return RenderUtil.colorRGB((int)this.red.value, (int)this.green.value, (int)this.blue.value);
    }

    @Override
    public void loadDefaults() {
        this.enabled = true;
        this.posMode.index = 0;
        this.pos.value = ElementSettingPosition.Position.TOP_LEFT;
        this.pos2.x = 5;
        this.pos2.y = 5;
        this.red.value = 255.0;
        this.green.value = 255.0;
        this.blue.value = 255.0;
    }

    @Override
    public Bounds getBounds(ScaledResolution resolution) {
        return this.bounds;
    }

    @Override
    public void render(Minecraft mc, ScaledResolution resolution, StringManager stringManager, LayoutManager layoutManager) {
        String[] text = this.getText(mc);
        if (this.posMode.index == 0) {
            stringManager.add(this.pos.value, RenderUtil.colorRGB((int)this.red.value, (int)this.green.value, (int)this.blue.value), this.pos.value == ElementSettingPosition.Position.BOTTOM_LEFT || this.pos.value == ElementSettingPosition.Position.BOTTOM_RIGHT ? FuncsUtil.flip(text) : text);
            this.bounds = Bounds.EMPTY;
        } else {
            this.bounds = RenderUtil.renderStrings(mc.field_71466_p, text, this.pos2.x, this.pos2.y, RenderUtil.colorRGB((int)this.red.value, (int)this.green.value, (int)this.blue.value), ElementSettingPosition.Position.TOP_LEFT);
        }
    }

    protected abstract String[] getText(Minecraft var1);
}

