/*
 * Decompiled with CFR 0.152.
 */
package tk.nukeduck.hud.util;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.StatCollector;

public class FormatUtil {
    public static final String PARAM_CHAR = "*";
    public static final String HUD_PREFIX = "betterHud.";

    public static String formatTime(int hours, int minutes, boolean twentyFourHour) {
        if (twentyFourHour) {
            return FormatUtil.translatePre("strings.time", String.valueOf(hours), Strings.padStart((String)String.valueOf(minutes), (int)2, (char)'0'));
        }
        int h = hours % 12;
        if (h == 0) {
            h = 12;
        }
        return FormatUtil.translatePre("strings.time." + (hours >= 12 ? "pm" : "am"), String.valueOf(h), Strings.padStart((String)String.valueOf(minutes), (int)2, (char)'0'));
    }

    public static int getLongestWidth(FontRenderer fr, ArrayList<String> strings) {
        int longest = 0;
        for (String s : strings) {
            int length = fr.func_78256_a(s);
            if (length <= longest) continue;
            longest = length;
        }
        return longest;
    }

    public static String translatePre(String path, String ... params) {
        return FormatUtil.translate(HUD_PREFIX + path, params);
    }

    public static String translate(String path, String ... params) {
        String translation = StatCollector.func_74838_a((String)path);
        String string = translation = translation == path ? StatCollector.func_150826_b((String)path) : translation;
        if (params.length > 0) {
            for (int i = 0; i < params.length && translation.contains(PARAM_CHAR); ++i) {
                translation = translation.replaceFirst(Pattern.quote(PARAM_CHAR), params[i]);
            }
        }
        return translation;
    }

    public static String separate(String ... parts) {
        if (parts.length == 0) {
            return "";
        }
        if (parts.length == 1) {
            return parts[0];
        }
        return FormatUtil.translatePre("strings.separated", parts[0], FormatUtil.separate(Arrays.copyOfRange(parts, 1, parts.length)));
    }
}

