/*
 * Decompiled with CFR 0.152.
 */
package bendonnelly1.orespiders.entity;

import bendonnelly1.orespiders.OreSpiders;
import bendonnelly1.orespiders.entity.EntityOreSpider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityQueenSpider
extends EntityOreSpider
implements IBossDisplayData {
    private int queenSpiderHealth;
    public int phase;
    private boolean attackedByPlayer;
    public int oldPhase = 0;

    public EntityQueenSpider(World world) {
        super(world);
        this.field_70178_ae = true;
        this.field_70728_aV = 500;
        this.phase = 0;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.6000011920929);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(9.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public Entity func_70782_k() {
        if (this.attackedByPlayer) {
            double d0 = 40.0;
            this.field_70170_p.func_72856_b((Entity)this, d0);
        }
        return null;
    }

    public boolean func_70652_k(Entity ent) {
        if (super.func_70652_k(ent)) {
            if (ent instanceof EntityLivingBase && this.getPhase() == 3) {
                ((EntityLivingBase)ent).func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 40, 2));
            }
            return true;
        }
        return false;
    }

    private void generateParticles(String particle) {
        for (int i = 0; i < 4; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_72869_a(particle, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d0, d1, d2);
        }
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("attackedByPlayer", this.attackedByPlayer);
        tag.func_74768_a("phase", this.phase);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.attackedByPlayer = tag.func_74767_n("attackedByPlayer");
        this.phase = tag.func_74762_e("phase");
    }

    public void func_70636_d() {
        this.queenSpiderHealth = Math.round(this.func_110143_aJ());
        int x = MathHelper.func_76128_c((double)this.field_70165_t);
        int y = MathHelper.func_76128_c((double)this.field_70163_u);
        int z = MathHelper.func_76128_c((double)this.field_70161_v);
        if (this.getPhase() == 2 && this.field_70173_aa % 60 == 0) {
            this.func_70691_i(5.0f);
            this.generateParticles("heart");
        }
        this.phaseTransition();
        super.func_70636_d();
    }

    public int getPhase() {
        if (this.queenSpiderHealth == 200) {
            this.phase = 0;
        } else if (this.queenSpiderHealth <= 199 && this.queenSpiderHealth > 100) {
            this.phase = 1;
        } else if (this.queenSpiderHealth <= 100 && this.queenSpiderHealth > 25) {
            this.phase = 2;
        } else if (this.queenSpiderHealth <= 25) {
            this.phase = 3;
        }
        return this.phase;
    }

    public boolean hasPhaseChanged() {
        if (this.oldPhase != this.getPhase()) {
            this.oldPhase = this.getPhase();
            return true;
        }
        return false;
    }

    public void phaseTransition() {
        if (this.hasPhaseChanged()) {
            if (this.getPhase() == 1) {
                this.generateParticles("angryVillager");
                this.field_70170_p.func_72956_a((Entity)this, "orespiders:spider_scream", 1.0f, 1.0f);
            } else if (this.getPhase() == 2) {
                this.generateParticles("angryVillager");
                this.field_70170_p.func_72956_a((Entity)this, "orespiders:spider_scream", 1.0f, 1.0f);
            } else if (this.getPhase() == 3) {
                this.setKnockbackHeight(1.8000000059604646);
                this.setMovementSpeed(2.500000011920929);
                this.generateParticles("angryVillager");
                this.field_70170_p.func_72956_a((Entity)this, "orespiders:spider_scream", 1.0f, 1.0f);
            }
        }
    }

    @Override
    protected void func_70628_a(boolean hitByPlayer, int lootEnchantLevel) {
        this.func_145779_a(OreSpiders.orbWeaver, 1);
    }

    public void expandBoundingBox(float growthFactor) {
        this.func_70105_a(1.4f * growthFactor, 0.9f * growthFactor);
    }

    public void printPhaseAndHP() {
        System.out.println("Phase: " + this.phase + "   HP:" + this.func_110143_aJ());
    }
}

