/*
 * Decompiled with CFR 0.152.
 */
package com.sapient.ibench.inventory;

import com.sapient.ibench.inventory.InventoryIBench;
import com.sapient.ibench.inventory.InventoryTrash;
import com.sapient.ibench.inventory.SlotIBench;
import com.sapient.ibench.inventory.SlotIBenchCrafting;
import com.sapient.ibench.inventory.SlotTrash;
import com.sapient.ibench.items.ItemIBench;
import com.sapient.ibench.util.NBTHelper;
import com.sapient.ibench.util.StackHelper;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import invtweaks.api.container.ContainerSection;
import invtweaks.api.container.ContainerSectionCallback;
import invtweaks.api.container.InventoryContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.world.World;

@InventoryContainer
@Optional.Interface(iface="codechicken.nei.invtweaks.INEIGuiHandler", modid="NotEnoughItems")
public class iBenchContainer
extends Container {
    private final EntityPlayer player;
    private final World world;
    public InventoryIBench craftingMatrix;
    public InventoryCraftResult craftingResult;
    public InventoryTrash inventoryTrash;

    public iBenchContainer(EntityPlayer player, InventoryIBench iBenchInventory) {
        this.player = player;
        this.world = player.field_70170_p;
        this.craftingMatrix = iBenchInventory;
        this.craftingMatrix.setEventHandler(this);
        this.craftingResult = new InventoryCraftResult();
        this.inventoryTrash = new InventoryTrash();
        this.func_75146_a((Slot)new SlotIBenchCrafting(player, this.craftingMatrix, (IInventory)this.craftingResult, 0, 136, 35));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.func_75146_a(new SlotIBench(player, this.craftingMatrix, j + i * 3, 42 + j * 18, 17 + i * 18));
            }
        }
        this.bindPlayerInventory(player.field_71071_by);
        this.func_75146_a(new SlotTrash(this.inventoryTrash, 0, 191, 58));
        this.func_75130_a((IInventory)this.craftingMatrix);
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, j + i * 9 + 9, 20 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, i, 20 + i * 18, 142));
        }
    }

    public void func_75130_a(IInventory p_75130_1_) {
        this.craftingResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a((InventoryCrafting)this.craftingMatrix, this.world));
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            this.craftingMatrix.onGuiSaved(player);
        }
    }

    public ItemStack func_75144_a(int slotIndex, int par2, int par3, EntityPlayer entityPlayer) {
        ItemStack clickedStack;
        if (slotIndex >= 0 && slotIndex <= this.field_75153_a.size() && (clickedStack = (ItemStack)this.field_75153_a.get(slotIndex)) != null && clickedStack.func_77973_b() instanceof ItemIBench && NBTHelper.hasUUID(clickedStack) && NBTHelper.getUUID(clickedStack).equals(NBTHelper.getUUID(this.craftingMatrix.parent))) {
            return null;
        }
        return super.func_75144_a(slotIndex, par2, par3, entityPlayer);
    }

    public ItemStack func_82846_b(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack itemStack = null;
        Slot fromSlot = (Slot)this.field_75151_b.get(slotIndex);
        if (fromSlot != null && fromSlot.func_75216_d()) {
            ItemStack itemStack1 = fromSlot.func_75211_c();
            itemStack = itemStack1.func_77946_l();
            if (slotIndex == 0) {
                if (!this.func_75135_a(itemStack1, 10, 46, false)) {
                    return null;
                }
                fromSlot.func_75220_a(itemStack1, itemStack);
            } else if (slotIndex >= 1 && slotIndex <= 9) {
                if (!this.func_75135_a(itemStack1, 10, 46, false)) {
                    fromSlot.func_75218_e();
                    return null;
                }
            } else if (slotIndex >= 10 && slotIndex < 46 && !this.func_75135_a(itemStack1, 1, 10, false)) {
                return null;
            }
            if (itemStack1.field_77994_a == 0) {
                fromSlot.func_75215_d((ItemStack)null);
            } else {
                fromSlot.func_75218_e();
            }
            if (itemStack.field_77994_a == itemStack1.field_77994_a) {
                return null;
            }
            fromSlot.func_82870_a(this.player, itemStack1);
        }
        return itemStack;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public boolean func_75145_c(EntityPlayer player) {
        return true;
    }

    public void balanceMatrix() {
        boolean[] balancedSlots = new boolean[9];
        for (int i = 0; i < 9; ++i) {
            ItemStack currentStack = this.craftingMatrix.func_70301_a(i);
            ArrayList<Integer> matchingSlotIndexes = new ArrayList<Integer>();
            if (balancedSlots[i] || currentStack == null || !currentStack.func_77985_e()) continue;
            int matchingStacks = 1;
            int totalItems = currentStack.field_77994_a;
            matchingSlotIndexes.add(i);
            for (int j = i + 1; j < 9; ++j) {
                ItemStack tStack = this.craftingMatrix.func_70301_a(j);
                if (tStack == null || !StackHelper.stacksMatch(currentStack, tStack)) continue;
                matchingSlotIndexes.add(j);
                ++matchingStacks;
                totalItems += tStack.field_77994_a;
                balancedSlots[j] = true;
            }
            int balancedItemSize = totalItems / matchingStacks;
            int remainingItemSize = totalItems % matchingStacks;
            for (Integer index : matchingSlotIndexes) {
                this.craftingMatrix.func_70301_a((int)index.intValue()).field_77994_a = balancedItemSize;
                if (remainingItemSize <= 0) continue;
                ++this.craftingMatrix.func_70301_a((int)index.intValue()).field_77994_a;
                --remainingItemSize;
            }
            balancedSlots[i] = true;
        }
    }

    public void spinMatrix() {
        this.spinMatrix(false);
    }

    public void spinMatrix(boolean reverse) {
        ArrayList<ItemStack> tempStacks = new ArrayList<ItemStack>(9);
        for (int i = 0; i < 9; ++i) {
            tempStacks.add(this.craftingMatrix.func_70301_a(i));
        }
        int[] original = new int[]{0, 1, 2, 3, 5, 6, 7, 8};
        int[] rotated = !reverse ? new int[]{3, 0, 1, 6, 2, 7, 8, 5} : new int[]{1, 2, 5, 0, 8, 3, 6, 7};
        for (int i = 0; i < original.length; ++i) {
            this.craftingMatrix.func_70299_a(original[i], (ItemStack)tempStacks.get(rotated[i]));
        }
    }

    public void clearMatrix() {
        for (int i = 1; i <= 9; ++i) {
            this.func_82846_b(this.player, i);
        }
    }

    @ContainerSectionCallback
    @SideOnly(value=Side.CLIENT)
    public Map<ContainerSection, List<Slot>> getContainerSections() {
        HashMap<ContainerSection, List<Slot>> map = new HashMap<ContainerSection, List<Slot>>();
        map.put(ContainerSection.INVENTORY, this.field_75151_b.subList(10, 46));
        return map;
    }
}

