/*
 * Decompiled with CFR 0.152.
 */
package net.hegedus.binocular.renderer;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hegedus.binocular.Binocular;
import net.hegedus.binocular.items.BinocularItem;
import net.hegedus.binocular.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiOverlay
extends Gui {
    private Minecraft mc;
    private FontRenderer font;
    private double ovWidth;
    private double ovHeight;
    private double ovChangeRatio;
    private static final List<RenderGameOverlayEvent.ElementType> BLOCKED_ELEMENT_TYPES = Arrays.asList(RenderGameOverlayEvent.ElementType.ARMOR, RenderGameOverlayEvent.ElementType.EXPERIENCE, RenderGameOverlayEvent.ElementType.FOOD, RenderGameOverlayEvent.ElementType.HEALTH, RenderGameOverlayEvent.ElementType.HEALTHMOUNT, RenderGameOverlayEvent.ElementType.AIR);

    public GuiOverlay(Minecraft mc) {
        this.mc = mc;
        this.font = this.mc.field_71466_p;
        this.mc.field_71460_t.func_78478_c();
    }

    @SubscribeEvent
    public void renderScreen(RenderGameOverlayEvent.Post event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        try {
            Utils.initConfig();
            boolean bShowOverlay = ((BinocularItem)Binocular.itemBinocular).isUsing();
            if (!bShowOverlay && this.mc.field_71439_g.func_71011_bu() != null && this.mc.field_71439_g.func_71011_bu().func_77973_b() == Binocular.itemBinocular) {
                bShowOverlay = true;
            }
            if (!bShowOverlay) {
                bShowOverlay = this.getZoomLock();
            }
            if (bShowOverlay) {
                this.init();
                this.overlay();
                this.infos();
                this.compass();
            } else {
                ((BinocularItem)Binocular.itemBinocular).resetUse();
                if (((BinocularItem)Binocular.itemBinocular).quickInfo) {
                    this.showQuickInfo();
                }
            }
        }
        catch (Exception e) {
            System.out.println("renderScreen: " + e.getMessage());
        }
    }

    private String compass() {
        String direction = "";
        try {
            int yaw = (int)this.mc.field_71439_g.field_70177_z;
            if (yaw < 0) {
                yaw += 360;
            }
            int facing = (yaw %= 360) / 45;
            String irany = "";
            switch (facing) {
                case 7: {
                    irany = StatCollector.func_74838_a((String)"direction.se");
                    break;
                }
                case 0: {
                    irany = StatCollector.func_74838_a((String)"direction.s");
                    break;
                }
                case 1: {
                    irany = StatCollector.func_74838_a((String)"direction.sw");
                    break;
                }
                case 2: {
                    irany = StatCollector.func_74838_a((String)"direction.w");
                    break;
                }
                case 3: {
                    irany = StatCollector.func_74838_a((String)"direction.nw");
                    break;
                }
                case 4: {
                    irany = StatCollector.func_74838_a((String)"direction.n");
                    break;
                }
                case 5: {
                    irany = StatCollector.func_74838_a((String)"direction.ne");
                    break;
                }
                case 6: {
                    irany = StatCollector.func_74838_a((String)"direction.e");
                }
            }
            direction = irany;
        }
        catch (Exception e) {
            System.out.println("compass: " + e.getMessage());
        }
        return direction;
    }

    private boolean getZoomLock() {
        boolean bRet = false;
        try {
            InventoryPlayer inventory = this.mc.field_71439_g.field_71071_by;
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack curStack = inventory.func_70301_a(i);
                if (curStack == null || !(curStack.func_77973_b() instanceof BinocularItem)) continue;
                bRet = ((BinocularItem)curStack.func_77973_b()).zoomLocked;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bRet;
    }

    protected String getTime() {
        String time = "";
        try {
            for (int j = 0; j < MinecraftServer.func_71276_C().field_71305_c.length; ++j) {
                time = StringUtils.func_76337_a((int)((int)MinecraftServer.func_71276_C().field_71305_c[j].func_72820_D()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return time;
    }

    public static String formatTime(Long time) {
        int hours24 = (int)(time / 1000L + 6L) % 24;
        int hours = hours24 % 12;
        int minutes = (int)((float)time.longValue() / 16.666666f % 60.0f);
        String Time = String.format("%02d:%02d %s", hours < 1 ? 12 : hours, minutes, hours24 < 12 ? "AM" : "PM");
        return Time;
    }

    private void text(String text, int x, int y, int color) {
        this.font.func_78261_a(text, x, y, color);
    }

    private void scaledText(String text, float sizePercent, int x, int y, int color) {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        if (scaledresolution.func_78325_e() == 1) {
            sizePercent = 1.0f;
        }
        float sizeFactor = 1.0f / sizePercent;
        int new_x = (int)((float)x * sizeFactor);
        int new_y = (int)((float)y * sizeFactor);
        GL11.glPushMatrix();
        GL11.glScalef((float)sizePercent, (float)sizePercent, (float)sizePercent);
        this.text(text, new_x, new_y, color);
        GL11.glPopMatrix();
    }

    private void init() {
        ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        double ovRatioX = 1.6;
        double ovRatioY = 4.26;
        this.ovWidth = (double)this.mc.field_71443_c / ovRatioX;
        this.ovChangeRatio = 640.0 / this.ovWidth;
        this.ovHeight = 240.0 / this.ovChangeRatio;
        if (scaledHeight > scaledWidth) {
            this.ovHeight = (double)this.mc.field_71440_d / ovRatioY;
            this.ovChangeRatio = 240.0 / this.ovHeight;
            this.ovWidth = 640.0 / this.ovChangeRatio;
        }
    }

    private void showQuickInfo() {
        String sElementName;
        String sInfo = "";
        try {
            Long time = this.mc.field_71441_e.field_73011_w.getWorldTime();
            sInfo = GuiOverlay.formatTime(time);
        }
        catch (Exception time) {
            // empty catch block
        }
        String sCompass = this.compass();
        if (sCompass != "") {
            sInfo = sInfo + ", " + sCompass;
        }
        if ((sElementName = this.getElementName()) != "") {
            sInfo = sInfo + " " + sElementName;
        }
        this.scaledText(sInfo, 0.75f, 5, 5, Color.white.getRGB());
    }

    private void infos() {
        this.mc.field_71460_t.func_78478_c();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int scaleFactor = scaledresolution.func_78325_e();
        int centerX = scaledWidth / 2;
        int centerY = scaledHeight / 2;
        DecimalFormat dfPos = new DecimalFormat("0.0000");
        DecimalFormat dfDist = new DecimalFormat("0.##");
        DecimalFormat df2 = new DecimalFormat("0.00");
        double dist = 0.0;
        this.scaledText(StatCollector.func_74838_a((String)"zoom.in") + ": F", 0.75f, 10, 10, Color.white.getRGB());
        this.scaledText(StatCollector.func_74838_a((String)"zoom.out") + ": V", 0.75f, 10, 20, Color.white.getRGB());
        this.scaledText(StatCollector.func_74838_a((String)"zoom.reset") + ": R", 0.75f, 10, 30, Color.white.getRGB());
        this.scaledText(StatCollector.func_74838_a((String)"zoom.lock") + ": L", 0.75f, 10, 40, Color.white.getRGB());
        this.scaledText(StatCollector.func_74838_a((String)"zoom.nightvision") + ": N", 0.75f, 10, 50, Color.white.getRGB());
        this.scaledText(StatCollector.func_74838_a((String)"zoom.waypoints") + ": P", 0.75f, 10, 60, Color.white.getRGB());
        this.scaledText(StatCollector.func_74838_a((String)"zoom.quickInfo") + ": I", 0.75f, 10, 70, Color.white.getRGB());
        int zoomOfsX = 88;
        int zoomOfsY = 94;
        int distOfsX = 37;
        int distOfsY = 94;
        int timeOfsX = 298;
        int timeOfsY = 105;
        int locOfsX = 15;
        int locOfsY = 15;
        int icoOfsX = 120;
        int icoOfsY = 40;
        int entOfsX = 20;
        int entOfsY = 30;
        int destOfsX = 75;
        int destOfsY = 40;
        int destCOfsY = 20;
        if (scaleFactor > 2) {
            zoomOfsX -= 2;
            distOfsX += 3;
            icoOfsX = 180;
            icoOfsY = 60;
            destOfsX = 120;
            destOfsY = 55;
            destCOfsY = 25;
        }
        if (scaleFactor == 4) {
            icoOfsX = 240;
            icoOfsY = 70;
            destOfsX = 150;
            destOfsY = 60;
            destCOfsY = 30;
        }
        double zoomPosX = (double)zoomOfsX / this.ovChangeRatio / (double)scaleFactor;
        double zoomPosY = (double)zoomOfsY / this.ovChangeRatio / (double)scaleFactor;
        double distPosX = (double)distOfsX / this.ovChangeRatio / (double)scaleFactor;
        double distPosY = (double)distOfsY / this.ovChangeRatio / (double)scaleFactor;
        double timePosX = (double)timeOfsX / this.ovChangeRatio / (double)scaleFactor;
        double timePosY = (double)timeOfsY / this.ovChangeRatio / (double)scaleFactor;
        double locPosX = (double)centerX - (this.ovWidth / 2.0 - (double)locOfsX) / (double)scaleFactor;
        double locPosY = (double)centerY + (this.ovHeight / 2.0 + (double)locOfsY) / (double)scaleFactor;
        double icoPosX = centerX - icoOfsX / scaleFactor;
        double icoPosY = (double)centerY - (this.ovHeight / 2.0 + (double)icoOfsY) / (double)scaleFactor;
        double destPosX = centerX - destOfsX / scaleFactor;
        double destPosY = (double)centerY - (this.ovHeight / 2.0 + (double)destOfsY) / (double)scaleFactor;
        double destCPosY = (double)centerY - (this.ovHeight / 2.0 + (double)destOfsY - (double)destCOfsY) / (double)scaleFactor;
        double compassPosX = (int)((double)centerX - timePosX);
        double compassPosY = destCPosY;
        double px = this.mc.field_71439_g.func_70666_h((float)0.0f).field_72450_a;
        double py = this.mc.field_71439_g.func_70666_h((float)0.0f).field_72448_b;
        double pz = this.mc.field_71439_g.func_70666_h((float)0.0f).field_72449_c;
        String sPos = "x: " + dfPos.format(px) + ", y: " + dfPos.format(py) + ", z: " + dfPos.format(pz);
        this.scaledText(sPos, 0.75f, (int)locPosX, (int)locPosY, Color.white.getRGB());
        try {
            Long time = this.mc.field_71441_e.field_73011_w.getWorldTime();
            this.scaledText(GuiOverlay.formatTime(time), 0.75f, (int)((double)centerX - timePosX), (int)((double)centerY - timePosY), Color.white.getRGB());
        }
        catch (Exception time) {
            // empty catch block
        }
        String dir = this.compass();
        this.scaledText(dir, 0.75f, (int)compassPosX, (int)compassPosY, Color.white.getRGB());
        String sElementName = "";
        String sElementPos = "";
        String sElementInfo = "";
        try {
            MovingObjectPosition mop = this.mc.field_71451_h.func_70614_a(200.0, 1.0f);
            if (mop != null) {
                EntityLivingBase entity;
                int blockHitSide = mop.field_72310_e;
                Block block = this.mc.field_71439_g.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                sElementPos = "x: " + dfPos.format(mop.field_72311_b) + ", y: " + dfPos.format(mop.field_72312_c) + ", z: " + dfPos.format(mop.field_72309_d);
                double dx = (double)mop.field_72311_b - px;
                double dy = (double)mop.field_72312_c - py;
                double dz = (double)mop.field_72309_d - pz;
                dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                sElementName = block.func_149732_F();
                if (sElementName.endsWith(".name")) {
                    sElementName = block.func_149739_a().substring(block.func_149739_a().indexOf(".") + 1);
                }
                if ((entity = GuiOverlay.GetEntityLookAt((EntityPlayer)this.mc.field_71439_g, (int)dist + 10)) != null) {
                    sElementPos = "x: " + dfPos.format(entity.field_70165_t) + ", y: " + dfPos.format(entity.field_70163_u) + ", z: " + dfPos.format(entity.field_70161_v);
                    sElementInfo = " \u00a77(\u00a7a" + Integer.toString((int)entity.func_110138_aP()) + "\u00a77" + "/" + "\u00a7a" + Integer.toString((int)entity.func_110143_aJ()) + "\u00a77" + ")";
                    sElementName = entity.toString();
                    if (sElementName.indexOf("['") > -1 && (sElementName = sElementName.substring(sElementName.indexOf("['") + 2)).indexOf("'") > -1) {
                        sElementName = sElementName.substring(0, sElementName.indexOf("'"));
                    }
                    GL11.glPushAttrib((int)1048575);
                    GL11.glPushMatrix();
                    RenderLiving renderLiving = (RenderLiving)RenderManager.field_78727_a.func_78715_a(entity.getClass());
                    GL11.glTranslatef((float)((int)icoPosX + entOfsX), (float)((int)icoPosY + entOfsY), (float)0.0f);
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glScaled((double)25.0, (double)25.0, (double)25.0);
                    GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
                    renderLiving.func_76986_a(entity, 1.0, 1.0, 1.0, 0.0f, 0.0f);
                    GL11.glPopMatrix();
                    GL11.glPopAttrib();
                    sElementName = sElementName + sElementInfo;
                } else {
                    IIcon icon = block.func_149691_a(0, 0);
                    if (icon != null) {
                        GL11.glPushMatrix();
                        this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                        this.func_94065_a((int)icoPosX, (int)icoPosY, icon, 16, 16);
                        GL11.glPopMatrix();
                    }
                }
                this.scaledText(sElementName, 0.75f, (int)destPosX, (int)destPosY, Color.yellow.getRGB());
                this.scaledText(sElementPos, 0.75f, (int)destPosX, (int)destCPosY, Color.white.getRGB());
            }
        }
        catch (Exception mop) {
            // empty catch block
        }
        String sDistance = (dist < 5.0 ? "< 5" : dfDist.format(dist)) + "m";
        this.scaledText(sDistance, 0.75f, (int)((double)centerX + distPosX), (int)((double)centerY + distPosY), Color.green.getRGB());
        float zoomFactor = ((BinocularItem)Binocular.itemBinocular).zoomFactor;
        zoomFactor = 100.0f - zoomFactor * 100.0f;
        this.scaledText(dfDist.format(zoomFactor), 0.75f, (int)((double)centerX - zoomPosX), (int)((double)centerY + zoomPosY), Color.green.getRGB());
    }

    private String getElementName() {
        String sElementName = "";
        String sElementInfo = "";
        double dist = 0.0;
        DecimalFormat dfDist = new DecimalFormat("0.##");
        try {
            MovingObjectPosition mop = this.mc.field_71451_h.func_70614_a(200.0, 1.0f);
            if (mop != null) {
                EntityLivingBase entity;
                Block block = this.mc.field_71439_g.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                double px = this.mc.field_71439_g.func_70666_h((float)0.0f).field_72450_a;
                double py = this.mc.field_71439_g.func_70666_h((float)0.0f).field_72448_b;
                double pz = this.mc.field_71439_g.func_70666_h((float)0.0f).field_72449_c;
                double dx = (double)mop.field_72311_b - px;
                double dy = (double)mop.field_72312_c - py;
                double dz = (double)mop.field_72309_d - pz;
                dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
                sElementName = block.func_149732_F();
                if (sElementName.endsWith(".name")) {
                    sElementName = block.func_149739_a().substring(block.func_149739_a().indexOf(".") + 1);
                }
                if ((entity = GuiOverlay.GetEntityLookAt((EntityPlayer)this.mc.field_71439_g, (int)dist + 10)) != null) {
                    sElementInfo = " \u00a77(\u00a7a" + Integer.toString((int)entity.func_110138_aP()) + "\u00a77" + "/" + "\u00a7a" + Integer.toString((int)entity.func_110143_aJ()) + "\u00a77" + ")";
                    sElementName = entity.toString();
                    if (sElementName.indexOf("['") > -1 && (sElementName = sElementName.substring(sElementName.indexOf("['") + 2)).indexOf("'") > -1) {
                        sElementName = sElementName.substring(0, sElementName.indexOf("'"));
                    }
                    sElementName = "\u00a7c" + sElementName + sElementInfo;
                } else {
                    sElementName = "\u00a76" + sElementName;
                }
                String sDistance = (dist < 5.0 ? "< 5" : dfDist.format(dist)) + "m";
                sElementName = sElementName + "\u00a7f " + sDistance;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sElementName;
    }

    public static List GetNearEntityWithPlayer(EntityLivingBase player, int range, boolean needToBeSeen) {
        double px = player.field_70165_t;
        double py = player.field_70163_u;
        double pz = player.field_70161_v;
        List l = player.field_70170_p.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(px - (double)range), (double)(py - (double)range), (double)(pz - (double)range), (double)(px + (double)range), (double)(py + (double)range), (double)(pz + (double)range)));
        ArrayList<EntityLivingBase> result = new ArrayList<EntityLivingBase>();
        for (int i = 0; i < l.size(); ++i) {
            EntityLivingBase x = (EntityLivingBase)l.get(i);
            if (x == null || !(x.func_70032_d((Entity)player) <= (float)range) || needToBeSeen && !x.func_70685_l((Entity)player)) continue;
            result.add(x);
        }
        return result;
    }

    public static EntityLivingBase GetEntityLookAt(EntityPlayer player, int max_dis) {
        try {
            List list = GuiOverlay.GetNearEntityWithPlayer((EntityLivingBase)player, max_dis, true);
            for (EntityLivingBase obj : list) {
                Vec3 vec3 = player.func_70676_i(1.0f).func_72432_b();
                Vec3 vec31 = Vec3.func_72443_a((double)(obj.field_70165_t - player.field_70165_t), (double)(obj.field_70121_D.field_72338_b + (double)(obj.field_70131_O / 2.0f) - (player.field_70163_u + (double)player.func_70047_e())), (double)(obj.field_70161_v - player.field_70161_v));
                double d0 = vec31.func_72433_c();
                double d1 = vec3.func_72430_b(vec31 = vec31.func_72432_b());
                if (!(d1 > 1.0 - 0.025 / d0) || !player.func_70685_l((Entity)obj)) continue;
                return obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void overlay() {
        this.mc.field_71460_t.func_78478_c();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        int scaledWidth = scaledresolution.func_78326_a();
        int scaledHeight = scaledresolution.func_78328_b();
        int scaleFactor = scaledresolution.func_78325_e();
        int centerX = scaledWidth / 2;
        int centerY = scaledHeight / 2;
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        ResourceLocation texture = new ResourceLocation("binocular", "textures/items/BinocularBlur.png");
        this.mc.func_110434_K().func_110577_a(texture);
        boolean isHorizontal = true;
        double aspect_ratio = 1.0;
        int w = scaledWidth;
        int h = scaledWidth;
        int ofs_x = 0;
        int ofs_y = 0;
        if (h < scaledHeight) {
            h = scaledHeight;
            w = (int)((double)scaledHeight * aspect_ratio);
            isHorizontal = false;
        }
        if (w > scaledWidth) {
            ofs_x = (w - scaledWidth) / 2;
        }
        if (h > scaledHeight) {
            ofs_y = (h - scaledHeight) / 2;
        }
        int tl_x = 0 - ofs_x;
        int tl_y = 0 - ofs_y;
        int bl_x = 0 - ofs_x;
        int bl_y = h - ofs_y;
        int br_x = w - ofs_x;
        int br_y = h - ofs_y;
        int tr_x = w - ofs_x;
        int tr_y = 0 - ofs_y;
        Tessellator t = Tessellator.field_78398_a;
        t.func_78382_b();
        t.func_78374_a((double)tl_x, (double)tl_y, 0.0, 0.0, 0.0);
        t.func_78374_a((double)bl_x, (double)bl_y, 0.0, 0.0, 1.0);
        t.func_78374_a((double)br_x, (double)br_y, 0.0, 1.0, 1.0);
        t.func_78374_a((double)tr_x, (double)tr_y, 0.0, 1.0, 0.0);
        t.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }
}

