/*
 * Decompiled with CFR 0.152.
 */
package net.hegedus.binocular.playerinfo;

import java.util.ArrayList;
import net.hegedus.binocular.proxy.CommonProxy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerInformation
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "binocular_ExtendedPlayer";
    public static final String EXT_PROP_NAMES = "binocular_ExtendedPlayerNameList";
    public static final String EXT_TAG_NAMES = "binocular_ExtendedPlayerNameTag";
    public static final String EXT_PROP_COORDS = "binocular_ExtendedPlayerCoordList";
    public static final String EXT_TAG_COORDS = "binocular_ExtendedPlayerCoordTag";
    private final EntityPlayer player;
    private ArrayList<String> nameList;
    private ArrayList<String> coordList;
    public boolean dirty = true;

    public PlayerInformation(EntityPlayer player, ArrayList<String> nameList, ArrayList<String> coordList) {
        this.player = player;
        this.nameList = nameList;
        this.coordList = coordList;
    }

    public static final void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new PlayerInformation(player, new ArrayList<String>(), new ArrayList<String>()));
    }

    public static final PlayerInformation get(Entity player) {
        return (PlayerInformation)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void init(Entity entity, World world) {
    }

    public static final String getSaveKey(EntityPlayer player) {
        return player.func_70005_c_() + ":" + EXT_PROP_NAME;
    }

    public static void saveProxyData(EntityPlayer player) {
        System.out.println("-----> saveProxyData...");
        try {
            PlayerInformation playerData = PlayerInformation.get((Entity)player);
            NBTTagCompound savedData = new NBTTagCompound();
            playerData.saveNBTData(savedData);
            CommonProxy.storeEntityData(PlayerInformation.getSaveKey(player), savedData);
        }
        catch (Exception e) {
            System.out.println("saveProxyData: " + e.getMessage());
        }
    }

    public static void loadProxyData(EntityPlayer player) {
        System.out.println("-----> loadProxyData...");
        try {
            PlayerInformation playerData = PlayerInformation.get((Entity)player);
            NBTTagCompound savedData = CommonProxy.getEntityData(PlayerInformation.getSaveKey(player));
            if (savedData != null) {
                playerData.loadNBTData(savedData);
                System.out.println("  list size: " + Integer.toString(playerData.getCount()));
            } else {
                System.out.println("  savedData is NULL");
            }
        }
        catch (Exception e) {
            System.out.println("loadProxyData: " + e.getMessage());
        }
    }

    public void saveNBTData(NBTTagCompound compound) {
        System.out.println("-----> saveNBTData: " + Integer.toString(this.nameList.size()));
        try {
            NBTTagList tagList = new NBTTagList();
            for (int i = 0; i < this.nameList.size(); ++i) {
                String s = this.nameList.get(i);
                if (s == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74778_a(EXT_TAG_NAMES + i, s);
                tagList.func_74742_a((NBTBase)tag);
            }
            compound.func_74782_a(EXT_PROP_NAMES, (NBTBase)tagList);
        }
        catch (Exception e) {
            System.out.println("saveNBTData: " + e.getMessage());
        }
    }

    public void loadNBTData(NBTTagCompound compound) {
        try {
            NBTTagList tagList = compound.func_150295_c(EXT_PROP_NAMES, 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                String s = tag.func_74779_i(EXT_TAG_NAMES + i);
                this.nameList.add(i, s);
            }
            System.out.println("-----> loadNBTData: " + Integer.toString(this.nameList.size()));
        }
        catch (Exception e) {
            System.out.println("loadNBTData: " + e.getMessage());
        }
    }

    public void addItem(String sName, String sCoord) {
        this.nameList.add(sName);
        this.coordList.add(sCoord);
    }

    public void setItem(int iIndex, String sName, String sCoord) {
        this.nameList.set(iIndex - 1, sName);
        this.coordList.set(iIndex - 1, sCoord);
    }

    public void delItem(int iIndex) {
        this.nameList.remove(iIndex - 1);
        this.coordList.remove(iIndex - 1);
    }

    public String getItemName(int iIndex) {
        String ret = "";
        if (this.nameList.size() > iIndex) {
            ret = this.nameList.get(iIndex);
        }
        return ret;
    }

    public String getItemCoord(int iIndex) {
        String ret = "";
        if (this.coordList.size() > iIndex) {
            ret = this.coordList.get(iIndex);
        }
        return ret;
    }

    public int getCount() {
        return this.nameList.size();
    }
}

