/*
 * Decompiled with CFR 0.152.
 */
package net.hegedus.binocular.renderer;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.awt.Color;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import net.hegedus.binocular.Binocular;
import net.hegedus.binocular.items.BinocularItem;
import net.hegedus.binocular.renderer.GuiList;
import net.hegedus.binocular.renderer.GuiSlotList;
import net.hegedus.binocular.util.DrawUtils;
import net.hegedus.binocular.util.TeleportMessage;
import net.hegedus.binocular.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import org.lwjgl.opengl.GL11;

public class GuiOverlayScreen
extends GuiScreen
implements GuiList.IGuiList {
    public Minecraft field_146297_k;
    private BinocularItem tavcso;
    protected GuiSlotList list;
    private GuiList waypointList;
    private ArrayList<String> nameList = new ArrayList();
    private ArrayList<String> coordList = new ArrayList();
    private int selectedIndex = 0;
    private GuiButton btAdd;
    private GuiButton btSet;
    private GuiButton btDel;
    private GuiButton btGo;
    private GuiTextField txtName;
    private GuiTextField txtCoord;
    private int iBgWidth = 240;
    private int iBgHeight = 155;
    private int iBgX = 0;
    private int iBgY = 0;
    private int iScrollPadding = 5;
    private int iScrollX = 0;
    private int iScrollY = 0;
    private int iScrollW = 0;
    private int iScrollH = 0;
    private int iScrollBarW = 10;
    private int iScrollBarX = 0;
    private int iScrollBarY = 0;
    private int iScrollButtonOffset = 0;
    private int iScrollButtonPrev = 0;
    private boolean bScrollButtonPressed = false;
    private int iScrollListOffset = 0;
    private int iElementHeight = 14;
    private int iElementPadding = 5;
    private int iNameX = 0;
    private int iNameY = 0;
    private int iCoordX = 0;
    private int iCoordY = 0;
    private int iTxtWidth = this.iBgWidth - 10;
    private int iTxtHeight = 12;
    private int iBtWidth = 45;
    private int iBtHeight = 20;
    private int iBtCoordTop = 0;
    private int iBtCoord1Left = 0;
    private int iBtCoord2Left = 0;
    private int iBtCoordWidth = 12;
    private int iBtCoordHeight = this.iTxtHeight + 3;
    private int iTxtCoordWidth = this.iTxtWidth - 2 * (this.iBtCoordWidth + 5);
    private int iBtCoord1Bg = 0;
    private int iBtCoord2Bg = 0;
    private int iBtX = 0;
    private int iBtY = 0;
    private int iInfoX = 0;
    private int iInfoY = 0;
    private GuiTextField activeTextField;

    public GuiOverlayScreen(Minecraft mc) {
        this.field_146297_k = mc;
        DrawUtils.setResolution(new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d));
        DrawUtils.setFontRenderer(this.field_146297_k.field_71466_p);
    }

    private String getPos(int iType) {
        DecimalFormatSymbols decimalSymbol = new DecimalFormatSymbols(Locale.getDefault());
        decimalSymbol.setDecimalSeparator('.');
        NumberFormat fmt = NumberFormat.getInstance(Locale.US);
        fmt.setGroupingUsed(false);
        if (fmt instanceof DecimalFormat) {
            ((DecimalFormat)fmt).applyPattern("0.0000");
        }
        DecimalFormat dfPos = new DecimalFormat("0.0000");
        String sPos = "";
        if (iType == 1) {
            double px = this.field_146297_k.field_71439_g.func_70666_h((float)0.0f).field_72450_a;
            double py = this.field_146297_k.field_71439_g.func_70666_h((float)0.0f).field_72448_b;
            double pz = this.field_146297_k.field_71439_g.func_70666_h((float)0.0f).field_72449_c;
            sPos = fmt.format(px) + " " + fmt.format(py) + " " + fmt.format(pz);
        } else {
            MovingObjectPosition mop = this.field_146297_k.field_71451_h.func_70614_a(200.0, 1.0f);
            if (mop != null) {
                sPos = fmt.format(mop.field_72311_b) + " " + fmt.format(mop.field_72312_c) + " " + fmt.format(mop.field_72309_d);
            }
        }
        return sPos;
    }

    public void func_73866_w_() {
        this.initCalc();
        this.txtName = new GuiTextField(this.field_146297_k.field_71466_p, this.iNameX, this.iNameY, this.iTxtWidth, this.iTxtHeight);
        this.txtName.func_146195_b(false);
        this.txtName.func_146203_f(40);
        this.txtName.func_146180_a("name");
        this.txtName.func_146185_a(true);
        this.txtCoord = new GuiTextField(this.field_146297_k.field_71466_p, this.iCoordX, this.iCoordY, this.iTxtCoordWidth, this.iTxtHeight);
        this.txtCoord.func_146195_b(false);
        this.txtCoord.func_146203_f(40);
        this.txtCoord.func_146180_a(this.getPos(1));
        this.txtCoord.func_146185_a(true);
        this.btAdd = new GuiButton(1, this.iBtX, this.iBtY, this.iBtWidth, this.iBtHeight, "Add");
        this.iBtY += this.btAdd.field_146121_g + 5;
        this.btSet = new GuiButton(2, this.iBtX, this.iBtY, this.iBtWidth, this.iBtHeight, "Set");
        this.iBtY += this.btAdd.field_146121_g + 5;
        this.btDel = new GuiButton(3, this.iBtX, this.iBtY, this.iBtWidth, this.iBtHeight, "Remove");
        this.iBtY += this.btAdd.field_146121_g + 5;
        this.btGo = new GuiButton(4, this.iBtX, this.iBtY, this.iBtWidth, this.iBtHeight, "Go");
        this.field_146292_n.clear();
        this.field_146292_n.add(this.btAdd);
        this.field_146292_n.add(this.btSet);
        this.field_146292_n.add(this.btDel);
        this.field_146292_n.add(this.btGo);
        this.loadConfig();
    }

    private void loadConfig() {
        String[] names = Binocular.config.get("WayPoints", "namesList", new String[0]).getStringList();
        String[] coords = Binocular.config.get("WayPoints", "coordsList", new String[0]).getStringList();
        this.nameList = new ArrayList<String>(Arrays.asList(names));
        this.coordList = new ArrayList<String>(Arrays.asList(coords));
        System.out.println("---------> CONFIG LOAD: " + Integer.toString(names.length));
    }

    private void saveConfig() {
        String[] names = this.nameList.toArray(new String[this.nameList.size()]);
        String[] coords = this.coordList.toArray(new String[this.coordList.size()]);
        Binocular.config.get("WayPoints", "namesList", new String[0]).set(names);
        Binocular.config.get("WayPoints", "coordsList", new String[0]).set(coords);
        Binocular.config.save();
        System.out.println("---------> CONFIG SAVE: " + Integer.toString(names.length));
    }

    public void initCalc() {
        this.iBgX = (this.field_146294_l - this.iBgWidth) / 2;
        this.iBgY = (this.field_146295_m - this.iBgHeight) / 2;
        this.iNameX = this.iBgX + 5;
        this.iNameY = this.iBgY + 5;
        this.iCoordX = this.iBgX + 5;
        this.iCoordY = this.iNameY + this.iTxtHeight + 5;
        this.iBtX = this.iBgX + this.iBgWidth - this.iBtWidth - 5;
        this.iBtY = this.iBgY + 2 * (this.iTxtHeight + 5) + 10;
        this.iScrollX = this.iBgX + this.iScrollPadding;
        this.iScrollY = this.iCoordY + this.iTxtHeight + this.iScrollPadding;
        this.iScrollW = this.iBgWidth - this.iBtWidth - this.iScrollBarW - this.iScrollPadding - 2 * this.iScrollPadding;
        this.iScrollH = this.iBgHeight - (2 * this.iTxtHeight + 10) - 2 * this.iScrollPadding;
        this.iScrollBarX = this.iScrollX + this.iScrollW + 2;
        this.iScrollBarY = this.iScrollY;
        this.iBtCoordTop = this.iCoordY - 1;
        this.iBtCoord1Left = this.iCoordX + this.iTxtCoordWidth + 5;
        this.iBtCoord2Left = this.iBtCoord1Left + this.iBtCoordWidth + 5;
    }

    private int listHeightAbsolute() {
        return this.iElementPadding + this.nameList.size() * (this.iElementHeight + this.iElementPadding);
    }

    private float getScrollButtonSize() {
        float fButtonHeight = 0.0f;
        int iListHeight = this.listHeightAbsolute();
        if (iListHeight > this.iScrollH) {
            float fRatio = (float)iListHeight / (float)this.iScrollH;
            fButtonHeight = (float)this.iScrollH / fRatio;
            if (fRatio < 1.0f) {
                fButtonHeight = 0.0f;
            }
        }
        return fButtonHeight;
    }

    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        if (this.activeTextField != null) {
            this.activeTextField.func_146201_a(c, i);
        }
    }

    public void func_73864_a(int i, int j, int k) {
        super.func_73864_a(i, j, k);
        boolean itemClicked = false;
        this.bScrollButtonPressed = false;
        this.iScrollButtonPrev = 0;
        float fButtonSize = this.getScrollButtonSize();
        if (i >= this.txtName.field_146209_f && i <= this.txtName.field_146209_f + this.txtName.field_146218_h && j >= this.txtName.field_146210_g && j <= this.txtName.field_146210_g + this.txtName.field_146219_i) {
            this.activeTextField = this.txtName;
        } else if (i >= this.txtCoord.field_146209_f && i <= this.txtCoord.field_146209_f + this.txtCoord.field_146218_h && j >= this.txtCoord.field_146210_g && j <= this.txtCoord.field_146210_g + this.txtCoord.field_146219_i) {
            this.activeTextField = this.txtCoord;
        } else if (i >= this.iScrollX && i <= this.iScrollX + this.iScrollW && j >= this.iScrollY && j <= this.iScrollY + this.iScrollH) {
            itemClicked = true;
        } else if (i >= this.iScrollBarX && i <= this.iScrollBarX + this.iScrollBarW && j >= this.iScrollBarY + this.iScrollButtonOffset && j <= this.iScrollBarY + this.iScrollButtonOffset + (int)fButtonSize) {
            this.bScrollButtonPressed = true;
            this.iScrollButtonPrev = j;
            System.out.println("clicked: " + Integer.toString(j));
        } else if (i >= this.iBtCoord1Left && i <= this.iBtCoord1Left + this.iBtCoordWidth && j >= this.iBtCoordTop && j <= this.iBtCoordTop + this.iBtCoordHeight) {
            this.txtCoord.func_146180_a(this.getPos(1));
        } else if (i >= this.iBtCoord2Left && i <= this.iBtCoord2Left + this.iBtCoordWidth && j >= this.iBtCoordTop && j <= this.iBtCoordTop + this.iBtCoordHeight) {
            this.txtCoord.func_146180_a(this.getPos(2));
        }
        if (this.activeTextField != null) {
            this.activeTextField.func_146192_a(i, j, k);
        }
        if (this.activeTextField == this.txtName) {
            this.txtCoord.func_146195_b(false);
        }
        if (this.activeTextField == this.txtCoord) {
            this.txtName.func_146195_b(false);
        }
        this.selectedIndex = this.getActiveItem(i, j);
        if (this.selectedIndex > 0 && itemClicked) {
            this.txtName.func_146180_a(this.nameList.get(this.selectedIndex - 1));
            this.txtCoord.func_146180_a(this.coordList.get(this.selectedIndex - 1));
        }
    }

    public void func_146273_a(int mouseX, int mouseY, int button, long timeSince) {
        int iOffs;
        super.func_146273_a(mouseX, mouseY, button, timeSince);
        if (this.bScrollButtonPressed && (iOffs = mouseY - this.iScrollButtonPrev) != 0) {
            this.iScrollButtonPrev = mouseY;
            int iListOuterSize = 0;
            int iScrollOuterSize = 0;
            int iListOffset = 0;
            if (iOffs > 0) {
                iListOuterSize = this.listHeightAbsolute() - this.iScrollH - this.iScrollListOffset;
                iScrollOuterSize = this.iScrollH - ((int)this.getScrollButtonSize() + this.iScrollButtonOffset);
                iListOffset = iScrollOuterSize > 0 ? (int)(Math.ceil(iListOuterSize / iScrollOuterSize) * (double)iOffs) : 0;
                float fButtonSize = this.getScrollButtonSize();
                this.iScrollButtonOffset = (int)fButtonSize + this.iScrollButtonOffset + iOffs < this.iScrollH ? (this.iScrollButtonOffset += iOffs) : this.iScrollH - (int)fButtonSize;
                this.iScrollListOffset = this.listHeightAbsolute() - (this.iScrollListOffset + iListOffset) > this.iScrollH ? (this.iScrollListOffset += iListOffset) : this.listHeightAbsolute() - this.iScrollH;
            } else {
                iListOuterSize = this.iScrollListOffset;
                iScrollOuterSize = this.iScrollButtonOffset;
                int n = iListOffset = iScrollOuterSize > 0 ? (int)(Math.ceil(iListOuterSize / iScrollOuterSize) * (double)iOffs) : 0;
                this.iScrollButtonOffset = this.iScrollButtonOffset + iOffs >= 0 ? (this.iScrollButtonOffset += iOffs) : 0;
                this.iScrollListOffset = this.iScrollListOffset + iListOffset >= 0 ? (this.iScrollListOffset += iListOffset) : 0;
            }
        }
    }

    public void func_73863_a(int x, int y, float f) {
        this.func_146276_q_();
        GuiOverlayScreen.func_73734_a((int)this.iBgX, (int)this.iBgY, (int)(this.iBgX + this.iBgWidth), (int)(this.iBgY + this.iBgHeight), (int)new Color(50, 170, 170, 70).getRGB());
        this.txtName.func_146194_f();
        this.txtCoord.func_146194_f();
        this.renderList(x, y);
        this.renderScrollBar();
        this.iBtCoord1Bg = new Color(86, 86, 86, 255).getRGB();
        this.iBtCoord2Bg = new Color(86, 86, 86, 255).getRGB();
        if (x >= this.iBtCoord1Left && x <= this.iBtCoord1Left + this.iBtCoordWidth && y >= this.iBtCoordTop && y <= this.iBtCoordTop + this.iBtCoordHeight) {
            this.iBtCoord1Bg = new Color(122, 132, 88, 255).getRGB();
        } else if (x >= this.iBtCoord2Left && x <= this.iBtCoord2Left + this.iBtCoordWidth && y >= this.iBtCoordTop && y <= this.iBtCoordTop + this.iBtCoordHeight) {
            this.iBtCoord2Bg = new Color(122, 132, 88, 255).getRGB();
        }
        this.renderButton(this.iBtCoord1Left, this.iBtCoordTop, this.iBtCoordWidth, this.iBtCoordHeight, this.iBtCoord1Bg, "<");
        this.renderButton(this.iBtCoord2Left, this.iBtCoordTop, this.iBtCoordWidth, this.iBtCoordHeight, this.iBtCoord2Bg, "<<");
        super.func_73863_a(x, y, f);
    }

    public void renderList(int x, int y) {
        ScaledResolution sr = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        int scale = sr.func_78325_e();
        int scissorX = this.iScrollX;
        int scissorY = this.iScrollY;
        int scissorWidth = this.iScrollW;
        int scissorHeight = this.iScrollH;
        DrawUtils.startClip(this.iScrollX, this.field_146297_k.field_71440_d - (scissorY + scissorHeight) * scale, (scissorWidth + scissorX) * scale, scissorHeight * scale);
        int iY = 0;
        for (int i = 0; i < this.nameList.size(); ++i) {
            String o = this.nameList.get(i);
            iY = this.getItemY(i) - this.iScrollListOffset;
            DrawUtils.drawText(o.toString(), this.iScrollX + this.iElementPadding, iY, Color.white.getRGB());
        }
        if (this.selectedIndex > 0) {
            GL11.glEnable((int)3042);
            iY = this.getItemY(this.selectedIndex - 1) - this.iElementPadding;
            GuiOverlayScreen.func_73734_a((int)this.iScrollX, (int)(iY - this.iScrollListOffset), (int)(this.iScrollX + this.iScrollW), (int)(iY + this.iElementHeight + 3 - this.iScrollListOffset), (int)new Color(255, 255, 255, 70).getRGB());
        }
        DrawUtils.endClip();
    }

    public void renderScrollBar() {
        GuiOverlayScreen.func_73734_a((int)this.iScrollBarX, (int)this.iScrollBarY, (int)(this.iScrollBarX + this.iScrollBarW), (int)(this.iScrollBarY + this.iScrollH), (int)new Color(255, 255, 255, 30).getRGB());
        float fButtonSize = this.getScrollButtonSize();
        GuiOverlayScreen.func_73734_a((int)this.iScrollBarX, (int)(this.iScrollBarY + this.iScrollButtonOffset), (int)(this.iScrollBarX + this.iScrollBarW), (int)(this.iScrollBarY + this.iScrollButtonOffset + (int)fButtonSize), (int)new Color(255, 255, 255, 80).getRGB());
    }

    public void renderButton(int iLeft, int iTop, int iWidth, int iHeight, int iBg, String text) {
        GuiOverlayScreen.func_73734_a((int)iLeft, (int)iTop, (int)(iLeft + iWidth - 1), (int)(iTop + 1), (int)new Color(255, 255, 255, 255).getRGB());
        GuiOverlayScreen.func_73734_a((int)iLeft, (int)iTop, (int)(iLeft + 1), (int)(iTop + iHeight), (int)new Color(255, 255, 255, 255).getRGB());
        GuiOverlayScreen.func_73734_a((int)(iLeft + iWidth - 1), (int)iTop, (int)(iLeft + iWidth), (int)(iTop + iHeight), (int)new Color(0, 0, 0, 255).getRGB());
        GuiOverlayScreen.func_73734_a((int)iLeft, (int)(iTop + iHeight - 1), (int)(iLeft + iWidth), (int)(iTop + iHeight), (int)new Color(0, 0, 0, 255).getRGB());
        GuiOverlayScreen.func_73734_a((int)(iLeft + 1), (int)(iTop + 1), (int)(iLeft + iWidth - 1), (int)(iTop + iHeight - 1), (int)iBg);
        DrawUtils.scaledText(text, 0.5f, iLeft + (iWidth - this.field_146297_k.field_71466_p.func_78256_a(text)) / 2 + text.length(), iTop + 6, Color.white.getRGB());
    }

    protected void func_146284_a(GuiButton btn) {
        String[] coord;
        if (btn.field_146127_k == this.btAdd.field_146127_k) {
            this.nameList.add(this.txtName.func_146179_b());
            this.coordList.add(this.txtCoord.func_146179_b());
            this.txtName.func_146180_a("");
            this.txtCoord.func_146180_a("");
            this.saveConfig();
        } else if (btn.field_146127_k == this.btSet.field_146127_k) {
            if (this.selectedIndex > 0) {
                this.nameList.set(this.selectedIndex - 1, this.txtName.func_146179_b());
                this.coordList.set(this.selectedIndex - 1, this.txtCoord.func_146179_b());
                this.saveConfig();
            }
        } else if (btn.field_146127_k == this.btDel.field_146127_k) {
            if (this.selectedIndex > 0) {
                float fButtonSizePrev = this.getScrollButtonSize();
                this.nameList.remove(this.selectedIndex - 1);
                this.coordList.remove(this.selectedIndex - 1);
                this.selectedIndex = -1;
                float fButtonSize = this.getScrollButtonSize();
                int iOffs = (int)(fButtonSizePrev - fButtonSize);
                this.iScrollButtonOffset = this.iScrollButtonOffset + iOffs > 0 ? (this.iScrollButtonOffset += iOffs) : 0;
                this.iScrollListOffset = this.iScrollListOffset - (this.iElementHeight + this.iElementPadding) > 0 ? (this.iScrollListOffset -= this.iElementHeight + this.iElementPadding) : 0;
                this.saveConfig();
            }
        } else if (btn.field_146127_k == this.btGo.field_146127_k && (coord = this.txtCoord.func_146179_b().split(" ")).length == 3) {
            try {
                this.tavcso = Utils.getBinocularItem(this.field_146297_k);
                this.tavcso.zoomLocked = false;
                this.tavcso.resetUse();
                this.field_146297_k.field_71439_g.func_71053_j();
                Binocular.network.sendToServer((IMessage)new TeleportMessage(Double.parseDouble(coord[0]), Double.parseDouble(coord[1]), Double.parseDouble(coord[2])));
            }
            catch (Exception e) {
                System.out.println("TP hiba: " + e.getMessage());
                this.field_146297_k.field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("TP error: " + e.getMessage()));
            }
        }
    }

    public void selectItem(int index) {
    }

    public int getItemY(int index) {
        int y = this.iScrollY + this.iElementPadding + index * (this.iElementHeight + this.iElementPadding);
        return y;
    }

    public int getActiveItem(int x, int y) {
        int ret = 0;
        if (x >= this.iScrollX && x <= this.iScrollX + this.iScrollW && y >= this.iScrollY && y <= this.iScrollY + this.iScrollH) {
            for (int i = 0; i < this.nameList.size(); ++i) {
                if (y < this.getItemY(i) - this.iScrollListOffset || y > this.getItemY(i + 1) - this.iScrollListOffset) continue;
                ret = i + 1;
            }
        }
        if (ret == 0) {
            ret = this.selectedIndex;
        }
        return ret;
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void onElementDoubleClick(GuiList guilist, Object element, int pos) {
    }
}

