/*
 * Decompiled with CFR 0.152.
 */
package tschipp.bedrockium.dimension;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.SpawnerAnimals;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.ChunkProviderEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import tschipp.bedrockium.BedrockiumMod;

public class ChunkProviderBedrockium
implements IChunkProvider {
    private Random rand;
    private World worldObj;
    private final boolean mapFeaturesEnabled;
    private MapGenBase caveGenerator = new MapGenCaves();
    private MapGenVillage villageGenerator = new MapGenVillage();
    private MapGenBase ravineGenerator = new MapGenRavine();
    private BiomeGenBase[] biomesForGeneration;
    private double[] noiseField;
    double[] noiseData1;
    double[] noiseData2;
    double[] noiseData3;
    double[] noiseData4;
    double[] noiseData5;
    private NoiseGeneratorOctaves bedrockiumNoiseGen1;
    private NoiseGeneratorOctaves bedrockiumNoiseGen2;
    private NoiseGeneratorOctaves bedrockiumNoiseGen3;
    public NoiseGeneratorOctaves bedrockiumNoiseGen6;
    public NoiseGeneratorOctaves bedrockiumNoiseGen7;

    public ChunkProviderBedrockium(World worldObj, long seed, boolean features) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.villageGenerator = (MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)this.villageGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.worldObj = worldObj;
        this.mapFeaturesEnabled = features;
        this.rand = new Random(seed);
    }

    public boolean func_73149_a(int i, int j) {
        return true;
    }

    public Chunk func_73154_d(int i, int j) {
        this.rand.setSeed((long)i * 3418723128712L + (long)j * 1872312328712L);
        byte[] byteArray = new byte[32768];
        Block[] ablock = new Block[65536];
        this.generateTerrain(i, j, byteArray);
        this.biomesForGeneration = this.worldObj.func_72959_q().func_76933_b(this.biomesForGeneration, i * 16, j * 16, 16, 16);
        this.replaceBlocksForBiome(i, j, ablock, this.biomesForGeneration);
        this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, i, j, ablock);
        this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, i, j, ablock);
        if (this.mapFeaturesEnabled) {
            this.villageGenerator.func_75051_a(this.worldObj, this.rand, i, j);
        }
        Chunk chunk = new Chunk(this.worldObj, i, j);
        byte[] byteArray2 = chunk.func_76605_m();
        for (int k = 0; k < byteArray2.length; ++k) {
            byteArray2[k] = (byte)this.biomesForGeneration[k].field_76756_M;
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void replaceBlocksForBiome(int chunkX, int chunkZ, Block[] byteArray, BiomeGenBase[] biomesForGeneration2) {
    }

    public void func_147419_a(int p_147419_1_, int p_147419_2_, Block[] p_147419_3_) {
        int b0 = 4;
        int b1 = 32;
        int k = b0 + 1;
        int b2 = 17;
        int l = b0 + 1;
        this.noiseField = this.initializeNoiseField(this.noiseField, p_147419_1_ * b0, 0, p_147419_2_ * b0, k, b2, l);
        for (int i1 = 0; i1 < b0; ++i1) {
            for (int j1 = 0; j1 < b0; ++j1) {
                for (int k1 = 0; k1 < 16; ++k1) {
                    double d0 = 0.125;
                    double d1 = this.noiseField[((i1 + 0) * l + j1 + 0) * b2 + k1 + 0];
                    double d2 = this.noiseField[((i1 + 0) * l + j1 + 1) * b2 + k1 + 0];
                    double d3 = this.noiseField[((i1 + 1) * l + j1 + 0) * b2 + k1 + 0];
                    double d4 = this.noiseField[((i1 + 1) * l + j1 + 1) * b2 + k1 + 0];
                    double d5 = (this.noiseField[((i1 + 0) * l + j1 + 0) * b2 + k1 + 1] - d1) * d0;
                    double d6 = (this.noiseField[((i1 + 0) * l + j1 + 1) * b2 + k1 + 1] - d2) * d0;
                    double d7 = (this.noiseField[((i1 + 1) * l + j1 + 0) * b2 + k1 + 1] - d3) * d0;
                    double d8 = (this.noiseField[((i1 + 1) * l + j1 + 1) * b2 + k1 + 1] - d4) * d0;
                    for (int l1 = 0; l1 < 8; ++l1) {
                        double d9 = 0.25;
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * d9;
                        double d13 = (d4 - d2) * d9;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            int j2 = i2 + i1 * 4 << 11 | 0 + j1 * 4 << 7 | k1 * 8 + l1;
                            int short1 = 128;
                            double d14 = 0.25;
                            double d15 = d10;
                            double d16 = (d11 - d10) * d14;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                Block block = null;
                                if (k1 * 8 + l1 < b1) {
                                    block = Blocks.field_150353_l;
                                }
                                if (d15 > 0.0) {
                                    block = BedrockiumMod.blockBlastStone;
                                }
                                p_147419_3_[j2] = block;
                                j2 += short1;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
    }

    private double[] initializeNoiseField(double[] p_73164_1_, int p_73164_2_, int p_73164_3_, int p_73164_4_, int p_73164_5_, int p_73164_6_, int p_73164_7_) {
        int i2;
        ChunkProviderEvent.InitNoiseField event = new ChunkProviderEvent.InitNoiseField((IChunkProvider)this, p_73164_1_, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.getResult() == Event.Result.DENY) {
            return event.noisefield;
        }
        if (p_73164_1_ == null) {
            p_73164_1_ = new double[p_73164_5_ * p_73164_6_ * p_73164_7_];
        }
        double d0 = 684.412;
        double d1 = 2053.236;
        this.noiseData4 = this.bedrockiumNoiseGen6.func_76304_a(this.noiseData4, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, 1, p_73164_7_, 1.0, 0.0, 1.0);
        this.noiseData5 = this.bedrockiumNoiseGen7.func_76304_a(this.noiseData5, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, 1, p_73164_7_, 100.0, 0.0, 100.0);
        this.noiseData1 = this.bedrockiumNoiseGen3.func_76304_a(this.noiseData1, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_, d0 / 80.0, d1 / 60.0, d0 / 80.0);
        this.noiseData2 = this.bedrockiumNoiseGen1.func_76304_a(this.noiseData2, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_, d0, d1, d0);
        this.noiseData3 = this.bedrockiumNoiseGen2.func_76304_a(this.noiseData3, p_73164_2_, p_73164_3_, p_73164_4_, p_73164_5_, p_73164_6_, p_73164_7_, d0, d1, d0);
        int k1 = 0;
        int l1 = 0;
        double[] adouble1 = new double[p_73164_6_];
        for (i2 = 0; i2 < p_73164_6_; ++i2) {
            adouble1[i2] = Math.cos((double)i2 * Math.PI * 6.0 / (double)p_73164_6_) * 2.0;
            double d2 = i2;
            if (i2 > p_73164_6_ / 2) {
                d2 = p_73164_6_ - 1 - i2;
            }
            if (!(d2 < 4.0)) continue;
            d2 = 4.0 - d2;
            int n = i2;
            adouble1[n] = adouble1[n] - d2 * d2 * d2 * 10.0;
        }
        for (i2 = 0; i2 < p_73164_5_; ++i2) {
            for (int k2 = 0; k2 < p_73164_7_; ++k2) {
                double d3 = (this.noiseData4[l1] + 256.0) / 512.0;
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                double d4 = 0.0;
                double d5 = this.noiseData5[l1] / 8000.0;
                if (d5 < 0.0) {
                    d5 = -d5;
                }
                if ((d5 = d5 * 3.0 - 3.0) < 0.0) {
                    if ((d5 /= 2.0) < -1.0) {
                        d5 = -1.0;
                    }
                    d5 /= 1.4;
                    d5 /= 2.0;
                    d3 = 0.0;
                } else {
                    if (d5 > 1.0) {
                        d5 = 1.0;
                    }
                    d5 /= 6.0;
                }
                d3 += 0.5;
                d5 = d5 * (double)p_73164_6_ / 16.0;
                ++l1;
                for (int j2 = 0; j2 < p_73164_6_; ++j2) {
                    double d11;
                    double d6 = 0.0;
                    double d7 = adouble1[j2];
                    double d8 = this.noiseData2[k1] / 512.0;
                    double d9 = this.noiseData3[k1] / 512.0;
                    double d10 = (this.noiseData1[k1] / 10.0 + 1.0) / 2.0;
                    d6 = d10 < 0.0 ? d8 : (d10 > 1.0 ? d9 : d8 + (d9 - d8) * d10);
                    d6 -= d7;
                    if (j2 > p_73164_6_ - 4) {
                        d11 = (float)(j2 - (p_73164_6_ - 4)) / 3.0f;
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    if ((double)j2 < d4) {
                        d11 = (d4 - (double)j2) / 4.0;
                        if (d11 < 0.0) {
                            d11 = 0.0;
                        }
                        if (d11 > 1.0) {
                            d11 = 1.0;
                        }
                        d6 = d6 * (1.0 - d11) + -10.0 * d11;
                    }
                    p_73164_1_[k1] = d6;
                    ++k1;
                }
            }
        }
        return p_73164_1_;
    }

    public void generateTerrain(int i, int j, byte[] byteArray) {
    }

    public Chunk func_73158_c(int i, int j) {
        return this.func_73154_d(i, j);
    }

    public void func_73153_a(IChunkProvider provider, int i, int j) {
        int i2;
        int l1;
        int k1;
        BlockSand.field_149832_M = true;
        int k = i * 16;
        int l = j * 16;
        BiomeGenBase biome = this.worldObj.func_72807_a(k + 16, l + 16);
        this.rand.setSeed(this.worldObj.func_72905_C());
        long i1 = this.rand.nextLong() / 2L * 2L + 1L;
        long j1 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)i * i1 + (long)j * j1 ^ this.worldObj.func_72905_C());
        boolean flag = false;
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(provider, this.worldObj, this.rand, i, j, flag));
        if (this.mapFeaturesEnabled) {
            flag = this.villageGenerator.func_75051_a(this.worldObj, this.rand, i, j);
        }
        if (biome != BiomeGenBase.field_76769_d && biome != BiomeGenBase.field_76786_s && !flag && this.rand.nextInt(4) == 0 && TerrainGen.populate((IChunkProvider)provider, (World)this.worldObj, (Random)this.rand, (int)i, (int)j, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            k1 = k + this.rand.nextInt(16) + 8;
            l1 = this.rand.nextInt(128);
            i2 = l + this.rand.nextInt(16) + 8;
            new WorldGenLakes(Blocks.field_150353_l).func_76484_a(this.worldObj, this.rand, k1, l1, i2);
        }
        boolean doGen = TerrainGen.populate((IChunkProvider)provider, (World)this.worldObj, (Random)this.rand, (int)i, (int)j, (boolean)flag, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON);
        for (k1 = 0; doGen && k1 < 8; ++k1) {
            l1 = k + this.rand.nextInt(16) + 8;
            i2 = l + this.rand.nextInt(128) + 8;
            int j2 = l + this.rand.nextInt(16) + 8;
            new WorldGenDungeons().func_76484_a(this.worldObj, this.rand, l1, i2, j2);
        }
        biome.func_76728_a(this.worldObj, this.rand, k, l);
        SpawnerAnimals.func_77191_a((World)this.worldObj, (BiomeGenBase)biome, (int)(k + 8), (int)(l + 8), (int)16, (int)16, (Random)this.rand);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(provider, this.worldObj, this.rand, i, j, flag));
        BlockSand.field_149832_M = false;
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate progress) {
        return true;
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "RandomLevelSource";
    }

    public ChunkPosition func_147416_a(World world, String s, int i, int j, int k) {
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int i, int j) {
        if (this.mapFeaturesEnabled) {
            this.villageGenerator.func_75051_a(this.worldObj, this.rand, i, j);
        }
    }

    public void func_104112_b() {
    }

    public List func_73155_a(EnumCreatureType p_73155_1_, int p_73155_2_, int p_73155_3_, int p_73155_4_) {
        return null;
    }
}

