/*
 * Decompiled with CFR 0.152.
 */
package jcm2606.thaumicmachina.wand;

import java.util.HashMap;
import jcm2606.thaumicmachina.core.crafting.infusion.RecipeInfusionWandAugmentation;
import jcm2606.thaumicmachina.core.helper.NBTHelper;
import jcm2606.thaumicmachina.core.implement.IAugmentationWand;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import thaumcraft.api.ItemApi;
import thaumcraft.api.crafting.InfusionRecipe;

public class WandHelper {
    public static final HashMap<String, IAugmentationWand> augmentationMap = new HashMap();

    public static void registerAugmentation(IAugmentationWand augmentation) {
        if (!augmentationMap.containsKey(augmentation.getAugmentationName())) {
            augmentationMap.put(augmentation.getAugmentationName(), augmentation);
        }
    }

    public static InfusionRecipe buildInfusionRecipe(IAugmentationWand augmentation, boolean isResearchRecipe) {
        return new RecipeInfusionWandAugmentation(augmentation, isResearchRecipe);
    }

    public static ItemStack buildWandItemStackWithAugmentations(IAugmentationWand[] augmentations) {
        ItemStack stack = ItemApi.getItem("itemWandCasting", Short.MAX_VALUE);
        WandHelper.addAugmentationsTo(stack, augmentations, false);
        return stack;
    }

    public static boolean hasAugmentations(ItemStack stack) {
        NBTTagCompound compound;
        boolean b = false;
        if (stack.func_77978_p() != null && (compound = NBTHelper.getCompoundFor(stack)).func_74764_b("Augmentations")) {
            b = true;
        }
        return b;
    }

    public static boolean hasAugmentation(ItemStack stack, IAugmentationWand augmentation) {
        NBTTagCompound compound;
        boolean b = false;
        if (stack.func_77978_p() != null && (compound = NBTHelper.getCompoundFor(stack)).func_74764_b("Augmentations")) {
            NBTTagList list = compound.func_150295_c("Augmentations", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                String tag = list.func_150307_f(i);
                if (tag == null || !tag.equals(augmentation.getAugmentationName())) continue;
                b = true;
            }
        }
        return b;
    }

    public static String[] getAugmentationNames(ItemStack stack) {
        NBTTagCompound compound;
        String[] slist = null;
        int index = 0;
        if (stack.func_77978_p() != null && (compound = NBTHelper.getCompoundFor(stack)).func_74764_b("Augmentations")) {
            NBTTagList list = compound.func_150295_c("Augmentations", 8);
            slist = new String[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                String tag;
                if (list.func_150307_f(i) == null || (tag = list.func_150307_f(i)) == null) continue;
                slist[index] = tag;
                ++index;
            }
        }
        return slist;
    }

    public static ItemStack addAugmentationsTo(ItemStack inputStack, IAugmentationWand[] augmentations, boolean duplicateItemStack) {
        ItemStack stack = inputStack;
        if (duplicateItemStack) {
            stack = inputStack.func_77946_l();
        }
        NBTTagCompound compound = NBTHelper.getCompoundFor(stack);
        NBTTagList list = new NBTTagList();
        if (compound.func_150295_c("Augmentations", 8) != null) {
            list = compound.func_150295_c("Augmentations", 8);
        }
        for (IAugmentationWand augmentation : augmentations) {
            NBTTagString tag = new NBTTagString(augmentation.getAugmentationName());
            list.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("Augmentations", (NBTBase)list);
        return stack;
    }

    public static ItemStack removeAugmentationsFrom(ItemStack inputStack, IAugmentationWand[] augmentations, boolean duplicateItemStack) {
        ItemStack stack = inputStack;
        if (duplicateItemStack) {
            stack = inputStack.func_77946_l();
        }
        NBTTagCompound compound = NBTHelper.getCompoundFor(stack);
        NBTTagList list = new NBTTagList();
        if (compound.func_150295_c("Augmentations", 8) != null) {
            list = compound.func_150295_c("Augmentations", 8);
        }
        for (IAugmentationWand augmentation : augmentations) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                String tag = list.func_150307_f(i);
                if (!tag.equals(augmentation.getAugmentationName())) continue;
                list.func_74744_a(i);
            }
        }
        compound.func_74782_a("Augmentations", (NBTBase)list);
        return stack;
    }
}

