/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api;

import cpw.mods.fml.common.FMLLog;
import java.lang.reflect.Method;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaTransport;

public class ThaumcraftApiHelper {
    static Method isResearchComplete;
    static Method getObjectTags;
    static Method getBonusTags;
    static Method generateTags;
    private static HashMap<Integer, AspectList> allAspects;
    private static HashMap<Integer, AspectList> allCompoundAspects;
    static Method consumeVisFromWand;
    static Method consumeVisFromWandCrafting;
    static Method consumeVisFromInventory;
    static Method addWarpToPlayer;
    static Method addStickyWarpToPlayer;

    public static AspectList cullTags(AspectList temp) {
        AspectList temp2 = new AspectList();
        for (Aspect tag : temp.getAspects()) {
            if (tag == null) continue;
            temp2.add(tag, temp.getAmount(tag));
        }
        while (temp2 != null && temp2.size() > 10) {
            Aspect lowest = null;
            int low = Integer.MAX_VALUE;
            for (Aspect tag : temp2.getAspects()) {
                if (tag == null || temp2.getAmount(tag) >= low) continue;
                low = temp2.getAmount(tag);
                lowest = tag;
            }
            temp2.aspects.remove(lowest);
        }
        return temp2;
    }

    public static boolean areItemsEqual(ItemStack s1, ItemStack s2) {
        if (s1.func_77984_f() && s2.func_77984_f()) {
            return s1.func_77973_b() == s2.func_77973_b();
        }
        return s1.func_77973_b() == s2.func_77973_b() && s1.func_77960_j() == s2.func_77960_j();
    }

    public static boolean isResearchComplete(String username, String researchkey) {
        boolean ot = false;
        try {
            if (isResearchComplete == null) {
                Class<?> fake = Class.forName("thaumcraft.common.lib.research.ResearchManager");
                isResearchComplete = fake.getMethod("isResearchComplete", String.class, String.class);
            }
            ot = (Boolean)isResearchComplete.invoke(null, username, researchkey);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.lib.research.ResearchManager method isResearchComplete", (Object[])new Object[0]);
        }
        return ot;
    }

    public static ItemStack getStackInRowAndColumn(Object instance, int row, int column) {
        ItemStack ot = null;
        try {
            Class<?> fake = Class.forName("thaumcraft.common.tiles.TileMagicWorkbench");
            Method getStackInRowAndColumn = fake.getMethod("getStackInRowAndColumn", Integer.TYPE, Integer.TYPE);
            ot = (ItemStack)getStackInRowAndColumn.invoke(instance, row, column);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.tiles.TileMagicWorkbench method getStackInRowAndColumn", (Object[])new Object[0]);
        }
        return ot;
    }

    public static AspectList getObjectAspects(ItemStack is) {
        AspectList ot = null;
        try {
            if (getObjectTags == null) {
                Class<?> fake = Class.forName("thaumcraft.common.lib.crafting.ThaumcraftCraftingManager");
                getObjectTags = fake.getMethod("getObjectTags", ItemStack.class);
            }
            ot = (AspectList)getObjectTags.invoke(null, is);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.lib.crafting.ThaumcraftCraftingManager method getObjectTags", (Object[])new Object[0]);
        }
        return ot;
    }

    public static AspectList getBonusObjectTags(ItemStack is, AspectList ot) {
        try {
            if (getBonusTags == null) {
                Class<?> fake = Class.forName("thaumcraft.common.lib.crafting.ThaumcraftCraftingManager");
                getBonusTags = fake.getMethod("getBonusTags", ItemStack.class, AspectList.class);
            }
            ot = (AspectList)getBonusTags.invoke(null, is, ot);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.lib.crafting.ThaumcraftCraftingManager method getBonusTags", (Object[])new Object[0]);
        }
        return ot;
    }

    public static AspectList generateTags(Item item, int meta) {
        try {
            if (generateTags == null) {
                Class<?> fake = Class.forName("thaumcraft.common.lib.crafting.ThaumcraftCraftingManager");
                generateTags = fake.getMethod("generateTags", Item.class, Integer.TYPE);
            }
            return (AspectList)generateTags.invoke(null, item, meta);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.lib.crafting.ThaumcraftCraftingManager method generateTags", (Object[])new Object[0]);
            return null;
        }
    }

    public static boolean containsMatch(boolean strict, ItemStack[] inputs, ItemStack ... targets) {
        for (ItemStack input : inputs) {
            for (ItemStack target : targets) {
                if (!ThaumcraftApiHelper.itemMatches(target, input, strict)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean areItemStackTagsEqualForCrafting(ItemStack slotItem, ItemStack recipeItem) {
        if (recipeItem == null || slotItem == null) {
            return false;
        }
        if (recipeItem.field_77990_d != null && slotItem.field_77990_d == null) {
            return false;
        }
        if (recipeItem.field_77990_d == null) {
            return true;
        }
        for (String s : recipeItem.field_77990_d.func_150296_c()) {
            if (slotItem.field_77990_d.func_74764_b(s)) {
                if (slotItem.field_77990_d.func_74781_a(s).toString().equals(recipeItem.field_77990_d.func_74781_a(s).toString())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public static boolean itemMatches(ItemStack target, ItemStack input, boolean strict) {
        if (input == null && target != null || input != null && target == null) {
            return false;
        }
        return target.func_77973_b() == input.func_77973_b() && (target.func_77960_j() == Short.MAX_VALUE && !strict || target.func_77960_j() == input.func_77960_j());
    }

    public static TileEntity getConnectableTile(World world, int x, int y, int z, ForgeDirection face) {
        TileEntity te = world.func_147438_o(x + face.offsetX, y + face.offsetY, z + face.offsetZ);
        if (te instanceof IEssentiaTransport && ((IEssentiaTransport)te).isConnectable(face.getOpposite())) {
            return te;
        }
        return null;
    }

    public static TileEntity getConnectableTile(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        TileEntity te = world.func_147438_o(x + face.offsetX, y + face.offsetY, z + face.offsetZ);
        if (te instanceof IEssentiaTransport && ((IEssentiaTransport)te).isConnectable(face.getOpposite())) {
            return te;
        }
        return null;
    }

    public static AspectList getAllAspects(int amount) {
        if (allAspects.get(amount) == null) {
            AspectList al = new AspectList();
            for (Aspect aspect : Aspect.aspects.values()) {
                al.add(aspect, amount);
            }
            allAspects.put(amount, al);
        }
        return allAspects.get(amount);
    }

    public static AspectList getAllCompoundAspects(int amount) {
        if (allCompoundAspects.get(amount) == null) {
            AspectList al = new AspectList();
            for (Aspect aspect : Aspect.getCompoundAspects()) {
                al.add(aspect, amount);
            }
            allCompoundAspects.put(amount, al);
        }
        return allCompoundAspects.get(amount);
    }

    public static boolean consumeVisFromWand(ItemStack wand, EntityPlayer player, AspectList cost, boolean doit, boolean crafting) {
        boolean ot = false;
        try {
            if (consumeVisFromWand == null) {
                Class<?> fake = Class.forName("thaumcraft.common.items.wands.ItemWandCasting");
                consumeVisFromWand = fake.getMethod("consumeAllVis", ItemStack.class, EntityPlayer.class, AspectList.class, Boolean.TYPE, Boolean.TYPE);
            }
            ot = (Boolean)consumeVisFromWand.invoke(consumeVisFromWand.getDeclaringClass().cast(wand.func_77973_b()), wand, player, cost, doit, crafting);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.items.wands.ItemWandCasting method consumeAllVis", (Object[])new Object[0]);
        }
        return ot;
    }

    public static boolean consumeVisFromWandCrafting(ItemStack wand, EntityPlayer player, AspectList cost, boolean doit) {
        boolean ot = false;
        try {
            if (consumeVisFromWandCrafting == null) {
                Class<?> fake = Class.forName("thaumcraft.common.items.wands.ItemWandCasting");
                consumeVisFromWandCrafting = fake.getMethod("consumeAllVisCrafting", ItemStack.class, EntityPlayer.class, AspectList.class, Boolean.TYPE);
            }
            ot = (Boolean)consumeVisFromWandCrafting.invoke(consumeVisFromWandCrafting.getDeclaringClass().cast(wand.func_77973_b()), wand, player, cost, doit);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.items.wands.ItemWandCasting method consumeAllVisCrafting", (Object[])new Object[0]);
        }
        return ot;
    }

    public static boolean consumeVisFromInventory(EntityPlayer player, AspectList cost) {
        boolean ot = false;
        try {
            if (consumeVisFromInventory == null) {
                Class<?> fake = Class.forName("thaumcraft.common.items.wands.WandManager");
                consumeVisFromInventory = fake.getMethod("consumeVisFromInventory", EntityPlayer.class, AspectList.class);
            }
            ot = (Boolean)consumeVisFromInventory.invoke(null, player, cost);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.items.wands.WandManager method consumeVisFromInventory", (Object[])new Object[0]);
        }
        return ot;
    }

    public static void addWarpToPlayer(EntityPlayer player, int amount, boolean temporary) {
        boolean ot = false;
        try {
            if (addWarpToPlayer == null) {
                Class<?> fake = Class.forName("thaumcraft.common.Thaumcraft");
                addWarpToPlayer = fake.getMethod("addWarpToPlayer", EntityPlayer.class, Integer.TYPE, Boolean.TYPE);
            }
            addWarpToPlayer.invoke(null, player, amount, temporary);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.Thaumcraft method addWarpToPlayer", (Object[])new Object[0]);
        }
    }

    public static void addStickyWarpToPlayer(EntityPlayer player, int amount) {
        boolean ot = false;
        try {
            if (addStickyWarpToPlayer == null) {
                Class<?> fake = Class.forName("thaumcraft.common.Thaumcraft");
                addStickyWarpToPlayer = fake.getMethod("addStickyWarpToPlayer", EntityPlayer.class, Integer.TYPE);
            }
            addStickyWarpToPlayer.invoke(null, player, amount);
        }
        catch (Exception ex) {
            FMLLog.warning((String)"[Thaumcraft API] Could not invoke thaumcraft.common.Thaumcraft method addStickyWarpToPlayer", (Object[])new Object[0]);
        }
    }

    static {
        allAspects = new HashMap();
        allCompoundAspects = new HashMap();
    }
}

