/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import java.util.Iterator;

public class BlockAreaIterator
implements Iterator<BlockCoord> {
    private BlockCoord lower;
    private BlockCoord higher;
    private int curX;
    private int curY;
    private int curZ;

    public BlockAreaIterator(BlockCoord lower, BlockCoord higher) {
        this.lower = lower;
        this.higher = higher;
        this.curX = lower.x;
        this.curY = lower.y;
        this.curZ = lower.z;
    }

    public BlockAreaIterator(BlockArea area) {
        this(area.getLowerCorner(), area.getHigherCorner());
    }

    @Override
    public boolean hasNext() {
        return this.curX <= this.higher.x && this.curY <= this.higher.y && this.curZ <= this.higher.z;
    }

    @Override
    public BlockCoord next() {
        BlockCoord retVal = this.hasNext() ? new BlockCoord(this.curX, this.curY, this.curZ) : null;
        ++this.curX;
        if (this.curX > this.higher.x) {
            this.curX = this.lower.x;
            ++this.curY;
            if (this.curY > this.higher.y) {
                this.curY = this.lower.y;
                ++this.curZ;
            }
        }
        return retVal;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

