/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.tools.IvGsonHelper;
import javax.annotation.Nullable;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.ArrayUtils;

public class Directions {
    public static final ForgeDirection[] HORIZONTAL = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    public static final ForgeDirection[] X_AXIS = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.WEST};
    public static final ForgeDirection[] Y_AXIS = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    public static final ForgeDirection[] Z_AXIS = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.NORTH};

    @Nullable
    public static Integer getHorizontalClockwiseRotations(ForgeDirection source, ForgeDirection dest, boolean mirrorX) {
        if (source == dest) {
            return mirrorX && ArrayUtils.contains((Object[])X_AXIS, (Object)dest) ? 2 : 0;
        }
        int arrayIndexSrc = ArrayUtils.indexOf((Object[])HORIZONTAL, (Object)source);
        int arrayIndexDst = ArrayUtils.indexOf((Object[])HORIZONTAL, (Object)dest);
        if (arrayIndexSrc >= 0 && arrayIndexDst >= 0) {
            int mirrorRotations = mirrorX && ArrayUtils.contains((Object[])X_AXIS, (Object)dest) ? 2 : 0;
            return (arrayIndexSrc - arrayIndexDst + mirrorRotations + HORIZONTAL.length) % HORIZONTAL.length;
        }
        return null;
    }

    public static ForgeDirection rotate(ForgeDirection direction, AxisAlignedTransform2D transform) {
        if (direction == ForgeDirection.UP || direction == ForgeDirection.DOWN) {
            return direction;
        }
        int rotations = transform.getRotation();
        if (transform.isMirrorX() && ArrayUtils.contains((Object[])X_AXIS, (Object)direction)) {
            rotations += 2;
        }
        return HORIZONTAL[(ArrayUtils.indexOf((Object[])HORIZONTAL, (Object)direction) + rotations) % HORIZONTAL.length];
    }

    public static ForgeDirection deserialize(String id) {
        ForgeDirection direction = (ForgeDirection)IvGsonHelper.enumForNameIgnoreCase((String)id, (Enum[])ForgeDirection.values());
        return direction != null ? direction : ForgeDirection.NORTH;
    }

    public static ForgeDirection deserializeHorizontal(String id) {
        ForgeDirection direction = (ForgeDirection)IvGsonHelper.enumForNameIgnoreCase((String)id, (Enum[])HORIZONTAL);
        return direction != null ? direction : ForgeDirection.NORTH;
    }

    public static String serialize(ForgeDirection direction) {
        return IvGsonHelper.serializedName((Enum)direction);
    }

    public static ForgeDirection getDirectionFromVRotation(int front) {
        switch (front) {
            default: {
                return ForgeDirection.SOUTH;
            }
            case 1: {
                return ForgeDirection.EAST;
            }
            case 2: {
                return ForgeDirection.NORTH;
            }
            case 3: 
        }
        return ForgeDirection.WEST;
    }
}

