/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze.components;

import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.maze.components.MazePassage;
import ivorius.ivtoolkit.maze.components.MazeRoom;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MazeRooms {
    public static MazeRoom rotated(MazeRoom room, AxisAlignedTransform2D transform, int[] size) {
        if (room.getDimensions() < 3) {
            throw new IllegalArgumentException();
        }
        int[] roomPosition = room.getCoordinates();
        int[] transformedRoom = transform.apply(roomPosition, size);
        roomPosition[0] = transformedRoom[0];
        roomPosition[1] = transformedRoom[1];
        roomPosition[2] = transformedRoom[2];
        return new MazeRoom(roomPosition);
    }

    public static Stream<MazeRoom> neighbors(MazeRoom room, IntStream dimensions) {
        return dimensions.mapToObj(d -> IntStream.of(1, -1).mapToObj(m -> room.addInDimension(d, m))).flatMap(t -> t);
    }

    public static Stream<MazeRoom> neighbors(MazeRoom room) {
        return MazeRooms.neighbors(room, IntStream.range(0, room.getDimensions()));
    }

    public static Stream<MazePassage> neighborPassages(MazeRoom room, IntStream dimensions) {
        return MazeRooms.neighbors(room, dimensions).map(r -> new MazePassage(room, (MazeRoom)r));
    }

    public static Stream<MazePassage> neighborPassages(MazeRoom room) {
        return MazeRooms.neighbors(room).map(r -> new MazePassage(room, (MazeRoom)r));
    }
}

