/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.models.attributes;

import ivorius.ivtoolkit.models.Attribute;

public class FloatAttribute
extends Attribute {
    public static final String ShininessAlias = "shininess";
    public static final long Shininess = FloatAttribute.register("shininess");
    public static final String AlphaTestAlias = "alphaTest";
    public static final long AlphaTest = FloatAttribute.register("alphaTest");
    public float value;

    public static FloatAttribute createShininess(float value) {
        return new FloatAttribute(Shininess, value);
    }

    public static FloatAttribute createAlphaTest(float value) {
        return new FloatAttribute(AlphaTest, value);
    }

    public FloatAttribute(long type) {
        super(type);
    }

    public FloatAttribute(long type, float value) {
        super(type);
        this.value = value;
    }

    @Override
    public Attribute copy() {
        return new FloatAttribute(this.type, this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FloatAttribute that = (FloatAttribute)o;
        return Float.compare(that.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.value != 0.0f ? Float.floatToIntBits(this.value) : 0);
        return result;
    }
}

