/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.models.utils;

import java.util.Random;
import net.minecraft.util.MathHelper;

public class MathUtils {
    public static int floorInt(double value) {
        int i = (int)value;
        return value < (double)i ? i - 1 : i;
    }

    public static int floorInt(float value) {
        int i = (int)value;
        return value < (float)i ? i - 1 : i;
    }

    public static float sqrt(float value) {
        return (float)Math.sqrt(value);
    }

    public static double sqrt(double value) {
        return Math.sqrt(value);
    }

    public static float sin(float value) {
        return MathHelper.func_76126_a((float)value);
    }

    public static double sin(double value) {
        return MathHelper.func_76126_a((float)((float)value));
    }

    public static float cos(float value) {
        return MathHelper.func_76134_b((float)value);
    }

    public static double cos(double value) {
        return MathHelper.func_76134_b((float)((float)value));
    }

    public static float mix(float value1, float value2, float progress) {
        return value1 + (value2 - value1) * progress;
    }

    public static double mix(double value1, double value2, double progress) {
        return value1 + (value2 - value1) * progress;
    }

    public static double mixEaseInOut(double value1, double value2, double progress) {
        return MathUtils.cubicMix(value1, value1, value2, value2, progress);
    }

    public static double easeZeroToOne(double progress) {
        return MathUtils.cubicMix(0.0, 0.0, 1.0, 1.0, MathUtils.clamp(0.0, progress, 1.0));
    }

    public static double quadraticMix(double value1, double value2, double value3, double progress) {
        return MathUtils.mix(MathUtils.mix(value1, value2, progress), MathUtils.mix(value2, value3, progress), progress);
    }

    public static double cubicMix(double value1, double value2, double value3, double value4, double progress) {
        return MathUtils.mix(MathUtils.quadraticMix(value1, value2, value3, progress), MathUtils.quadraticMix(value2, value3, value4, progress), progress);
    }

    public static float clamp(float min, float value, float max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clamp(double min, double value, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static float approachValue(float value, float dest, float mulSpeed, float plusSpeed) {
        if ((value += (dest - value) * mulSpeed) > dest) {
            if ((value -= plusSpeed) < dest) {
                value = dest;
            }
        } else if (value < dest && (value += plusSpeed) > dest) {
            value = dest;
        }
        return value;
    }

    public static double approachValue(double value, double dest, double mulSpeed, double plusSpeed) {
        if ((value += (dest - value) * mulSpeed) > dest) {
            if ((value -= plusSpeed) < dest) {
                value = dest;
            }
        } else if (value < dest && (value += plusSpeed) > dest) {
            value = dest;
        }
        return value;
    }

    public static int randomLinearNumber(Random random, float number) {
        return MathUtils.floorInt(number) + (random.nextFloat() < number % 1.0f ? 1 : 0);
    }

    public static float zeroToOne(float value, float min, float max) {
        return MathUtils.clamp(0.0f, (value - min) / (max - min), 1.0f);
    }
}

