/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.rendering.grid;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import net.minecraft.client.renderer.Tessellator;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AreaRenderer {
    public static void renderAreaLined(BlockArea area, float sizeP) {
        AreaRenderer.renderArea(area, true, false, sizeP);
    }

    public static void renderArea(BlockArea area, boolean lined, boolean insides, float sizeP) {
        AreaRenderer.drawCuboid(area.getLowerCorner(), area.getHigherCorner().add(1, 1, 1), lined, insides, sizeP);
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawCuboid(BlockCoord min, BlockCoord max, boolean lined, boolean insides, float sizeP) {
        float width2 = ((float)max.x - (float)min.x) * 0.5f;
        float height2 = ((float)max.y - (float)min.y) * 0.5f;
        float length2 = ((float)max.z - (float)min.z) * 0.5f;
        double centerX = (float)min.x + width2;
        double centerY = (float)min.y + height2;
        double centerZ = (float)min.z + length2;
        int sizeCE = insides ? -1 : 1;
        GL11.glPushMatrix();
        GL11.glTranslated((double)centerX, (double)centerY, (double)centerZ);
        if (lined) {
            GL11.glDisable((int)3553);
            AreaRenderer.drawLineCuboid(Tessellator.field_78398_a, width2 + sizeP, height2 + sizeP, length2 + sizeP, 1.0f);
            GL11.glEnable((int)3553);
        } else {
            AreaRenderer.drawCuboid(Tessellator.field_78398_a, width2 * (float)sizeCE + sizeP, height2 * (float)sizeCE + sizeP, length2 * (float)sizeCE + sizeP, 1.0f);
        }
        GL11.glPopMatrix();
    }

    public static void drawCuboid(Tessellator tessellator, float sizeX, float sizeY, float sizeZ, float in) {
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(-sizeX * in), (double)(-sizeY * in), (double)(-sizeZ), 0.0, 0.0);
        tessellator.func_78374_a((double)(-sizeX * in), (double)(sizeY * in), (double)(-sizeZ), 0.0, 1.0);
        tessellator.func_78374_a((double)(sizeX * in), (double)(sizeY * in), (double)(-sizeZ), 1.0, 1.0);
        tessellator.func_78374_a((double)(sizeX * in), (double)(-sizeY * in), (double)(-sizeZ), 1.0, 0.0);
        tessellator.func_78374_a((double)(-sizeX * in), (double)(-sizeY * in), (double)sizeZ, 0.0, 0.0);
        tessellator.func_78374_a((double)(sizeX * in), (double)(-sizeY * in), (double)sizeZ, 1.0, 0.0);
        tessellator.func_78374_a((double)(sizeX * in), (double)(sizeY * in), (double)sizeZ, 1.0, 1.0);
        tessellator.func_78374_a((double)(-sizeX * in), (double)(sizeY * in), (double)sizeZ, 0.0, 1.0);
        tessellator.func_78374_a((double)(-sizeX), (double)(-sizeY * in), (double)(-sizeZ * in), 0.0, 0.0);
        tessellator.func_78374_a((double)(-sizeX), (double)(-sizeY * in), (double)(sizeZ * in), 0.0, 1.0);
        tessellator.func_78374_a((double)(-sizeX), (double)(sizeY * in), (double)(sizeZ * in), 1.0, 1.0);
        tessellator.func_78374_a((double)(-sizeX), (double)(sizeY * in), (double)(-sizeZ * in), 1.0, 0.0);
        tessellator.func_78374_a((double)sizeX, (double)(-sizeY * in), (double)(-sizeZ * in), 0.0, 0.0);
        tessellator.func_78374_a((double)sizeX, (double)(sizeY * in), (double)(-sizeZ * in), 0.0, 1.0);
        tessellator.func_78374_a((double)sizeX, (double)(sizeY * in), (double)(sizeZ * in), 1.0, 1.0);
        tessellator.func_78374_a((double)sizeX, (double)(-sizeY * in), (double)(sizeZ * in), 1.0, 0.0);
        tessellator.func_78374_a((double)(-sizeX * in), (double)sizeY, (double)(-sizeZ * in), 0.0, 0.0);
        tessellator.func_78374_a((double)(-sizeX * in), (double)sizeY, (double)(sizeZ * in), 0.0, 1.0);
        tessellator.func_78374_a((double)(sizeX * in), (double)sizeY, (double)(sizeZ * in), 1.0, 1.0);
        tessellator.func_78374_a((double)(sizeX * in), (double)sizeY, (double)(-sizeZ * in), 1.0, 0.0);
        tessellator.func_78374_a((double)(-sizeX * in), (double)(-sizeY), (double)(-sizeZ * in), 0.0, 0.0);
        tessellator.func_78374_a((double)(sizeX * in), (double)(-sizeY), (double)(-sizeZ * in), 1.0, 0.0);
        tessellator.func_78374_a((double)(sizeX * in), (double)(-sizeY), (double)(sizeZ * in), 1.0, 1.0);
        tessellator.func_78374_a((double)(-sizeX * in), (double)(-sizeY), (double)(sizeZ * in), 0.0, 1.0);
        tessellator.func_78381_a();
    }

    public static void drawLineCuboid(Tessellator tessellator, float sizeX, float sizeY, float sizeZ, float in) {
        tessellator.func_78371_b(3);
        tessellator.func_78377_a((double)(-sizeX * in), (double)(-sizeY * in), (double)(-sizeZ));
        tessellator.func_78377_a((double)(-sizeX * in), (double)(sizeY * in), (double)(-sizeZ));
        tessellator.func_78377_a((double)(sizeX * in), (double)(sizeY * in), (double)(-sizeZ));
        tessellator.func_78377_a((double)(sizeX * in), (double)(-sizeY * in), (double)(-sizeZ));
        tessellator.func_78377_a((double)(-sizeX * in), (double)(-sizeY * in), (double)(-sizeZ));
        tessellator.func_78377_a((double)(-sizeX * in), (double)(-sizeY * in), (double)sizeZ);
        tessellator.func_78377_a((double)(-sizeX * in), (double)(sizeY * in), (double)sizeZ);
        tessellator.func_78377_a((double)(sizeX * in), (double)(sizeY * in), (double)sizeZ);
        tessellator.func_78377_a((double)(sizeX * in), (double)(-sizeY * in), (double)sizeZ);
        tessellator.func_78377_a((double)(-sizeX * in), (double)(-sizeY * in), (double)sizeZ);
        tessellator.func_78381_a();
        tessellator.func_78371_b(1);
        tessellator.func_78377_a((double)(-sizeX * in), (double)(sizeY * in), (double)(-sizeZ));
        tessellator.func_78377_a((double)(-sizeX * in), (double)(sizeY * in), (double)sizeZ);
        tessellator.func_78377_a((double)(sizeX * in), (double)(sizeY * in), (double)(-sizeZ));
        tessellator.func_78377_a((double)(sizeX * in), (double)(sizeY * in), (double)sizeZ);
        tessellator.func_78377_a((double)(sizeX * in), (double)(-sizeY * in), (double)(-sizeZ));
        tessellator.func_78377_a((double)(sizeX * in), (double)(-sizeY * in), (double)sizeZ);
        tessellator.func_78381_a();
    }
}

